/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.Keymap;
import javax.swing.text.NavigationFilter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class JTextComponent
extends JComponent
implements Scrollable,
Accessible {
    private static final long serialVersionUID = -8796518220218978795L;
    public static final String DEFAULT_KEYMAP = "default";
    public static final String FOCUS_ACCELERATOR_KEY = "focusAcceleratorKey";
    private static DefaultTransferHandler defaultTransferHandler;
    private static Hashtable keymaps;
    private Keymap keymap;
    private char focusAccelerator;
    private NavigationFilter navigationFilter;
    Document doc;
    Caret caret;
    boolean editable;
    private Highlighter highlighter;
    private Color caretColor;
    private Color disabledTextColor;
    private Color selectedTextColor;
    private Color selectionColor;
    private Insets margin;
    private boolean dragEnabled;
    static /* synthetic */ Class class$javax$swing$event$CaretListener;
    static /* synthetic */ Class class$java$awt$event$InputMethodListener;

    public static Keymap getKeymap(String string) {
        return (Keymap)keymaps.get(string);
    }

    public static Keymap removeKeymap(String string) {
        Keymap keymap = (Keymap)keymaps.get(string);
        keymaps.remove(string);
        return keymap;
    }

    public static Keymap addKeymap(String string, Keymap keymap) {
        DefaultKeymap defaultKeymap = new DefaultKeymap(string);
        defaultKeymap.setResolveParent(keymap);
        if (string != null) {
            keymaps.put(string, defaultKeymap);
        }
        return defaultKeymap;
    }

    public Keymap getKeymap() {
        return this.keymap;
    }

    /*
     * Unable to fully structure code
     */
    public void setKeymap(Keymap var1_1) {
        block17: {
            block16: {
                var2_2 = var1_1 == null ? null : new KeymapWrapper(var1_1);
                var3_3 = this.getInputMap(0);
                if (var3_3 != null) ** GOTO lbl7
                this.setInputMap(0, var2_2);
                break block16;
lbl-1000:
                // 1 sources

                {
                    var3_3 = var3_3.getParent();
lbl7:
                    // 2 sources

                    ** while (var3_3.getParent() != null && !(var3_3.getParent() instanceof KeymapWrapper) && !(var3_3.getParent() instanceof InputMapUIResource))
                }
lbl8:
                // 1 sources

                if (var3_3.getParent() == null) {
                    var3_3.setParent(var2_2);
                } else if (var3_3.getParent() instanceof KeymapWrapper) {
                    if (var2_2 == null) {
                        var3_3.setParent(var3_3.getParent().getParent());
                    } else {
                        var2_2.setParent(var3_3.getParent().getParent());
                        var3_3.setParent(var2_2);
                    }
                } else if (var3_3.getParent() instanceof InputMapUIResource && var2_2 != null) {
                    var2_2.setParent(var3_3.getParent());
                    var3_3.setParent(var2_2);
                }
            }
            var4_4 = var1_1 == null ? null : new KeymapActionMap(var1_1);
            var5_5 = this.getActionMap();
            if (var5_5 != null) ** GOTO lbl28
            this.setActionMap(var4_4);
            break block17;
lbl-1000:
            // 1 sources

            {
                var5_5 = var5_5.getParent();
lbl28:
                // 2 sources

                ** while (var5_5.getParent() != null && !(var5_5.getParent() instanceof KeymapActionMap) && !(var5_5.getParent() instanceof ActionMapUIResource))
            }
lbl29:
            // 1 sources

            if (var5_5.getParent() == null) {
                var5_5.setParent(var4_4);
            } else if (var5_5.getParent() instanceof KeymapActionMap) {
                if (var4_4 == null) {
                    var5_5.setParent(var5_5.getParent().getParent());
                } else {
                    var4_4.setParent(var5_5.getParent().getParent());
                    var5_5.setParent(var4_4);
                }
            } else if (var5_5.getParent() instanceof ActionMapUIResource && var4_4 != null) {
                var4_4.setParent(var5_5.getParent());
                var5_5.setParent(var4_4);
            }
        }
        var6_6 = this.keymap;
        this.keymap = var1_1;
        this.firePropertyChange("keymap", var6_6, var1_1);
    }

    public static void loadKeymap(Keymap keymap, KeyBinding[] keyBindingArray, Action[] actionArray) {
        Hashtable hashtable = new Hashtable(actionArray.length);
        int n = 0;
        while (n < actionArray.length) {
            hashtable.put(actionArray[n].getValue("Name"), actionArray[n]);
            ++n;
        }
        n = 0;
        while (n < keyBindingArray.length) {
            if (hashtable.containsKey(keyBindingArray[n].actionName)) {
                keymap.addActionForKeyStroke(keyBindingArray[n].key, (Action)hashtable.get(keyBindingArray[n].actionName));
            }
            ++n;
        }
    }

    public Action[] getActions() {
        return this.getUI().getEditorKit(this).getActions();
    }

    public void setDocument(Document document) {
        Document document2 = this.doc;
        this.doc = document;
        this.firePropertyChange("document", document2, document);
        this.revalidate();
        this.repaint();
    }

    public Document getDocument() {
        return this.doc;
    }

    public AccessibleContext getAccessibleContext() {
        return new AccessibleJTextComponent();
    }

    public void setMargin(Insets insets) {
        this.margin = insets;
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setText(String string) {
        try {
            if (this.doc instanceof AbstractDocument) {
                ((AbstractDocument)this.doc).replace(0, this.doc.getLength(), string, null);
            } else {
                this.doc.remove(0, this.doc.getLength());
                this.doc.insertString(0, string, null);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    public String getText() {
        if (this.doc == null) {
            return null;
        }
        try {
            return this.doc.getText(0, this.doc.getLength());
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    public String getText(int n, int n2) throws BadLocationException {
        return this.getDocument().getText(n, n2);
    }

    public String getSelectedText() {
        int n = this.getSelectionStart();
        int n2 = this.getSelectionEnd() - n;
        if (n2 <= 0) {
            return null;
        }
        try {
            return this.doc.getText(n, n2);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public String getUIClassID() {
        return "TextComponentUI";
    }

    protected String paramString() {
        return super.paramString();
    }

    public TextUI getUI() {
        return (TextUI)this.ui;
    }

    public void setUI(TextUI textUI) {
        super.setUI(textUI);
    }

    public void updateUI() {
        this.setUI((TextUI)UIManager.getUI(this));
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            return rectangle.width / 10;
        }
        if (n == 1) {
            return rectangle.height / 10;
        }
        throw new IllegalArgumentException("orientation must be either javax.swing.SwingConstants.VERTICAL or javax.swing.SwingConstants.HORIZONTAL");
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            return rectangle.width;
        }
        if (n == 1) {
            return rectangle.height;
        }
        throw new IllegalArgumentException("orientation must be either javax.swing.SwingConstants.VERTICAL or javax.swing.SwingConstants.HORIZONTAL");
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        if (this.editable == bl) {
            return;
        }
        boolean bl2 = this.editable;
        this.editable = bl;
        this.firePropertyChange("editable", bl2, bl);
    }

    public Caret getCaret() {
        return this.caret;
    }

    public void setCaret(Caret caret) {
        if (this.caret != null) {
            this.caret.deinstall(this);
        }
        Caret caret2 = this.caret;
        this.caret = caret;
        if (this.caret != null) {
            this.caret.install(this);
        }
        this.firePropertyChange("caret", caret2, caret);
    }

    public Color getCaretColor() {
        return this.caretColor;
    }

    public void setCaretColor(Color color) {
        Color color2 = this.caretColor;
        this.caretColor = color;
        this.firePropertyChange("caretColor", color2, color);
    }

    public Color getDisabledTextColor() {
        return this.disabledTextColor;
    }

    public void setDisabledTextColor(Color color) {
        Color color2 = this.disabledTextColor;
        this.disabledTextColor = color;
        this.firePropertyChange("disabledTextColor", color2, color);
    }

    public Color getSelectedTextColor() {
        return this.selectedTextColor;
    }

    public void setSelectedTextColor(Color color) {
        Color color2 = this.selectedTextColor;
        this.selectedTextColor = color;
        this.firePropertyChange("selectedTextColor", color2, color);
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color color) {
        Color color2 = this.selectionColor;
        this.selectionColor = color;
        this.firePropertyChange("selectionColor", color2, color);
    }

    public int getCaretPosition() {
        return this.caret.getDot();
    }

    public void setCaretPosition(int n) {
        if (this.doc == null) {
            return;
        }
        if (n < 0 || n > this.doc.getLength()) {
            throw new IllegalArgumentException();
        }
        this.caret.setDot(n);
    }

    public void moveCaretPosition(int n) {
        if (this.doc == null) {
            return;
        }
        if (n < 0 || n > this.doc.getLength()) {
            throw new IllegalArgumentException();
        }
        this.caret.moveDot(n);
    }

    public Highlighter getHighlighter() {
        return this.highlighter;
    }

    public void setHighlighter(Highlighter highlighter) {
        if (this.highlighter != null) {
            this.highlighter.deinstall(this);
        }
        Highlighter highlighter2 = this.highlighter;
        this.highlighter = highlighter;
        if (this.highlighter != null) {
            this.highlighter.install(this);
        }
        this.firePropertyChange("highlighter", highlighter2, highlighter);
    }

    public int getSelectionStart() {
        return Math.min(this.caret.getDot(), this.caret.getMark());
    }

    public void setSelectionStart(int n) {
        this.select(n, this.getSelectionEnd());
    }

    public int getSelectionEnd() {
        return Math.max(this.caret.getDot(), this.caret.getMark());
    }

    public void setSelectionEnd(int n) {
        this.select(this.getSelectionStart(), n);
    }

    public void select(int n, int n2) {
        int n3 = this.doc.getLength();
        n = Math.max(n, 0);
        n = Math.min(n, n3);
        n2 = Math.max(n2, n);
        n2 = Math.min(n2, n3);
        this.setCaretPosition(n);
        this.moveCaretPosition(n2);
    }

    public void selectAll() {
        this.select(0, this.doc.getLength());
    }

    public synchronized void replaceSelection(String string) {
        int n = this.caret.getDot();
        int n2 = this.caret.getMark();
        if (string == null) {
            this.caret.setDot(n);
            return;
        }
        try {
            int n3 = this.getSelectionStart();
            int n4 = this.getSelectionEnd();
            if (n != n2) {
                this.doc.remove(n3, n4 - n3);
            }
            this.doc.insertString(n3, string, null);
            n = n3 + string.length();
            this.setCaretPosition(n);
            this.caret.setMagicCaretPosition(this.modelToView(n).getLocation());
        }
        catch (BadLocationException badLocationException) {}
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            boolean bl = false;
            if (this.getParent().getHeight() > this.getPreferredSize().height) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            boolean bl = false;
            if (this.getParent().getWidth() > this.getPreferredSize().width) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public void addCaretListener(CaretListener caretListener) {
        Class clazz = class$javax$swing$event$CaretListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$CaretListener = JTextComponent.class("[Ljavax.swing.event.CaretListener;", false);
        }
        this.listenerList.add(clazz, caretListener);
    }

    public void removeCaretListener(CaretListener caretListener) {
        Class clazz = class$javax$swing$event$CaretListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$CaretListener = JTextComponent.class("[Ljavax.swing.event.CaretListener;", false);
        }
        this.listenerList.remove(clazz, caretListener);
    }

    public CaretListener[] getCaretListeners() {
        Class clazz = class$javax$swing$event$CaretListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$CaretListener = JTextComponent.class("[Ljavax.swing.event.CaretListener;", false);
        }
        return (CaretListener[])this.getListeners(clazz);
    }

    protected void fireCaretUpdate(CaretEvent caretEvent) {
        CaretListener[] caretListenerArray = this.getCaretListeners();
        int n = 0;
        while (n < caretListenerArray.length) {
            caretListenerArray[n].caretUpdate(caretEvent);
            ++n;
        }
    }

    public void addInputMethodListener(InputMethodListener inputMethodListener) {
        Class clazz = class$java$awt$event$InputMethodListener;
        if (clazz == null) {
            clazz = class$java$awt$event$InputMethodListener = JTextComponent.class("[Ljava.awt.event.InputMethodListener;", false);
        }
        this.listenerList.add(clazz, inputMethodListener);
    }

    public void removeInputMethodListener(InputMethodListener inputMethodListener) {
        Class clazz = class$java$awt$event$InputMethodListener;
        if (clazz == null) {
            clazz = class$java$awt$event$InputMethodListener = JTextComponent.class("[Ljava.awt.event.InputMethodListener;", false);
        }
        this.listenerList.remove(clazz, inputMethodListener);
    }

    public InputMethodListener[] getInputMethodListeners() {
        Class clazz = class$java$awt$event$InputMethodListener;
        if (clazz == null) {
            clazz = class$java$awt$event$InputMethodListener = JTextComponent.class("[Ljava.awt.event.InputMethodListener;", false);
        }
        return (InputMethodListener[])this.getListeners(clazz);
    }

    public Rectangle modelToView(int n) throws BadLocationException {
        return this.getUI().modelToView(this, n);
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean bl) {
        this.dragEnabled = bl;
    }

    public int viewToModel(Point point) {
        return this.getUI().viewToModel(this, point);
    }

    public void copy() {
        this.doTransferAction("copy", TransferHandler.getCopyAction());
    }

    public void cut() {
        this.doTransferAction("cut", TransferHandler.getCutAction());
    }

    public void paste() {
        this.doTransferAction("paste", TransferHandler.getPasteAction());
    }

    private final void doTransferAction(String string, Action action) {
        if (this.getTransferHandler() == null) {
            if (defaultTransferHandler == null) {
                defaultTransferHandler = new DefaultTransferHandler();
            }
            this.setTransferHandler(defaultTransferHandler);
        }
        ActionEvent actionEvent = new ActionEvent(this, 1001, action.getValue("Name").toString());
        action.actionPerformed(actionEvent);
    }

    public void setFocusAccelerator(char c) {
        if (this.focusAccelerator == c) {
            return;
        }
        char c2 = this.focusAccelerator;
        this.focusAccelerator = c;
        this.firePropertyChange(FOCUS_ACCELERATOR_KEY, c2, c);
    }

    public char getFocusAccelerator() {
        return this.focusAccelerator;
    }

    public NavigationFilter getNavigationFilter() {
        return this.navigationFilter;
    }

    public void setNavigationFilter(NavigationFilter navigationFilter) {
        this.navigationFilter = navigationFilter;
    }

    public void read(Reader reader, Object object) throws IOException {
        int n;
        Object object2;
        if (object != null && (object2 = this.getDocument()) != null) {
            object2.putProperty("stream", object);
        }
        object2 = new StringBuffer();
        while ((n = reader.read()) >= 0) {
            ((StringBuffer)object2).append((char)n);
        }
        this.setText(((StringBuffer)object2).toString());
    }

    public void write(Writer writer) throws IOException {
        writer.write(this.getText());
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        return this.getUI().getToolTipText(this, mouseEvent.getPoint());
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.focusAccelerator = '\u0000';
    }

    public JTextComponent() {
        this.this();
        Keymap keymap = JTextComponent.getKeymap(DEFAULT_KEYMAP);
        if (keymap == null) {
            keymap = JTextComponent.addKeymap(DEFAULT_KEYMAP, null);
            keymap.setDefaultAction(new DefaultEditorKit.DefaultKeyTypedAction());
        }
        this.setFocusable(true);
        this.setEditable(true);
        this.enableEvents(8L);
        this.setOpaque(true);
        this.updateUI();
    }

    static {
        keymaps = new Hashtable();
    }

    static class DefaultKeymap
    implements Keymap {
        String name;
        Keymap parent;
        Hashtable map;
        Action defaultAction;

        public void addActionForKeyStroke(KeyStroke keyStroke, Action action) {
            this.map.put(keyStroke, action);
        }

        public Action getAction(KeyStroke keyStroke) {
            if (this.map.containsKey(keyStroke)) {
                return (Action)this.map.get(keyStroke);
            }
            if (this.parent != null) {
                return this.parent.getAction(keyStroke);
            }
            return null;
        }

        public Action[] getBoundActions() {
            Action[] actionArray = new Action[this.map.size()];
            Enumeration enumeration = this.map.elements();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                actionArray[n++] = (Action)enumeration.nextElement();
            }
            return actionArray;
        }

        public KeyStroke[] getBoundKeyStrokes() {
            KeyStroke[] keyStrokeArray = new KeyStroke[this.map.size()];
            Enumeration enumeration = this.map.keys();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                keyStrokeArray[n++] = (KeyStroke)enumeration.nextElement();
            }
            return keyStrokeArray;
        }

        public Action getDefaultAction() {
            return this.defaultAction;
        }

        public KeyStroke[] getKeyStrokesForAction(Action action) {
            int n = 0;
            Enumeration enumeration = this.map.keys();
            while (enumeration.hasMoreElements()) {
                if (!this.map.get(enumeration.nextElement()).equals(action)) continue;
                ++n;
            }
            KeyStroke[] keyStrokeArray = new KeyStroke[n];
            n = 0;
            enumeration = this.map.keys();
            while (enumeration.hasMoreElements()) {
                KeyStroke keyStroke = (KeyStroke)enumeration.nextElement();
                if (!this.map.get(keyStroke).equals(action)) continue;
                keyStrokeArray[n++] = keyStroke;
            }
            return keyStrokeArray;
        }

        public String getName() {
            return this.name;
        }

        public Keymap getResolveParent() {
            return this.parent;
        }

        public boolean isLocallyDefined(KeyStroke keyStroke) {
            return this.map.containsKey(keyStroke);
        }

        public void removeBindings() {
            this.map.clear();
        }

        public void removeKeyStrokeBinding(KeyStroke keyStroke) {
            this.map.remove(keyStroke);
        }

        public void setDefaultAction(Action action) {
            this.defaultAction = action;
        }

        public void setResolveParent(Keymap keymap) {
            this.parent = keymap;
        }

        public DefaultKeymap(String string) {
            this.name = string;
            this.map = new Hashtable();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class KeymapWrapper
    extends InputMap {
        Keymap map;

        public int size() {
            return this.map.getBoundKeyStrokes().length + super.size();
        }

        public Object get(KeyStroke keyStroke) {
            Action action = null;
            Keymap keymap = this.map;
            while (action == null && keymap != null) {
                action = keymap.getAction(keyStroke);
                if (action == null && keyStroke.getKeyEventType() == 400) {
                    action = keymap.getDefaultAction();
                }
                if (action != null) continue;
                keymap = keymap.getResolveParent();
            }
            if (action == null) {
                return super.get(keyStroke);
            }
            return action;
        }

        public KeyStroke[] keys() {
            KeyStroke[] keyStrokeArray = super.keys();
            KeyStroke[] keyStrokeArray2 = this.map.getBoundKeyStrokes();
            KeyStroke[] keyStrokeArray3 = new KeyStroke[keyStrokeArray.length + keyStrokeArray2.length];
            int n = 0;
            while (n < keyStrokeArray.length) {
                keyStrokeArray3[n] = keyStrokeArray[n];
                ++n;
            }
            n = 0;
            while (n < keyStrokeArray2.length) {
                keyStrokeArray3[n + keyStrokeArray.length] = keyStrokeArray2[n];
                ++n;
            }
            return keyStrokeArray3;
        }

        public KeyStroke[] allKeys() {
            KeyStroke[] keyStrokeArray = super.allKeys();
            KeyStroke[] keyStrokeArray2 = this.map.getBoundKeyStrokes();
            int n = 0;
            int n2 = 0;
            if (keyStrokeArray != null) {
                n = keyStrokeArray.length;
            }
            if (keyStrokeArray2 != null) {
                n2 = keyStrokeArray2.length;
            }
            KeyStroke[] keyStrokeArray3 = new KeyStroke[n + n2];
            int n3 = 0;
            while (n3 < n) {
                keyStrokeArray3[n3] = keyStrokeArray[n3];
                ++n3;
            }
            n3 = 0;
            while (n3 < n2) {
                keyStrokeArray3[n3 + n] = keyStrokeArray2[n3];
                ++n3;
            }
            return keyStrokeArray3;
        }

        public KeymapWrapper(Keymap keymap) {
            this.map = keymap;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class KeymapActionMap
    extends ActionMap {
        Keymap map;

        public Action get(Object object) {
            if (object instanceof Action) {
                return (Action)object;
            }
            return super.get(object);
        }

        public int size() {
            return this.map.getBoundKeyStrokes().length + super.size();
        }

        public Object[] keys() {
            Object[] objectArray = super.keys();
            KeyStroke[] keyStrokeArray = this.map.getBoundKeyStrokes();
            Object[] objectArray2 = new Object[objectArray.length + keyStrokeArray.length];
            int n = 0;
            while (n < objectArray.length) {
                objectArray2[n] = objectArray[n];
                ++n;
            }
            n = 0;
            while (n < keyStrokeArray.length) {
                objectArray2[n + objectArray.length] = keyStrokeArray[n];
                ++n;
            }
            return objectArray2;
        }

        public Object[] allKeys() {
            Object[] objectArray = super.allKeys();
            KeyStroke[] keyStrokeArray = this.map.getBoundKeyStrokes();
            Object[] objectArray2 = new Object[objectArray.length + keyStrokeArray.length];
            int n = 0;
            while (n < objectArray.length) {
                objectArray2[n] = objectArray[n];
                ++n;
            }
            n = 0;
            while (n < keyStrokeArray.length) {
                objectArray2[n + objectArray.length] = keyStrokeArray[n];
                ++n;
            }
            return objectArray2;
        }

        public KeymapActionMap(Keymap keymap) {
            this.map = keymap;
        }
    }

    public static class KeyBinding {
        public KeyStroke key;
        public String actionName;

        public KeyBinding(KeyStroke keyStroke, String string) {
            this.key = keyStroke;
            this.actionName = string;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class AccessibleJTextComponent
    extends JComponent.AccessibleJComponent
    implements AccessibleText,
    CaretListener,
    DocumentListener,
    AccessibleAction,
    AccessibleEditableText {
        private static final long serialVersionUID = 7664188944091413696L;
        int dot;
        JTextComponent textComp;

        public int getCaretPosition() {
            this.dot = this.textComp.getCaretPosition();
            return this.dot;
        }

        public String getSelectedText() {
            return this.textComp.getSelectedText();
        }

        public int getSelectionStart() {
            if (this.getSelectedText() == null || this.textComp.getText().equals("")) {
                return 0;
            }
            return this.textComp.getSelectionStart();
        }

        public int getSelectionEnd() {
            if (this.getSelectedText() == null || this.textComp.getText().equals("")) {
                return 0;
            }
            return this.textComp.getSelectionEnd();
        }

        public void caretUpdate(CaretEvent caretEvent) {
            this.dot = caretEvent.getDot();
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TEXT;
        }

        public AccessibleEditableText getAccessibleEditableText() {
            return this;
        }

        public AccessibleText getAccessibleText() {
            return this;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
        }

        public void removeUpdate(DocumentEvent documentEvent) {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public int getIndexAtPoint(Point point) {
            return 0;
        }

        public Rectangle getCharacterBounds(int n) {
            return null;
        }

        public int getCharCount() {
            return this.textComp.getText().length();
        }

        public AttributeSet getCharacterAttribute(int n) {
            return null;
        }

        public String getAtIndex(int n, int n2) {
            return null;
        }

        public String getAfterIndex(int n, int n2) {
            return null;
        }

        public String getBeforeIndex(int n, int n2) {
            return null;
        }

        public int getAccessibleActionCount() {
            return 0;
        }

        public String getAccessibleActionDescription(int n) {
            return super.getAccessibleDescription();
        }

        public boolean doAccessibleAction(int n) {
            return false;
        }

        public void setTextContents(String string) {
        }

        public void insertTextAtIndex(int n, String string) {
            this.replaceText(n, n, string);
        }

        public String getTextRange(int n, int n2) {
            try {
                return this.textComp.getText(n, n2 - n);
            }
            catch (BadLocationException badLocationException) {
                return "";
            }
        }

        public void delete(int n, int n2) {
            this.replaceText(n, n2, "");
        }

        public void cut(int n, int n2) {
            this.textComp.select(n, n2);
            this.textComp.cut();
        }

        public void paste(int n) {
            this.textComp.setCaretPosition(n);
            this.textComp.paste();
        }

        public void replaceText(int n, int n2, String string) {
            this.textComp.select(n, n2);
            this.textComp.replaceSelection(string);
        }

        public void selectText(int n, int n2) {
            this.textComp.select(n, n2);
        }

        public void setAttributes(int n, int n2, AttributeSet attributeSet) {
        }

        private final /* synthetic */ void this() {
            this.dot = 0;
            this.textComp = JTextComponent.this;
        }

        public AccessibleJTextComponent() {
            this.this();
            this.textComp.addCaretListener(this);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class DefaultTransferHandler
    extends TransferHandler {
        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            if (!jTextComponent.isEnabled() || !jTextComponent.isEditable() || dataFlavorArray == null) {
                return false;
            }
            int n = 0;
            while (n < dataFlavorArray.length) {
                if (dataFlavorArray[n].equals(DataFlavor.stringFlavor)) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) {
            int n2;
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            int n3 = jTextComponent.getSelectionStart();
            if (n3 == (n2 = jTextComponent.getSelectionEnd())) {
                return;
            }
            try {
                String string = jTextComponent.getDocument().getText(n3, n2);
                StringSelection stringSelection = new StringSelection(string);
                clipboard.setContents(stringSelection, null);
                if (n == 2) {
                    JTextComponent.this.doc.remove(n3, n2 - n3);
                }
            }
            catch (BadLocationException badLocationException) {}
        }

        public int getSourceActions() {
            return 0;
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            DataFlavor dataFlavor = null;
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            if (dataFlavorArray == null) {
                return false;
            }
            int n = 0;
            while (n < dataFlavorArray.length) {
                if (dataFlavorArray[n].equals(DataFlavor.stringFlavor)) {
                    dataFlavor = dataFlavorArray[n];
                }
                ++n;
            }
            if (dataFlavor == null) {
                return false;
            }
            try {
                JTextComponent jTextComponent = (JTextComponent)jComponent;
                String string = (String)transferable.getTransferData(dataFlavor);
                jTextComponent.replaceSelection(string);
                return true;
            }
            catch (IOException iOException) {
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {}
            return false;
        }

        DefaultTransferHandler() {
        }
    }
}

