/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public abstract class CompositeView
extends View {
    View[] children = new View[0];
    Rectangle insideAllocation;
    Insets insets = new Insets(0, 0, 0, 0);

    protected void loadChildren(ViewFactory viewFactory) {
        Element element = this.getElement();
        int n = element.getElementCount();
        View[] viewArray = new View[n];
        int n2 = 0;
        while (n2 < n) {
            View view;
            Element element2 = element.getElement(n2);
            viewArray[n2] = view = viewFactory.create(element2);
            ++n2;
        }
        this.replace(0, this.getViewCount(), viewArray);
    }

    public void setParent(View view) {
        super.setParent(view);
        if (view != null && (this.children == null || this.children.length == 0)) {
            this.loadChildren(this.getViewFactory());
        }
    }

    public int getViewCount() {
        return this.children.length;
    }

    public View getView(int n) {
        return this.children[n];
    }

    public void replace(int n, int n2, View[] viewArray) {
        int n3 = 0;
        while (n3 < viewArray.length) {
            if (viewArray[n3] == null) {
                throw new NullPointerException("Added views must not be null");
            }
            ++n3;
        }
        n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            this.children[n4].setParent(null);
            ++n4;
        }
        View[] viewArray2 = new View[this.children.length - n2 + viewArray.length];
        System.arraycopy(this.children, 0, viewArray2, 0, n);
        System.arraycopy(viewArray, 0, viewArray2, n, viewArray.length);
        System.arraycopy(this.children, n + n2, viewArray2, n + viewArray.length, this.children.length - (n + n2));
        this.children = viewArray2;
        int n5 = 0;
        while (n5 < viewArray.length) {
            viewArray[n5].setParent(this);
            ++n5;
        }
    }

    public Shape getChildAllocation(int n, Shape shape) {
        Rectangle rectangle = this.getInsideAllocation(shape);
        this.childAllocation(n, rectangle);
        return rectangle;
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        int n2 = this.getViewIndex(n, bias);
        Shape shape2 = null;
        if (n2 != -1) {
            Shape shape3;
            View view = this.getView(n2);
            Shape shape4 = this.getChildAllocation(n2, shape);
            if (shape4 == null) {
                shape2 = this.createDefaultLocation(shape, bias);
            }
            shape2 = (shape3 = view.modelToView(n, shape4, bias)) != null ? shape3 : this.createDefaultLocation(shape, bias);
        } else {
            shape2 = this.createDefaultLocation(shape, bias);
        }
        return shape2;
    }

    private final Shape createDefaultLocation(Shape shape, Position.Bias bias) {
        Rectangle rectangle = shape.getBounds();
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, 1, rectangle.height);
        if (bias == Position.Bias.Forward) {
            rectangle2.x = rectangle.x + rectangle.width;
        }
        return rectangle2;
    }

    public Shape modelToView(int n, Position.Bias bias, int n2, Position.Bias bias2, Shape shape) throws BadLocationException {
        return super.modelToView(n, bias, n2, bias2, shape);
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        if (f >= 0.0f && f2 >= 0.0f) {
            Rectangle rectangle = this.getInsideAllocation(shape);
            View view = this.getViewAtPoint((int)f, (int)f2, rectangle);
            return view.viewToModel(f, f2, shape, biasArray);
        }
        return 0;
    }

    public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        int n3 = -1;
        switch (n2) {
            case 3: 
            case 7: {
                n3 = this.getNextEastWestVisualPositionFrom(n, bias, shape, n2, biasArray);
                break;
            }
            case 1: 
            case 5: {
                n3 = this.getNextNorthSouthVisualPositionFrom(n, bias, shape, n2, biasArray);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal value for direction.");
            }
        }
        return n3;
    }

    public int getViewIndex(int n, Position.Bias bias) {
        if (bias == Position.Bias.Backward && n != 0) {
            --n;
        }
        return this.getViewIndexAtPosition(n);
    }

    protected abstract boolean isBefore(int var1, int var2, Rectangle var3);

    protected abstract boolean isAfter(int var1, int var2, Rectangle var3);

    protected abstract View getViewAtPoint(int var1, int var2, Rectangle var3);

    protected abstract void childAllocation(int var1, Rectangle var2);

    protected View getViewAtPosition(int n, Rectangle rectangle) {
        int n2 = this.getViewIndexAtPosition(n);
        View view = this.children[n2];
        this.childAllocation(n2, rectangle);
        return view;
    }

    protected int getViewIndexAtPosition(int n) {
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.children.length) {
            if (this.children[n3].getStartOffset() <= n && this.children[n3].getEndOffset() > n) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Rectangle getInsideAllocation(Shape shape) {
        if (shape == null) {
            return null;
        }
        Rectangle rectangle = shape.getBounds();
        CompositeView compositeView = this;
        synchronized (compositeView) {
            Rectangle rectangle2 = this.insideAllocation;
            if (rectangle2 == null) {
                this.insideAllocation = rectangle2 = new Rectangle();
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl10 : MonitorExitStatement: MONITOREXIT : var4_3
            rectangle2.x = rectangle.x + this.insets.left;
            rectangle2.y = rectangle.y + this.insets.top;
            rectangle2.width = rectangle.width - this.insets.left - this.insets.right;
            rectangle2.height = rectangle.height - this.insets.top - this.insets.bottom;
            return rectangle2;
        }
    }

    protected void setParagraphInsets(AttributeSet attributeSet) {
        Float f = (Float)attributeSet.getAttribute(StyleConstants.LeftIndent);
        short s = 0;
        if (f != null) {
            s = f.shortValue();
        }
        Float f2 = (Float)attributeSet.getAttribute(StyleConstants.RightIndent);
        short s2 = 0;
        if (f2 != null) {
            s2 = f2.shortValue();
        }
        Float f3 = (Float)attributeSet.getAttribute(StyleConstants.SpaceAbove);
        short s3 = 0;
        if (f3 != null) {
            s3 = f3.shortValue();
        }
        Float f4 = (Float)attributeSet.getAttribute(StyleConstants.SpaceBelow);
        short s4 = 0;
        if (f4 != null) {
            s4 = f4.shortValue();
        }
        this.setInsets(s3, s, s4, s2);
    }

    protected void setInsets(short s, short s2, short s3, short s4) {
        this.insets.top = s;
        this.insets.left = s2;
        this.insets.bottom = s3;
        this.insets.right = s4;
    }

    protected short getLeftInset() {
        return (short)this.insets.left;
    }

    protected short getRightInset() {
        return (short)this.insets.right;
    }

    protected short getTopInset() {
        return (short)this.insets.top;
    }

    protected short getBottomInset() {
        return (short)this.insets.bottom;
    }

    protected int getNextNorthSouthVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        return n;
    }

    protected int getNextEastWestVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        return n;
    }

    protected boolean flipEastAndWestAtEnds(int n, Position.Bias bias) {
        return false;
    }

    public CompositeView(Element element) {
        super(element);
    }
}

