/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicPanelUI;
import javax.swing.text.View;

public class BasicTabbedPaneUI
extends TabbedPaneUI
implements SwingConstants {
    transient ScrollingButton incrButton;
    transient ScrollingButton decrButton;
    transient ScrollingViewport viewport;
    transient ScrollingPanel panel;
    transient int currentScrollLocation;
    protected Rectangle calcRect;
    protected Rectangle[] rects = new Rectangle[0];
    protected Insets contentBorderInsets;
    protected Insets selectedTabPadInsets;
    protected Insets tabAreaInsets;
    protected Insets tabInsets;
    protected Color darkShadow;
    protected Color focus;
    protected Color highlight;
    protected Color lightHighlight;
    protected Color shadow;
    protected int maxTabHeight;
    protected int maxTabWidth;
    protected int runCount;
    protected int selectedRun;
    protected int tabRunOverlay;
    protected int textIconGap;
    protected int[] tabRuns = new int[10];
    boolean tabRunsDirty;
    protected KeyStroke downKey;
    protected KeyStroke leftKey;
    protected KeyStroke rightKey;
    protected KeyStroke upKey;
    protected FocusListener focusListener;
    protected MouseListener mouseListener;
    protected PropertyChangeListener propertyChangeListener;
    protected ChangeListener tabChangeListener;
    protected JTabbedPane tabPane;
    transient LayoutManager layoutManager;
    transient Rectangle tabAreaRect;
    transient Rectangle contentRect;
    private int rolloverTab;
    private boolean tabsOpaque;

    ScrollingButton createIncreaseButton() {
        if (this.incrButton == null) {
            this.incrButton = new ScrollingButton(1);
        }
        if (this.tabPane.getTabPlacement() == 1 || this.tabPane.getTabPlacement() == 3) {
            this.incrButton.setDirection(3);
        } else {
            this.incrButton.setDirection(5);
        }
        return this.incrButton;
    }

    ScrollingButton createDecreaseButton() {
        if (this.decrButton == null) {
            this.decrButton = new ScrollingButton(5);
        }
        if (this.tabPane.getTabPlacement() == 1 || this.tabPane.getTabPlacement() == 3) {
            this.decrButton.setDirection(7);
        } else {
            this.decrButton.setDirection(1);
        }
        return this.decrButton;
    }

    Point findPointForIndex(int n) {
        int n2 = this.tabPane.getTabPlacement();
        int n3 = this.tabPane.getSelectedIndex();
        Insets insets = this.getSelectedTabPadInsets(n2);
        int n4 = 0;
        int n5 = 0;
        if (n2 == 1 || n2 == 3) {
            if (n > 0) {
                n4 += this.rects[n - 1].x + this.rects[n - 1].width;
                if (n > n3) {
                    n4 -= insets.left + insets.right;
                }
            }
        } else if (n > 0) {
            n5 += this.rects[n - 1].y + this.rects[n - 1].height;
            if (n > n3) {
                n5 -= insets.top + insets.bottom;
            }
        }
        Point point = new Point(n4, n5);
        return point;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTabbedPaneUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        if (jComponent instanceof JTabbedPane) {
            this.tabPane = (JTabbedPane)jComponent;
            this.installComponents();
            this.installDefaults();
            this.installListeners();
            this.installKeyboardActions();
            this.layoutManager = this.createLayoutManager();
            this.tabPane.setLayout(this.layoutManager);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.layoutManager = null;
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
        this.tabPane = null;
    }

    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 0) {
            return new TabbedPaneLayout();
        }
        this.incrButton = this.createIncreaseButton();
        this.decrButton = this.createDecreaseButton();
        this.viewport = new ScrollingViewport();
        this.viewport.setLayout(null);
        this.panel = new ScrollingPanel();
        this.viewport.setView(this.panel);
        this.tabPane.add(this.incrButton);
        this.tabPane.add(this.decrButton);
        this.tabPane.add(this.viewport);
        this.currentScrollLocation = 0;
        this.decrButton.setEnabled(false);
        this.panel.addMouseListener(this.mouseListener);
        this.incrButton.addMouseListener(this.mouseListener);
        this.decrButton.addMouseListener(this.mouseListener);
        this.viewport.setBackground(Color.LIGHT_GRAY);
        return new TabbedPaneScrollLayout();
    }

    protected void installComponents() {
    }

    protected void uninstallComponents() {
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.tabPane, "TabbedPane.background", "TabbedPane.foreground", "TabbedPane.font");
        this.tabPane.setOpaque(false);
        this.highlight = UIManager.getColor("TabbedPane.highlight");
        this.lightHighlight = UIManager.getColor("TabbedPane.lightHighlight");
        this.shadow = UIManager.getColor("TabbedPane.shadow");
        this.darkShadow = UIManager.getColor("TabbedPane.darkShadow");
        this.focus = UIManager.getColor("TabbedPane.focus");
        this.textIconGap = UIManager.getInt("TabbedPane.textIconGap");
        this.tabRunOverlay = UIManager.getInt("TabbedPane.tabRunOverlay");
        this.tabInsets = UIManager.getInsets("TabbedPane.tabInsets");
        this.selectedTabPadInsets = UIManager.getInsets("TabbedPane.tabbedPaneTabPadInsets");
        this.tabAreaInsets = UIManager.getInsets("TabbedPane.tabAreaInsets");
        this.contentBorderInsets = UIManager.getInsets("TabbedPane.tabbedPaneContentBorderInsets");
        this.tabsOpaque = UIManager.getBoolean("TabbedPane.tabsOpaque");
        this.calcRect = new Rectangle();
        this.tabRuns = new int[10];
        this.tabAreaRect = new Rectangle();
        this.contentRect = new Rectangle();
    }

    protected void uninstallDefaults() {
        this.calcRect = null;
        this.tabAreaRect = null;
        this.contentRect = null;
        this.tabRuns = null;
        this.contentBorderInsets = null;
        this.tabAreaInsets = null;
        this.selectedTabPadInsets = null;
        this.tabInsets = null;
        this.focus = null;
        this.darkShadow = null;
        this.shadow = null;
        this.lightHighlight = null;
        this.highlight = null;
        this.tabPane.setBackground(null);
        this.tabPane.setForeground(null);
        this.tabPane.setFont(null);
    }

    protected void installListeners() {
        this.mouseListener = this.createMouseListener();
        this.tabChangeListener = this.createChangeListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.focusListener = this.createFocusListener();
        this.tabPane.addMouseListener(this.mouseListener);
        this.tabPane.addChangeListener(this.tabChangeListener);
        this.tabPane.addPropertyChangeListener(this.propertyChangeListener);
        this.tabPane.addFocusListener(this.focusListener);
    }

    protected void uninstallListeners() {
        this.tabPane.removeFocusListener(this.focusListener);
        this.tabPane.removePropertyChangeListener(this.propertyChangeListener);
        this.tabPane.removeChangeListener(this.tabChangeListener);
        this.tabPane.removeMouseListener(this.mouseListener);
        this.focusListener = null;
        this.propertyChangeListener = null;
        this.tabChangeListener = null;
        this.mouseListener = null;
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected ChangeListener createChangeListener() {
        return new TabSelectionHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected void installKeyboardActions() {
    }

    protected void uninstallKeyboardActions() {
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.layoutManager.minimumLayoutSize(this.tabPane);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (this.tabPane.getTabCount() == 0) {
            return;
        }
        if (this.tabPane.getTabLayoutPolicy() == 0) {
            this.paintTabArea(graphics, this.tabPane.getTabPlacement(), this.tabPane.getSelectedIndex());
        }
        this.paintContentBorder(graphics, this.tabPane.getTabPlacement(), this.tabPane.getSelectedIndex());
    }

    protected void paintTabArea(Graphics graphics, int n, int n2) {
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        boolean bl = false;
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            bl = true;
        }
        boolean bl2 = bl;
        int n3 = this.tabPane.getTabCount();
        int n4 = this.runCount - 1;
        while (n4 >= 0) {
            int n5 = this.tabRuns[n4];
            int n6 = n4 == this.runCount - 1 ? this.tabRuns[0] : this.tabRuns[n4 + 1];
            int n7 = n6 != 0 ? n6 - 1 : n3 - 1;
            int n8 = n5;
            while (n8 <= n7) {
                if (n8 != n2) {
                    this.paintTab(graphics, n, this.rects, n8, rectangle, rectangle2);
                }
                ++n8;
            }
            --n4;
        }
        if (n2 >= 0) {
            this.paintTab(graphics, n, this.rects, n2, rectangle, rectangle2);
        }
    }

    protected void paintTab(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2) {
        boolean bl;
        Rectangle rectangle3 = rectangleArray[n2];
        boolean bl2 = false;
        if (n2 == this.tabPane.getSelectedIndex()) {
            bl2 = bl = true;
        }
        if (this.tabsOpaque || this.tabPane.isOpaque()) {
            this.paintTabBackground(graphics, n, n2, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl);
        }
        this.paintTabBorder(graphics, n, n2, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl);
        FontMetrics fontMetrics = this.getFontMetrics();
        Icon icon = this.getIconForTab(n2);
        String string = this.tabPane.getTitleAt(n2);
        this.layoutLabel(n, fontMetrics, n2, string, icon, rectangle3, rectangle, rectangle2, bl);
        this.paintText(graphics, n, this.tabPane.getFont(), fontMetrics, n2, string, rectangle2, bl);
        this.paintIcon(graphics, n, n2, icon, rectangle, bl);
        this.paintFocusIndicator(graphics, n, rectangleArray, n2, rectangle, rectangle2, bl);
    }

    protected void layoutLabel(int n, FontMetrics fontMetrics, int n2, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl) {
        SwingUtilities.layoutCompoundLabel(fontMetrics, string, icon, 0, 0, 0, 4, rectangle, rectangle2, rectangle3, this.textIconGap);
        int n3 = this.getTabLabelShiftX(n, n2, bl);
        int n4 = this.getTabLabelShiftY(n, n2, bl);
        rectangle2.x += n3;
        rectangle2.y += n4;
        rectangle3.x += n3;
        rectangle3.y += n4;
    }

    protected void paintIcon(Graphics graphics, int n, int n2, Icon icon, Rectangle rectangle, boolean bl) {
        if (icon != null) {
            icon.paintIcon(this.tabPane, graphics, rectangle.x, rectangle.y);
        }
    }

    protected void paintText(Graphics graphics, int n, Font font, FontMetrics fontMetrics, int n2, String string, Rectangle rectangle, boolean bl) {
        graphics.setFont(font);
        View view = this.getTextViewForTab(n2);
        if (view != null) {
            view.paint(graphics, rectangle);
            return;
        }
        int n3 = this.tabPane.getDisplayedMnemonicIndexAt(n2);
        if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(n2)) {
            Color color;
            Color color2 = this.tabPane.getForegroundAt(n2);
            if (bl && color2 instanceof UIResource && (color = UIManager.getColor("TabbedPane.selectionForeground")) != null) {
                color2 = color;
            }
            graphics.setColor(color2);
            if (n3 != -1) {
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n3, rectangle.x, rectangle.y + fontMetrics.getAscent());
            } else {
                graphics.drawString(string, rectangle.x, rectangle.y + fontMetrics.getAscent());
            }
        } else {
            Color color = this.tabPane.getBackgroundAt(n2);
            graphics.setColor(color.brighter());
            if (n3 != -1) {
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n3, rectangle.x, rectangle.y);
            } else {
                graphics.drawString(string, rectangle.x, rectangle.y);
            }
            graphics.setColor(color.darker());
            if (n3 != -1) {
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n3, rectangle.x + 1, rectangle.y + 1);
            } else {
                graphics.drawString(string, rectangle.x + 1, rectangle.y + 1);
            }
        }
    }

    protected int getTabLabelShiftX(int n, int n2, boolean bl) {
        return 0;
    }

    protected int getTabLabelShiftY(int n, int n2, boolean bl) {
        return 0;
    }

    protected void paintFocusIndicator(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        if (this.tabPane.hasFocus() && bl) {
            int n3;
            int n4;
            int n5;
            int n6;
            Rectangle rectangle3 = rectangleArray[n2];
            graphics.setColor(this.focus);
            switch (n) {
                case 2: {
                    n6 = rectangle3.x + 3;
                    n5 = rectangle3.y + 3;
                    n4 = rectangle3.width - 5;
                    n3 = rectangle3.height - 6;
                    break;
                }
                case 4: {
                    n6 = rectangle3.x + 2;
                    n5 = rectangle3.y + 3;
                    n4 = rectangle3.width - 6;
                    n3 = rectangle3.height - 5;
                    break;
                }
                case 3: {
                    n6 = rectangle3.x + 3;
                    n5 = rectangle3.y + 2;
                    n4 = rectangle3.width - 6;
                    n3 = rectangle3.height - 5;
                    break;
                }
                default: {
                    n6 = rectangle3.x + 3;
                    n5 = rectangle3.y + 3;
                    n4 = rectangle3.width - 6;
                    n3 = rectangle3.height - 5;
                }
            }
            BasicGraphicsUtils.drawDashedRect(graphics, n6, n5, n4, n3);
        }
    }

    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Color color = graphics.getColor();
        if (!bl || n != 1) {
            graphics.setColor(this.shadow);
            graphics.drawLine(n3 + 1, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n3, n4 + n6, n3 + n5, n4 + n6);
        }
        if (!bl || n != 2) {
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n3 + n5, n4, n3 + n5, n4 + n6);
            graphics.setColor(this.shadow);
            graphics.drawLine(n3 + n5 - 1, n4 + 1, n3 + n5 - 1, n4 + n6 - 1);
        }
        if (!bl || n != 4) {
            graphics.setColor(this.lightHighlight);
            graphics.drawLine(n3, n4, n3, n4 + n6);
        }
        if (!bl || n != 3) {
            graphics.setColor(this.lightHighlight);
            graphics.drawLine(n3, n4, n3 + n5, n4);
        }
        graphics.setColor(color);
    }

    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Color color = graphics.getColor();
        if (bl) {
            graphics.setColor(Color.LIGHT_GRAY);
        } else {
            Color color2 = this.tabPane.getBackgroundAt(n2);
            if (color2 == null) {
                color2 = Color.GRAY;
            }
            graphics.setColor(color2);
        }
        graphics.fillRect(n3, n4, n5, n6);
        graphics.setColor(color);
    }

    protected void paintContentBorder(Graphics graphics, int n, int n2) {
        int n3 = this.tabPane.getWidth();
        int n4 = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        Insets insets2 = this.getTabAreaInsets(n);
        int n5 = insets.left;
        int n6 = insets.top;
        int n7 = n3 - insets.left - insets.right;
        int n8 = n4 - insets.top - insets.bottom;
        switch (n) {
            case 2: {
                n7 -= (n5 += this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth)) - insets.left;
                break;
            }
            case 4: {
                n7 -= this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
                break;
            }
            case 3: {
                n8 -= this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
                break;
            }
            default: {
                n8 -= (n6 += this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight)) - insets.top;
            }
        }
        if (this.tabPane.isOpaque()) {
            Color color = UIManager.getColor("TabbedPane.contentAreaColor");
            graphics.setColor(color);
            graphics.fillRect(n5, n6, n7, n8);
        }
        this.paintContentBorderTopEdge(graphics, n, n2, n5, n6, n7, n8);
        this.paintContentBorderLeftEdge(graphics, n, n2, n5, n6, n7, n8);
        this.paintContentBorderBottomEdge(graphics, n, n2, n5, n6, n7, n8);
        this.paintContentBorderRightEdge(graphics, n, n2, n5, n6, n7, n8);
    }

    protected void paintContentBorderTopEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Color color = graphics.getColor();
        graphics.setColor(this.lightHighlight);
        int n7 = this.rects[n2].x;
        int n8 = this.rects[n2].x + this.rects[n2].width;
        int n9 = 0;
        if (n == 1) {
            if (this.tabPane.getTabLayoutPolicy() == 1) {
                Point point = this.findPointForIndex(this.currentScrollLocation);
                n9 = point.x;
            }
            graphics.drawLine(n3, n4, n7 - n9, n4);
            graphics.drawLine(n8 - n9, n4, n3 + n5, n4);
        } else {
            graphics.drawLine(n3, n4, n3 + n5, n4);
        }
        graphics.setColor(color);
    }

    protected void paintContentBorderLeftEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Color color = graphics.getColor();
        graphics.setColor(this.lightHighlight);
        int n7 = this.rects[n2].y;
        int n8 = this.rects[n2].y + this.rects[n2].height;
        int n9 = 0;
        if (n == 2) {
            if (this.tabPane.getTabLayoutPolicy() == 1) {
                Point point = this.findPointForIndex(this.currentScrollLocation);
                n9 = point.y;
            }
            graphics.drawLine(n3, n4, n3, n7 - n9);
            graphics.drawLine(n3, n8 - n9, n3, n4 + n6);
        } else {
            graphics.drawLine(n3, n4, n3, n4 + n6);
        }
        graphics.setColor(color);
    }

    protected void paintContentBorderBottomEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Color color = graphics.getColor();
        int n7 = this.rects[n2].x;
        int n8 = this.rects[n2].x + this.rects[n2].width;
        int n9 = 0;
        if (n == 3) {
            if (this.tabPane.getTabLayoutPolicy() == 1) {
                Point point = this.findPointForIndex(this.currentScrollLocation);
                n9 = point.x;
            }
            graphics.setColor(this.shadow);
            graphics.drawLine(n3 + 1, n4 + n6 - 1, n7 - n9, n4 + n6 - 1);
            graphics.drawLine(n8 - n9, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n3, n4 + n6, n7 - n9, n4 + n6);
            graphics.drawLine(n8 - n9, n4 + n6, n3 + n5, n4 + n6);
        } else {
            graphics.setColor(this.shadow);
            graphics.drawLine(n3 + 1, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n3, n4 + n6, n3 + n5, n4 + n6);
        }
        graphics.setColor(color);
    }

    protected void paintContentBorderRightEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Color color = graphics.getColor();
        int n7 = this.rects[n2].y;
        int n8 = this.rects[n2].y + this.rects[n2].height;
        int n9 = 0;
        if (n == 4) {
            if (this.tabPane.getTabLayoutPolicy() == 1) {
                Point point = this.findPointForIndex(this.currentScrollLocation);
                n9 = point.y;
            }
            graphics.setColor(this.shadow);
            graphics.drawLine(n3 + n5 - 1, n4 + 1, n3 + n5 - 1, n7 - n9);
            graphics.drawLine(n3 + n5 - 1, n8 - n9, n3 + n5 - 1, n4 + n6 - 1);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n3 + n5, n4, n3 + n5, n7 - n9);
            graphics.drawLine(n3 + n5, n8 - n9, n3 + n5, n4 + n6);
        } else {
            graphics.setColor(this.shadow);
            graphics.drawLine(n3 + n5 - 1, n4 + 1, n3 + n5 - 1, n4 + n6 - 1);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n3 + n5, n4, n3 + n5, n4 + n6);
        }
        graphics.setColor(color);
    }

    public Rectangle getTabBounds(JTabbedPane jTabbedPane, int n) {
        return this.rects[n];
    }

    public int getTabRunCount(JTabbedPane jTabbedPane) {
        return this.runCount;
    }

    public int tabForCoordinate(JTabbedPane jTabbedPane, int n, int n2) {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        int n3 = this.tabPane.getTabCount();
        int n4 = -1;
        int n5 = 0;
        while (n5 < n3) {
            if (this.rects[n5].contains(n, n2)) {
                n4 = n5;
                break;
            }
            ++n5;
        }
        return n4;
    }

    protected Rectangle getTabBounds(int n, Rectangle rectangle) {
        rectangle.setBounds(this.getTabBounds(this.tabPane, n));
        return rectangle;
    }

    protected Component getVisibleComponent() {
        return this.tabPane.getComponentAt(this.tabPane.getSelectedIndex());
    }

    protected void setVisibleComponent(Component component) {
        component.setVisible(true);
        this.tabPane.setSelectedComponent(component);
    }

    protected void assureRectsCreated(int n) {
        if (this.rects.length < n) {
            Rectangle[] rectangleArray = this.rects;
            this.rects = new Rectangle[n];
            System.arraycopy(rectangleArray, 0, this.rects, 0, rectangleArray.length);
            int n2 = rectangleArray.length;
            while (n2 < this.rects.length) {
                this.rects[n2] = new Rectangle();
                ++n2;
            }
        }
    }

    protected void expandTabRunsArray() {
        if (this.tabRuns == null) {
            this.tabRuns = new int[10];
        } else {
            int[] nArray = new int[this.tabRuns.length + 10];
            System.arraycopy(this.tabRuns, 0, nArray, 0, this.tabRuns.length);
            this.tabRuns = nArray;
        }
    }

    protected int getRunForTab(int n, int n2) {
        if (this.runCount == 1 && n2 < n && n2 >= 0) {
            return 1;
        }
        int n3 = 0;
        while (n3 < this.runCount) {
            int n4;
            int n5 = this.lastTabInRun(n, this.getPreviousTabRun(n3)) + 1;
            if (n5 == n) {
                n5 = 0;
            }
            if ((n4 = this.lastTabInRun(n, n3)) >= n2 && n5 <= n2) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    protected int lastTabInRun(int n, int n2) {
        if (this.tabRuns[n2] == 0) {
            return n - 1;
        }
        return this.tabRuns[n2] - 1;
    }

    protected int getTabRunOverlay(int n) {
        return this.tabRunOverlay;
    }

    protected int getTabRunIndent(int n, int n2) {
        return 0;
    }

    protected boolean shouldPadTabRun(int n, int n2) {
        return true;
    }

    protected boolean shouldRotateTabRuns(int n) {
        return true;
    }

    protected Icon getIconForTab(int n) {
        if (this.tabPane.isEnabledAt(n)) {
            return this.tabPane.getIconAt(n);
        }
        return this.tabPane.getDisabledIconAt(n);
    }

    protected View getTextViewForTab(int n) {
        return null;
    }

    protected int calculateTabHeight(int n, int n2, int n3) {
        int n4 = n3;
        Icon icon = this.getIconForTab(n2);
        Insets insets = this.getTabInsets(n, n2);
        if (icon != null) {
            n4 = Math.max(n4, icon.getIconHeight());
        }
        return n4 += insets.top + insets.bottom + 2;
    }

    protected int calculateMaxTabHeight(int n) {
        this.maxTabHeight = 0;
        FontMetrics fontMetrics = this.getFontMetrics();
        int n2 = fontMetrics.getHeight();
        int n3 = 0;
        while (n3 < this.tabPane.getTabCount()) {
            this.maxTabHeight = Math.max(this.calculateTabHeight(n, n3, n2), this.maxTabHeight);
            ++n3;
        }
        return this.maxTabHeight;
    }

    protected int calculateTabWidth(int n, int n2, FontMetrics fontMetrics) {
        Icon icon = this.getIconForTab(n2);
        Insets insets = this.getTabInsets(n, n2);
        int n3 = 0;
        if (icon != null) {
            Rectangle rectangle = new Rectangle();
            Rectangle rectangle2 = new Rectangle();
            Rectangle rectangle3 = new Rectangle();
            FontMetrics fontMetrics2 = this.getFontMetrics();
            String string = this.tabPane.getTitleAt(n2);
            boolean bl = false;
            if (n2 == this.tabPane.getSelectedIndex()) {
                bl = true;
            }
            this.layoutLabel(n, fontMetrics2, n2, string, icon, rectangle, rectangle2, rectangle3, bl);
            n3 = rectangle3.union((Rectangle)rectangle2).width;
        } else {
            n3 = fontMetrics.stringWidth(this.tabPane.getTitleAt(n2));
        }
        return n3 += insets.left + insets.right;
    }

    protected int calculateMaxTabWidth(int n) {
        this.maxTabWidth = 0;
        FontMetrics fontMetrics = this.getFontMetrics();
        int n2 = 0;
        while (n2 < this.tabPane.getTabCount()) {
            this.maxTabWidth = Math.max(this.calculateTabWidth(n, n2, fontMetrics), this.maxTabWidth);
            ++n2;
        }
        return this.maxTabWidth;
    }

    protected int calculateTabAreaHeight(int n, int n2, int n3) {
        Insets insets = this.getTabAreaInsets(n);
        int n4 = n2 * n3 - (n2 - 1) * this.tabRunOverlay;
        return n4 += insets.top + insets.bottom;
    }

    protected int calculateTabAreaWidth(int n, int n2, int n3) {
        Insets insets = this.getTabAreaInsets(n);
        int n4 = n2 * n3 - (n2 - 1) * this.tabRunOverlay;
        return n4 += insets.left + insets.right;
    }

    protected Insets getTabInsets(int n, int n2) {
        return this.tabInsets;
    }

    protected Insets getSelectedTabPadInsets(int n) {
        Insets insets = new Insets(0, 0, 0, 0);
        BasicTabbedPaneUI.rotateInsets(this.selectedTabPadInsets, insets, n);
        return insets;
    }

    protected Insets getTabAreaInsets(int n) {
        Insets insets = new Insets(0, 0, 0, 0);
        BasicTabbedPaneUI.rotateInsets(this.tabAreaInsets, insets, n);
        return insets;
    }

    protected Insets getContentBorderInsets(int n) {
        Insets insets = new Insets(0, 0, 0, 0);
        BasicTabbedPaneUI.rotateInsets(this.contentBorderInsets, insets, n);
        return insets;
    }

    protected FontMetrics getFontMetrics() {
        FontMetrics fontMetrics = this.tabPane.getFontMetrics(this.tabPane.getFont());
        return fontMetrics;
    }

    protected void navigateSelectedTab(int n) {
        int n2;
        int n3 = this.tabPane.getTabPlacement();
        if (n3 == 1 || n3 == 3) {
            if (n == 7) {
                this.selectPreviousTabInRun(this.tabPane.getSelectedIndex());
            } else if (n == 3) {
                this.selectNextTabInRun(this.tabPane.getSelectedIndex());
            } else {
                int n4 = this.tabPane.getTabCount();
                int n5 = this.tabPane.getSelectedIndex();
                boolean bl = false;
                if (n3 == 4) {
                    bl = true;
                }
                n2 = this.getTabRunOffset(n3, n4, n5, bl);
                this.selectAdjacentRunTab(n3, this.tabPane.getSelectedIndex(), n2);
            }
        }
        if (n3 == 2 || n3 == 4) {
            if (n == 1) {
                this.selectPreviousTabInRun(this.tabPane.getSelectedIndex());
            } else if (n == 5) {
                this.selectNextTabInRun(this.tabPane.getSelectedIndex());
            } else {
                int n6 = this.tabPane.getTabCount();
                int n7 = this.tabPane.getSelectedIndex();
                boolean bl = false;
                if (n3 == 4) {
                    bl = true;
                }
                n2 = this.getTabRunOffset(n3, n6, n7, bl);
                this.selectAdjacentRunTab(n3, this.tabPane.getSelectedIndex(), n2);
            }
        }
    }

    protected void selectNextTabInRun(int n) {
        this.tabPane.setSelectedIndex(this.getNextTabIndexInRun(this.tabPane.getTabCount(), n));
    }

    protected void selectPreviousTabInRun(int n) {
        this.tabPane.setSelectedIndex(this.getPreviousTabIndexInRun(this.tabPane.getTabCount(), n));
    }

    protected void selectNextTab(int n) {
        this.tabPane.setSelectedIndex(this.getNextTabIndex(n));
    }

    protected void selectPreviousTab(int n) {
        this.tabPane.setSelectedIndex(this.getPreviousTabIndex(n));
    }

    protected void selectAdjacentRunTab(int n, int n2, int n3) {
        int n4 = this.rects[n2].x + this.rects[n2].width / 2;
        int n5 = this.rects[n2].y + this.rects[n2].height / 2;
        switch (n) {
            case 1: 
            case 3: {
                n5 += n3;
                break;
            }
            case 2: 
            case 4: {
                n4 += n3;
                break;
            }
        }
        int n6 = this.tabForCoordinate(this.tabPane, n4, n5);
        if (n6 != -1) {
            this.tabPane.setSelectedIndex(n6);
        }
    }

    protected int getTabRunOffset(int n, int n2, int n3, boolean bl) {
        int n4 = this.getRunForTab(n2, n3);
        int n5 = bl ? this.getNextTabRun(n4) : this.getPreviousTabRun(n4);
        int n6 = n == 1 || n == 3 ? this.rects[this.lastTabInRun((int)n2, (int)n5)].y - this.rects[this.lastTabInRun((int)n2, (int)n4)].y : this.rects[this.lastTabInRun((int)n2, (int)n5)].x - this.rects[this.lastTabInRun((int)n2, (int)n4)].x;
        return n6;
    }

    protected int getPreviousTabIndex(int n) {
        if (--n < 0) {
            return this.tabPane.getTabCount() - 1;
        }
        return n;
    }

    protected int getNextTabIndex(int n) {
        if (++n == this.tabPane.getTabCount()) {
            return 0;
        }
        return n;
    }

    protected int getNextTabIndexInRun(int n, int n2) {
        int n3;
        int n4 = this.getNextTabIndex(n2);
        if (n4 == this.lastTabInRun(n, n3 = this.getRunForTab(n, n2)) + 1) {
            n4 = this.lastTabInRun(n, this.getPreviousTabRun(n3)) + 1;
        }
        return this.getNextTabIndex(n2);
    }

    protected int getPreviousTabIndexInRun(int n, int n2) {
        int n3;
        int n4 = this.getPreviousTabIndex(n2);
        if (n4 == this.lastTabInRun(n, this.getPreviousTabRun(n3 = this.getRunForTab(n, n2)))) {
            n4 = this.lastTabInRun(n, n3);
        }
        return this.getPreviousTabIndex(n2);
    }

    protected int getPreviousTabRun(int n) {
        int n2;
        if (this.getTabRunCount(this.tabPane) == 1) {
            return 1;
        }
        if ((n2 = --n) < 0) {
            n2 = this.getTabRunCount(this.tabPane) - 1;
        }
        return n2;
    }

    protected int getNextTabRun(int n) {
        int n2;
        if (this.getTabRunCount(this.tabPane) == 1) {
            return 1;
        }
        if ((n2 = ++n) == this.getTabRunCount(this.tabPane)) {
            n2 = 0;
        }
        return n2;
    }

    protected static void rotateInsets(Insets insets, Insets insets2, int n) {
        switch (n) {
            case 1: {
                insets2.top = insets.top;
                insets2.left = insets.left;
                insets2.right = insets.right;
                insets2.bottom = insets.bottom;
                break;
            }
            case 2: {
                insets2.left = insets.top;
                insets2.top = insets.left;
                insets2.right = insets.bottom;
                insets2.bottom = insets.right;
                break;
            }
            case 3: {
                insets2.top = insets.bottom;
                insets2.bottom = insets.top;
                insets2.left = insets.left;
                insets2.right = insets.right;
                break;
            }
            case 4: {
                insets2.top = insets.left;
                insets2.left = insets.bottom;
                insets2.bottom = insets.right;
                insets2.right = insets.top;
                break;
            }
        }
    }

    protected void setRolloverTab(int n) {
        this.rolloverTab = n;
    }

    protected int getRolloverTab() {
        return this.rolloverTab;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ScrollingButton
    extends BasicArrowButton
    implements UIResource {
        public ScrollingButton(int n) {
            super(n);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class TabbedPaneLayout
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void calculateLayoutInfo() {
            int n = BasicTabbedPaneUI.this.tabPane.getTabCount();
            BasicTabbedPaneUI.this.assureRectsCreated(n);
            this.calculateTabRects(BasicTabbedPaneUI.this.tabPane.getTabPlacement(), n);
            BasicTabbedPaneUI.this.tabRunsDirty = false;
        }

        protected Dimension calculateSize(boolean bl) {
            int n;
            int n2 = BasicTabbedPaneUI.this.tabPane.getTabPlacement();
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (n5 < BasicTabbedPaneUI.this.tabPane.getTabCount()) {
                Component component = BasicTabbedPaneUI.this.tabPane.getComponentAt(n5);
                if (component != null) {
                    Dimension dimension;
                    Dimension dimension2 = dimension = bl ? component.getMinimumSize() : component.getPreferredSize();
                    if (dimension != null) {
                        n4 = Math.max(n4, dimension.height);
                        n3 = Math.max(n3, dimension.width);
                    }
                }
                ++n5;
            }
            Insets insets = BasicTabbedPaneUI.this.getTabAreaInsets(n2);
            if (n2 == 1 || n2 == 3) {
                n = BasicTabbedPaneUI.this.calculateMaxTabWidth(n2);
                n3 = Math.max(n, n3);
                int n6 = this.preferredTabAreaHeight(n2, n3 - insets.left - insets.right);
                n4 += n6;
            } else {
                n = BasicTabbedPaneUI.this.calculateMaxTabHeight(n2);
                n4 = Math.max(n, n4);
                int n7 = this.preferredTabAreaWidth(n2, n4 - insets.top - insets.bottom);
                n3 += n7;
            }
            Insets insets2 = BasicTabbedPaneUI.this.tabPane.getInsets();
            return new Dimension(n3 + insets2.left + insets2.right, n4 + insets2.top + insets2.bottom);
        }

        protected void calculateTabRects(int n, int n2) {
            Rectangle rectangle;
            int n3;
            int n4;
            int n5;
            int n6;
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            Insets insets2 = BasicTabbedPaneUI.this.getTabAreaInsets(n);
            Dimension dimension = BasicTabbedPaneUI.this.tabPane.getSize();
            switch (n) {
                case 2: {
                    BasicTabbedPaneUI.this.maxTabWidth = BasicTabbedPaneUI.this.calculateMaxTabWidth(n);
                    n6 = insets.left + insets2.left;
                    n5 = insets.top + insets2.top;
                    n4 = dimension.height - (insets.bottom + insets2.bottom);
                    break;
                }
                case 4: {
                    BasicTabbedPaneUI.this.maxTabWidth = BasicTabbedPaneUI.this.calculateMaxTabWidth(n);
                    n6 = dimension.width - (insets.right + insets2.right) - BasicTabbedPaneUI.this.maxTabWidth;
                    n5 = insets.top + insets2.top;
                    n4 = dimension.height - (insets.bottom + insets2.bottom);
                    break;
                }
                case 3: {
                    BasicTabbedPaneUI.this.maxTabHeight = BasicTabbedPaneUI.this.calculateMaxTabHeight(n);
                    n6 = insets.left + insets2.left;
                    n5 = dimension.height - (insets.bottom + insets2.bottom) - BasicTabbedPaneUI.this.maxTabHeight;
                    n4 = dimension.width - (insets.right + insets2.right);
                    break;
                }
                default: {
                    BasicTabbedPaneUI.this.maxTabHeight = BasicTabbedPaneUI.this.calculateMaxTabHeight(n);
                    n6 = insets.left + insets2.left;
                    n5 = insets.top + insets2.top;
                    n4 = dimension.width - (insets.right + insets2.right);
                }
            }
            if (n2 == 0) {
                return;
            }
            FontMetrics fontMetrics = BasicTabbedPaneUI.this.getFontMetrics();
            BasicTabbedPaneUI.this.runCount = 0;
            BasicTabbedPaneUI.this.selectedRun = -1;
            int n7 = BasicTabbedPaneUI.this.tabPane.getSelectedIndex();
            if (n == 1 || n == 3) {
                n3 = 0;
                while (n3 < n2) {
                    rectangle = BasicTabbedPaneUI.this.rects[n3];
                    if (n3 > 0) {
                        rectangle.x = BasicTabbedPaneUI.this.rects[n3 - 1].x + BasicTabbedPaneUI.this.rects[n3 - 1].width;
                    } else {
                        BasicTabbedPaneUI.this.tabRuns[0] = 0;
                        BasicTabbedPaneUI.this.runCount = 1;
                        BasicTabbedPaneUI.this.maxTabWidth = 0;
                        rectangle.x = n6;
                    }
                    rectangle.width = BasicTabbedPaneUI.this.calculateTabWidth(n, n3, fontMetrics);
                    BasicTabbedPaneUI.this.maxTabWidth = Math.max(BasicTabbedPaneUI.this.maxTabWidth, rectangle.width);
                    if (rectangle.x != 2 + insets.left && rectangle.x + rectangle.width > n4) {
                        if (BasicTabbedPaneUI.this.runCount > BasicTabbedPaneUI.this.tabRuns.length - 1) {
                            BasicTabbedPaneUI.this.expandTabRunsArray();
                        }
                        BasicTabbedPaneUI.this.tabRuns[BasicTabbedPaneUI.this.runCount] = n3;
                        ++BasicTabbedPaneUI.this.runCount;
                        rectangle.x = n6;
                    }
                    rectangle.y = n5;
                    rectangle.height = BasicTabbedPaneUI.this.maxTabHeight;
                    if (n3 == n7) {
                        BasicTabbedPaneUI.this.selectedRun = BasicTabbedPaneUI.this.runCount - 1;
                    }
                    ++n3;
                }
            } else {
                n3 = 0;
                while (n3 < n2) {
                    rectangle = BasicTabbedPaneUI.this.rects[n3];
                    if (n3 > 0) {
                        rectangle.y = BasicTabbedPaneUI.this.rects[n3 - 1].y + BasicTabbedPaneUI.this.rects[n3 - 1].height;
                    } else {
                        BasicTabbedPaneUI.this.tabRuns[0] = 0;
                        BasicTabbedPaneUI.this.runCount = 1;
                        BasicTabbedPaneUI.this.maxTabHeight = 0;
                        rectangle.y = n5;
                    }
                    rectangle.height = BasicTabbedPaneUI.this.calculateTabHeight(n, n3, fontMetrics.getHeight());
                    BasicTabbedPaneUI.this.maxTabHeight = Math.max(BasicTabbedPaneUI.this.maxTabHeight, rectangle.height);
                    if (rectangle.y != 2 + insets.top && rectangle.y + rectangle.height > n4) {
                        if (BasicTabbedPaneUI.this.runCount > BasicTabbedPaneUI.this.tabRuns.length - 1) {
                            BasicTabbedPaneUI.this.expandTabRunsArray();
                        }
                        BasicTabbedPaneUI.this.tabRuns[BasicTabbedPaneUI.this.runCount] = n3;
                        ++BasicTabbedPaneUI.this.runCount;
                        rectangle.y = n5;
                    }
                    rectangle.x = n6;
                    rectangle.width = BasicTabbedPaneUI.this.maxTabWidth;
                    if (n3 == n7) {
                        BasicTabbedPaneUI.this.selectedRun = BasicTabbedPaneUI.this.runCount - 1;
                    }
                    ++n3;
                }
            }
            if (BasicTabbedPaneUI.this.runCount > 1) {
                n3 = n == 1 || n == 3 ? n5 : n6;
                this.normalizeTabRuns(n, n2, n3, n4);
                BasicTabbedPaneUI.this.selectedRun = BasicTabbedPaneUI.this.getRunForTab(n2, n7);
                if (BasicTabbedPaneUI.this.shouldRotateTabRuns(n)) {
                    this.rotateTabRuns(n, BasicTabbedPaneUI.this.selectedRun);
                }
            }
            n3 = BasicTabbedPaneUI.this.getTabRunOverlay(n);
            int n8 = BasicTabbedPaneUI.this.runCount - 1;
            while (n8 >= 0) {
                int n9;
                int n10;
                int n11 = BasicTabbedPaneUI.this.tabRuns[n8];
                int n12 = n8 == BasicTabbedPaneUI.this.runCount - 1 ? 0 : n8 + 1;
                int n13 = BasicTabbedPaneUI.this.tabRuns[n12];
                int n14 = n10 = n13 != 0 ? n13 - 1 : n2 - 1;
                if (n == 1 || n == 3) {
                    n9 = n11;
                    while (n9 <= n10) {
                        rectangle = BasicTabbedPaneUI.this.rects[n9];
                        rectangle.y = n5;
                        rectangle.x += BasicTabbedPaneUI.this.getTabRunIndent(n, n8);
                        ++n9;
                    }
                    if (BasicTabbedPaneUI.this.shouldPadTabRun(n, n8)) {
                        this.padTabRun(n, n11, n10, n4);
                    }
                    n5 = n == 3 ? (n5 -= BasicTabbedPaneUI.this.maxTabHeight - n3) : (n5 += BasicTabbedPaneUI.this.maxTabHeight - n3);
                } else {
                    n9 = n11;
                    while (n9 <= n10) {
                        rectangle = BasicTabbedPaneUI.this.rects[n9];
                        rectangle.x = n6;
                        rectangle.y += BasicTabbedPaneUI.this.getTabRunIndent(n, n8);
                        ++n9;
                    }
                    if (BasicTabbedPaneUI.this.shouldPadTabRun(n, n8)) {
                        this.padTabRun(n, n11, n10, n4);
                    }
                    n6 = n == 4 ? (n6 -= BasicTabbedPaneUI.this.maxTabWidth - n3) : (n6 += BasicTabbedPaneUI.this.maxTabWidth - n3);
                }
                --n8;
            }
            this.padSelectedTab(n, n7);
        }

        public void layoutContainer(Container container) {
            this.calculateLayoutInfo();
            int n = BasicTabbedPaneUI.this.tabPane.getTabPlacement();
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            int n2 = BasicTabbedPaneUI.this.tabPane.getComponentCount();
            if (n2 > 0) {
                int n3;
                int n4;
                int n5 = 0;
                int n6 = 0;
                switch (n) {
                    case 2: {
                        n5 = BasicTabbedPaneUI.this.calculateTabAreaWidth(n, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabWidth);
                        n4 = n5 + insets.left + BasicTabbedPaneUI.this.contentBorderInsets.left;
                        n3 = insets.top + BasicTabbedPaneUI.this.contentBorderInsets.top;
                        break;
                    }
                    case 4: {
                        n5 = BasicTabbedPaneUI.this.calculateTabAreaWidth(n, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabWidth);
                        n4 = insets.left + BasicTabbedPaneUI.this.contentBorderInsets.left;
                        n3 = insets.top + BasicTabbedPaneUI.this.contentBorderInsets.top;
                        break;
                    }
                    case 3: {
                        n6 = BasicTabbedPaneUI.this.calculateTabAreaHeight(n, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabHeight);
                        n4 = insets.left + BasicTabbedPaneUI.this.contentBorderInsets.left;
                        n3 = insets.top + BasicTabbedPaneUI.this.contentBorderInsets.top;
                        break;
                    }
                    default: {
                        n6 = BasicTabbedPaneUI.this.calculateTabAreaHeight(n, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabHeight);
                        n4 = insets.left + BasicTabbedPaneUI.this.contentBorderInsets.left;
                        n3 = n6 + insets.top + BasicTabbedPaneUI.this.contentBorderInsets.top;
                    }
                }
                Rectangle rectangle = BasicTabbedPaneUI.this.tabPane.getBounds();
                int n7 = rectangle.width - n5 - insets.left - insets.right - BasicTabbedPaneUI.this.contentBorderInsets.left - BasicTabbedPaneUI.this.contentBorderInsets.right;
                int n8 = rectangle.height - n6 - insets.top - insets.bottom - BasicTabbedPaneUI.this.contentBorderInsets.top - BasicTabbedPaneUI.this.contentBorderInsets.bottom;
                int n9 = 0;
                while (n9 < n2) {
                    Component component = BasicTabbedPaneUI.this.tabPane.getComponent(n9);
                    component.setBounds(n4, n3, n7, n8);
                    ++n9;
                }
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.calculateSize(false);
        }

        protected void normalizeTabRuns(int n, int n2, int n3, int n4) {
            Insets insets = BasicTabbedPaneUI.this.getTabAreaInsets(n);
            if (n == 1 || n == 3) {
                int n5 = 1;
                while (n5 < BasicTabbedPaneUI.this.runCount) {
                    Rectangle rectangle = BasicTabbedPaneUI.this.rects[BasicTabbedPaneUI.this.lastTabInRun(n2, n5)];
                    Rectangle rectangle2 = BasicTabbedPaneUI.this.rects[BasicTabbedPaneUI.this.lastTabInRun(n2, BasicTabbedPaneUI.this.getNextTabRun(n5))];
                    int n6 = rectangle.x + rectangle.width;
                    int n7 = rectangle2.x + rectangle2.width;
                    int n8 = n6 - n7;
                    int n9 = n6 - rectangle.width - (n7 + rectangle.width);
                    while (Math.abs(n9) < Math.abs(n8) && n7 + rectangle.width < n4) {
                        int n10 = n5;
                        BasicTabbedPaneUI.this.tabRuns[n10] = BasicTabbedPaneUI.this.tabRuns[n10] - 1;
                        rectangle = BasicTabbedPaneUI.this.rects[BasicTabbedPaneUI.this.lastTabInRun(n2, n5)];
                        n8 = (n6 -= rectangle.width) - (n7 += rectangle.width);
                        n9 = n6 - rectangle.width - (n7 + rectangle.width);
                    }
                    int n11 = BasicTabbedPaneUI.this.lastTabInRun(n2, n5) + 1;
                    int n12 = BasicTabbedPaneUI.this.lastTabInRun(n2, BasicTabbedPaneUI.this.getNextTabRun(n5));
                    int n13 = insets.left;
                    int n14 = n11;
                    while (n14 <= n12) {
                        BasicTabbedPaneUI.this.rects[n14].x = n13;
                        n13 += BasicTabbedPaneUI.this.rects[n14].width;
                        ++n14;
                    }
                    ++n5;
                }
            } else {
                int n15 = 1;
                while (n15 < BasicTabbedPaneUI.this.runCount) {
                    Rectangle rectangle = BasicTabbedPaneUI.this.rects[BasicTabbedPaneUI.this.lastTabInRun(n2, n15)];
                    Rectangle rectangle3 = BasicTabbedPaneUI.this.rects[BasicTabbedPaneUI.this.lastTabInRun(n2, BasicTabbedPaneUI.this.getNextTabRun(n15))];
                    int n16 = rectangle.y + rectangle.height;
                    int n17 = rectangle3.y + rectangle3.height;
                    int n18 = n16 - n17;
                    int n19 = n16 - rectangle.height - (n17 + rectangle.height);
                    while (Math.abs(n19) < Math.abs(n18) && n17 + rectangle.height < n4) {
                        int n20 = n15;
                        BasicTabbedPaneUI.this.tabRuns[n20] = BasicTabbedPaneUI.this.tabRuns[n20] - 1;
                        rectangle = BasicTabbedPaneUI.this.rects[BasicTabbedPaneUI.this.lastTabInRun(n2, n15)];
                        n18 = (n16 -= rectangle.height) - (n17 += rectangle.height);
                        n19 = n16 - rectangle.height - (n17 + rectangle.height);
                    }
                    int n21 = BasicTabbedPaneUI.this.lastTabInRun(n2, n15) + 1;
                    int n22 = BasicTabbedPaneUI.this.lastTabInRun(n2, BasicTabbedPaneUI.this.getNextTabRun(n15));
                    int n23 = insets.top;
                    int n24 = n21;
                    while (n24 <= n22) {
                        BasicTabbedPaneUI.this.rects[n24].y = n23;
                        n23 += BasicTabbedPaneUI.this.rects[n24].height;
                        ++n24;
                    }
                    ++n15;
                }
            }
        }

        protected void padSelectedTab(int n, int n2) {
            Insets insets = BasicTabbedPaneUI.this.getSelectedTabPadInsets(n);
            BasicTabbedPaneUI.this.rects[n2].x -= insets.left;
            BasicTabbedPaneUI.this.rects[n2].y -= insets.top;
            BasicTabbedPaneUI.this.rects[n2].width += insets.left + insets.right;
            BasicTabbedPaneUI.this.rects[n2].height += insets.top + insets.bottom;
        }

        protected void padTabRun(int n, int n2, int n3, int n4) {
            if (n == 1 || n == 3) {
                int n5 = BasicTabbedPaneUI.this.rects[n3].x + BasicTabbedPaneUI.this.rects[n3].width;
                int n6 = n4 - n5;
                int n7 = n3 - n2 + 1;
                int n8 = n6 / n7;
                int n9 = BasicTabbedPaneUI.this.rects[n2].x;
                int n10 = n2;
                while (n10 <= n3) {
                    BasicTabbedPaneUI.this.rects[n10].x = n9;
                    BasicTabbedPaneUI.this.rects[n10].width += n8;
                    n9 += BasicTabbedPaneUI.this.rects[n10].width;
                    if (n10 == n3 && BasicTabbedPaneUI.this.rects[n10].x + BasicTabbedPaneUI.this.rects[n10].width != n4) {
                        BasicTabbedPaneUI.this.rects[n10].width = n4 - BasicTabbedPaneUI.this.rects[n10].x;
                    }
                    ++n10;
                }
            } else {
                int n11 = BasicTabbedPaneUI.this.rects[n3].y + BasicTabbedPaneUI.this.rects[n3].height;
                int n12 = n4 - n11;
                int n13 = n3 - n2 + 1;
                int n14 = n12 / n13;
                int n15 = BasicTabbedPaneUI.this.rects[n2].y;
                int n16 = n2;
                while (n16 <= n3) {
                    BasicTabbedPaneUI.this.rects[n16].y = n15;
                    BasicTabbedPaneUI.this.rects[n16].height += n14;
                    n15 += BasicTabbedPaneUI.this.rects[n16].height;
                    if (n16 == n3 && BasicTabbedPaneUI.this.rects[n16].y + BasicTabbedPaneUI.this.rects[n16].height != n4) {
                        BasicTabbedPaneUI.this.rects[n16].height = n4 - BasicTabbedPaneUI.this.rects[n16].y;
                    }
                    ++n16;
                }
            }
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.calculateSize(false);
        }

        protected int preferredTabAreaHeight(int n, int n2) {
            if (BasicTabbedPaneUI.this.tabPane.getTabCount() == 0) {
                return BasicTabbedPaneUI.this.calculateTabAreaHeight(n, 0, 0);
            }
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            FontMetrics fontMetrics = BasicTabbedPaneUI.this.getFontMetrics();
            Insets insets = BasicTabbedPaneUI.this.getTabAreaInsets(n);
            Insets insets2 = BasicTabbedPaneUI.this.tabPane.getInsets();
            n2 -= insets.left + insets.right + insets2.left + insets2.right;
            int n6 = 0;
            while (n6 < BasicTabbedPaneUI.this.tabPane.getTabCount()) {
                n5 = BasicTabbedPaneUI.this.calculateTabWidth(n, n6, fontMetrics);
                if (n4 + n5 > n2) {
                    n4 = n5;
                    ++n3;
                } else {
                    n4 += n5;
                }
                ++n6;
            }
            n6 = BasicTabbedPaneUI.this.calculateMaxTabHeight(n);
            int n7 = BasicTabbedPaneUI.this.calculateTabAreaHeight(n, ++n3, n6);
            return n7;
        }

        protected int preferredTabAreaWidth(int n, int n2) {
            if (BasicTabbedPaneUI.this.tabPane.getTabCount() == 0) {
                return BasicTabbedPaneUI.this.calculateTabAreaHeight(n, 0, 0);
            }
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            FontMetrics fontMetrics = BasicTabbedPaneUI.this.getFontMetrics();
            Insets insets = BasicTabbedPaneUI.this.getTabAreaInsets(n);
            Insets insets2 = BasicTabbedPaneUI.this.tabPane.getInsets();
            n2 -= insets.top + insets.bottom + insets2.top + insets2.bottom;
            int n6 = fontMetrics.getHeight();
            int n7 = 0;
            while (n7 < BasicTabbedPaneUI.this.tabPane.getTabCount()) {
                n5 = BasicTabbedPaneUI.this.calculateTabHeight(n, n7, n6);
                if (n4 + n5 > n2) {
                    n4 = n5;
                    ++n3;
                } else {
                    n4 += n5;
                }
                ++n7;
            }
            n7 = BasicTabbedPaneUI.this.calculateMaxTabWidth(n);
            int n8 = BasicTabbedPaneUI.this.calculateTabAreaWidth(n, ++n3, n7);
            return n8;
        }

        protected void rotateTabRuns(int n, int n2) {
            if (BasicTabbedPaneUI.this.runCount == 1 || n2 == 1 || n2 == -1) {
                return;
            }
            int[] nArray = new int[BasicTabbedPaneUI.this.tabRuns.length];
            int n3 = n2;
            int n4 = 1;
            do {
                nArray[n4] = BasicTabbedPaneUI.this.tabRuns[n3];
                n3 = BasicTabbedPaneUI.this.getNextTabRun(n3);
            } while (++n4 < BasicTabbedPaneUI.this.runCount);
            if (BasicTabbedPaneUI.this.runCount > 1) {
                nArray[0] = BasicTabbedPaneUI.this.tabRuns[n3];
            }
            BasicTabbedPaneUI.this.tabRuns = nArray;
            BasicTabbedPaneUI.this.selectedRun = 1;
        }

        public void removeLayoutComponent(Component component) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ScrollingViewport
    extends JViewport
    implements UIResource {
        private ScrollingViewport() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ScrollingPanel
    extends JPanel {
        public void updateUI() {
            this.setUI(new ScrollingPanelUI());
        }

        private ScrollingPanel() {
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        private class ScrollingPanelUI
        extends BasicPanelUI {
            public void paint(Graphics graphics, JComponent jComponent) {
                BasicTabbedPaneUI.this.paintTabArea(graphics, BasicTabbedPaneUI.this.tabPane.getTabPlacement(), BasicTabbedPaneUI.this.tabPane.getSelectedIndex());
            }

            private ScrollingPanelUI() {
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class TabbedPaneScrollLayout
    extends TabbedPaneLayout {
        public Dimension preferredLayoutSize(Container container) {
            return super.calculateSize(true);
        }

        public Dimension minimumLayoutSize(Container container) {
            return super.calculateSize(true);
        }

        protected int preferredTabAreaHeight(int n, int n2) {
            if (BasicTabbedPaneUI.this.tabPane.getTabCount() == 0) {
                return BasicTabbedPaneUI.this.calculateTabAreaHeight(n, 0, 0);
            }
            int n3 = 1;
            int n4 = BasicTabbedPaneUI.this.calculateMaxTabHeight(n);
            int n5 = BasicTabbedPaneUI.this.calculateTabAreaHeight(n, n3, n4);
            return n5;
        }

        protected int preferredTabAreaWidth(int n, int n2) {
            if (BasicTabbedPaneUI.this.tabPane.getTabCount() == 0) {
                return BasicTabbedPaneUI.this.calculateTabAreaHeight(n, 0, 0);
            }
            int n3 = 1;
            int n4 = BasicTabbedPaneUI.this.calculateMaxTabWidth(n);
            int n5 = BasicTabbedPaneUI.this.calculateTabAreaWidth(n, n3, n4);
            return n5;
        }

        protected void calculateTabRects(int n, int n2) {
            if (n2 == 0) {
                return;
            }
            FontMetrics fontMetrics = BasicTabbedPaneUI.this.getFontMetrics();
            SwingUtilities.calculateInnerArea(BasicTabbedPaneUI.this.tabPane, BasicTabbedPaneUI.this.calcRect);
            Insets insets = BasicTabbedPaneUI.this.getTabAreaInsets(n);
            Insets insets2 = BasicTabbedPaneUI.this.tabPane.getInsets();
            int n3 = 1;
            int n4 = 0;
            int n5 = 0;
            if (n == 1 || n == 3) {
                int n6 = BasicTabbedPaneUI.this.calculateMaxTabHeight(n);
                BasicTabbedPaneUI.this.calcRect.width -= insets.left + insets.right;
                n4 = insets.left + insets2.left;
                int n7 = 0;
                int n8 = n4;
                n5 = insets2.top + insets.top;
                int n9 = 0;
                while (n9 < n2) {
                    n7 = BasicTabbedPaneUI.this.calculateTabWidth(n, n9, fontMetrics);
                    BasicTabbedPaneUI.this.rects[n9] = new Rectangle(n8, n5, n7, n6);
                    n8 += n7;
                    ++n9;
                }
                BasicTabbedPaneUI.this.tabAreaRect.width = BasicTabbedPaneUI.this.tabPane.getWidth() - insets2.left - insets2.right;
                BasicTabbedPaneUI.this.tabAreaRect.height = n3 * BasicTabbedPaneUI.this.maxTabHeight - (n3 - 1) * BasicTabbedPaneUI.this.tabRunOverlay + insets.top + insets.bottom;
                BasicTabbedPaneUI.this.contentRect.width = BasicTabbedPaneUI.this.tabAreaRect.width;
                BasicTabbedPaneUI.this.contentRect.height = BasicTabbedPaneUI.this.tabPane.getHeight() - insets2.top - insets2.bottom - BasicTabbedPaneUI.this.tabAreaRect.height;
                BasicTabbedPaneUI.this.contentRect.x = insets2.left;
                BasicTabbedPaneUI.this.tabAreaRect.x = insets2.left;
                if (n == 3) {
                    BasicTabbedPaneUI.this.contentRect.y = insets2.top;
                    BasicTabbedPaneUI.this.tabAreaRect.y = BasicTabbedPaneUI.this.contentRect.y + BasicTabbedPaneUI.this.contentRect.height;
                } else {
                    BasicTabbedPaneUI.this.tabAreaRect.y = insets2.top;
                    BasicTabbedPaneUI.this.contentRect.y = BasicTabbedPaneUI.this.tabAreaRect.y + BasicTabbedPaneUI.this.tabAreaRect.height;
                }
            } else {
                int n10 = BasicTabbedPaneUI.this.calculateMaxTabWidth(n);
                BasicTabbedPaneUI.this.calcRect.height -= insets.top + insets.bottom;
                int n11 = 0;
                int n12 = n4 = insets.top + insets2.top;
                int n13 = fontMetrics.getHeight();
                n5 = insets2.left + insets.left;
                int n14 = 0;
                while (n14 < n2) {
                    n11 = BasicTabbedPaneUI.this.calculateTabHeight(n, n14, n13);
                    BasicTabbedPaneUI.this.rects[n14] = new Rectangle(n5, n12, n10, n11);
                    n12 += n11;
                    ++n14;
                }
                BasicTabbedPaneUI.this.tabAreaRect.width = n3 * BasicTabbedPaneUI.this.maxTabWidth - (n3 - 1) * BasicTabbedPaneUI.this.tabRunOverlay + insets.left + insets.right;
                BasicTabbedPaneUI.this.tabAreaRect.height = BasicTabbedPaneUI.this.tabPane.getHeight() - insets2.top - insets2.bottom;
                BasicTabbedPaneUI.this.tabAreaRect.y = insets2.top;
                BasicTabbedPaneUI.this.contentRect.width = BasicTabbedPaneUI.this.tabPane.getWidth() - insets2.left - insets2.right - BasicTabbedPaneUI.this.tabAreaRect.width;
                BasicTabbedPaneUI.this.contentRect.height = BasicTabbedPaneUI.this.tabAreaRect.height;
                BasicTabbedPaneUI.this.contentRect.y = insets2.top;
                if (n == 2) {
                    BasicTabbedPaneUI.this.tabAreaRect.x = insets2.left;
                    BasicTabbedPaneUI.this.contentRect.x = BasicTabbedPaneUI.this.tabAreaRect.x + BasicTabbedPaneUI.this.tabAreaRect.width;
                } else {
                    BasicTabbedPaneUI.this.contentRect.x = insets2.left;
                    BasicTabbedPaneUI.this.tabAreaRect.x = BasicTabbedPaneUI.this.contentRect.x + BasicTabbedPaneUI.this.contentRect.width;
                }
            }
            BasicTabbedPaneUI.this.runCount = n3;
            if (BasicTabbedPaneUI.this.runCount > BasicTabbedPaneUI.this.tabRuns.length) {
                BasicTabbedPaneUI.this.expandTabRunsArray();
            }
            this.padSelectedTab(n, BasicTabbedPaneUI.this.tabPane.getSelectedIndex());
        }

        public void layoutContainer(Container container) {
            Dimension dimension;
            Dimension dimension2;
            super.layoutContainer(container);
            int n = BasicTabbedPaneUI.this.tabPane.getTabCount();
            Point point = null;
            if (n == 0) {
                return;
            }
            int n2 = BasicTabbedPaneUI.this.tabPane.getTabPlacement();
            BasicTabbedPaneUI.this.incrButton.setVisible(false);
            BasicTabbedPaneUI.this.decrButton.setVisible(false);
            if ((n2 == 1 || n2 == 3) && BasicTabbedPaneUI.this.tabAreaRect.x + BasicTabbedPaneUI.this.tabAreaRect.width < BasicTabbedPaneUI.this.rects[n - 1].x + BasicTabbedPaneUI.this.rects[n - 1].width) {
                dimension2 = BasicTabbedPaneUI.this.incrButton.getPreferredSize();
                dimension = BasicTabbedPaneUI.this.decrButton.getPreferredSize();
                BasicTabbedPaneUI.this.decrButton.setBounds(BasicTabbedPaneUI.this.tabAreaRect.x + BasicTabbedPaneUI.this.tabAreaRect.width - dimension2.width - dimension.width, BasicTabbedPaneUI.this.tabAreaRect.y, dimension.width, BasicTabbedPaneUI.this.tabAreaRect.height);
                BasicTabbedPaneUI.this.incrButton.setBounds(BasicTabbedPaneUI.this.tabAreaRect.x + BasicTabbedPaneUI.this.tabAreaRect.width - dimension2.width, BasicTabbedPaneUI.this.tabAreaRect.y, dimension.width, BasicTabbedPaneUI.this.tabAreaRect.height);
                BasicTabbedPaneUI.this.tabAreaRect.width -= dimension.width + dimension2.width;
                BasicTabbedPaneUI.this.incrButton.setVisible(true);
                BasicTabbedPaneUI.this.decrButton.setVisible(true);
            }
            if ((n2 == 2 || n2 == 4) && BasicTabbedPaneUI.this.tabAreaRect.y + BasicTabbedPaneUI.this.tabAreaRect.height < BasicTabbedPaneUI.this.rects[n - 1].y + BasicTabbedPaneUI.this.rects[n - 1].height) {
                dimension2 = BasicTabbedPaneUI.this.incrButton.getPreferredSize();
                dimension = BasicTabbedPaneUI.this.decrButton.getPreferredSize();
                BasicTabbedPaneUI.this.decrButton.setBounds(BasicTabbedPaneUI.this.tabAreaRect.x, BasicTabbedPaneUI.this.tabAreaRect.y + BasicTabbedPaneUI.this.tabAreaRect.height - dimension2.height - dimension.height, BasicTabbedPaneUI.this.tabAreaRect.width, dimension.height);
                BasicTabbedPaneUI.this.incrButton.setBounds(BasicTabbedPaneUI.this.tabAreaRect.x, BasicTabbedPaneUI.this.tabAreaRect.y + BasicTabbedPaneUI.this.tabAreaRect.height - dimension2.height, BasicTabbedPaneUI.this.tabAreaRect.width, dimension2.height);
                BasicTabbedPaneUI.this.tabAreaRect.height -= dimension.height + dimension2.height;
                BasicTabbedPaneUI.this.incrButton.setVisible(true);
                BasicTabbedPaneUI.this.decrButton.setVisible(true);
            }
            BasicTabbedPaneUI.this.viewport.setBounds(BasicTabbedPaneUI.this.tabAreaRect.x, BasicTabbedPaneUI.this.tabAreaRect.y, BasicTabbedPaneUI.this.tabAreaRect.width, BasicTabbedPaneUI.this.tabAreaRect.height);
            int n3 = BasicTabbedPaneUI.this.tabPane.getTabCount() - 1;
            if (n > 0) {
                int n4 = Math.max(BasicTabbedPaneUI.this.rects[n3].width + BasicTabbedPaneUI.this.rects[n3].x, BasicTabbedPaneUI.this.tabAreaRect.width);
                int n5 = Math.max(BasicTabbedPaneUI.this.rects[n3].height, BasicTabbedPaneUI.this.tabAreaRect.height);
                point = BasicTabbedPaneUI.this.findPointForIndex(BasicTabbedPaneUI.this.currentScrollLocation);
                BasicTabbedPaneUI.this.panel.setSize(n4 + point.x, n5 + point.y);
            }
            BasicTabbedPaneUI.this.viewport.setViewPosition(point);
            BasicTabbedPaneUI.this.viewport.repaint();
        }

        private TabbedPaneScrollLayout() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class MouseHandler
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            int n;
            if (BasicTabbedPaneUI.this.tabPane.isEnabled() && (n = BasicTabbedPaneUI.this.tabForCoordinate(BasicTabbedPaneUI.this.tabPane, mouseEvent.getX(), mouseEvent.getY())) >= 0 && BasicTabbedPaneUI.this.tabPane.isEnabledAt(n)) {
                BasicTabbedPaneUI.this.tabPane.setSelectedIndex(n);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            int n = BasicTabbedPaneUI.this.tabForCoordinate(BasicTabbedPaneUI.this.tabPane, mouseEvent.getX(), mouseEvent.getY());
            BasicTabbedPaneUI.this.setRolloverTab(n);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            BasicTabbedPaneUI.this.setRolloverTab(-1);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = BasicTabbedPaneUI.this.tabForCoordinate(BasicTabbedPaneUI.this.tabPane, mouseEvent.getX(), mouseEvent.getY());
            BasicTabbedPaneUI.this.setRolloverTab(n);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class FocusHandler
    extends FocusAdapter {
        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class TabSelectionHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            BasicTabbedPaneUI.this.selectedRun = BasicTabbedPaneUI.this.getRunForTab(BasicTabbedPaneUI.this.tabPane.getTabCount(), BasicTabbedPaneUI.this.tabPane.getSelectedIndex());
            BasicTabbedPaneUI.this.tabPane.revalidate();
            BasicTabbedPaneUI.this.tabPane.repaint();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("tabLayoutPolicy")) {
                BasicTabbedPaneUI.this.layoutManager = BasicTabbedPaneUI.this.createLayoutManager();
                BasicTabbedPaneUI.this.tabPane.setLayout(BasicTabbedPaneUI.this.layoutManager);
            } else if (propertyChangeEvent.getPropertyName().equals("tabPlacement") && BasicTabbedPaneUI.this.tabPane.getTabLayoutPolicy() == 1) {
                BasicTabbedPaneUI.this.incrButton = BasicTabbedPaneUI.this.createIncreaseButton();
                BasicTabbedPaneUI.this.decrButton = BasicTabbedPaneUI.this.createDecreaseButton();
            }
            BasicTabbedPaneUI.this.tabPane.revalidate();
            BasicTabbedPaneUI.this.tabPane.repaint();
        }
    }
}

