/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;

public class TransferHandler
implements Serializable {
    private static final long serialVersionUID = -967749805571669910L;
    private static final String COMMAND_COPY = "copy";
    private static final String COMMAND_CUT = "cut";
    private static final String COMMAND_PASTE = "paste";
    public static final int NONE = 0;
    public static final int COPY = 1;
    public static final int MOVE = 2;
    public static final int COPY_OR_MOVE = 3;
    private static Action copyAction = new TransferAction("copy");
    private static Action cutAction = new TransferAction("cut");
    private static Action pasteAction = new TransferAction("paste");
    private int sourceActions;
    private Icon visualRepresentation;

    public static Action getCopyAction() {
        return copyAction;
    }

    public static Action getCutAction() {
        return cutAction;
    }

    public static Action getPasteAction() {
        return pasteAction;
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        return false;
    }

    protected Transferable createTransferable(JComponent jComponent) {
        return null;
    }

    public void exportAsDrag(JComponent jComponent, InputEvent inputEvent, int n) {
    }

    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
    }

    public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) {
    }

    public int getSourceActions(JComponent jComponent) {
        return this.sourceActions;
    }

    public Icon getVisualRepresentation(Transferable transferable) {
        return this.visualRepresentation;
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        return false;
    }

    static /* synthetic */ String access$0() {
        return COMMAND_COPY;
    }

    static /* synthetic */ String access$1() {
        return COMMAND_CUT;
    }

    static /* synthetic */ String access$2() {
        return COMMAND_PASTE;
    }

    protected TransferHandler() {
        this.sourceActions = 0;
    }

    public TransferHandler(String string) {
        int n = 0;
        if (string != null) {
            n = 1;
        }
        this.sourceActions = n;
    }

    static class TransferAction
    extends AbstractAction {
        private String command;

        public void actionPerformed(ActionEvent actionEvent) {
            Transferable transferable;
            JComponent jComponent = (JComponent)actionEvent.getSource();
            TransferHandler transferHandler = jComponent.getTransferHandler();
            Clipboard clipboard = TransferAction.getClipboard(jComponent);
            if (clipboard == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (this.command.equals(TransferHandler.COMMAND_COPY)) {
                transferHandler.exportToClipboard(jComponent, clipboard, 1);
            } else if (this.command.equals(TransferHandler.COMMAND_CUT)) {
                transferHandler.exportToClipboard(jComponent, clipboard, 2);
            } else if (this.command.equals(TransferHandler.COMMAND_PASTE) && (transferable = clipboard.getContents(null)) != null) {
                transferHandler.importData(jComponent, transferable);
            }
        }

        private static final Clipboard getClipboard(JComponent jComponent) {
            try {
                return jComponent.getToolkit().getSystemClipboard();
            }
            catch (SecurityException securityException) {
                return null;
            }
        }

        public TransferAction(String string) {
            super(string);
            this.command = string;
        }
    }
}

