/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CharacterIterator;
import java.text.CollationElementIterator;
import java.text.CollationKey;
import java.text.Collator;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;

public class RuleBasedCollator
extends Collator {
    static final CollationElement SPECIAL_UNKNOWN_SEQ = new CollationElement("", Short.MAX_VALUE, 0, 0, 0, null, false);
    private String rules;
    private Object[] ce_table;
    HashMap prefix_tree;
    private int last_primary_value;
    private int last_tertiary_value;
    private boolean inverseAccentComparison;

    static int findPrefixLength(String string, String string2) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n && n2 < string2.length()) {
            if (string.charAt(n2) != string2.charAt(n2)) {
                return n2;
            }
            ++n2;
        }
        return n2;
    }

    private final void mergeRules(int n, String string, ArrayList arrayList, ArrayList arrayList2) throws ParseException {
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        while (n4 < arrayList2.size()) {
            int n5 = 0;
            while (n5 < arrayList.size()) {
                CollationSorter collationSorter = (CollationSorter)arrayList2.get(n4);
                CollationSorter collationSorter2 = (CollationSorter)arrayList.get(n5);
                if (collationSorter.textElement.equals(collationSorter2.textElement)) {
                    arrayList.remove(n5);
                    continue;
                }
                ++n5;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < arrayList.size()) {
            CollationSorter collationSorter = (CollationSorter)arrayList.get(n4);
            int n6 = RuleBasedCollator.findPrefixLength(string, collationSorter.textElement);
            if (n6 > n3) {
                n3 = n6;
                n2 = n4 + 1;
            }
            ++n4;
        }
        if (n2 < 0) {
            throw new ParseException("no insertion point found for " + string, n);
        }
        if (n3 < string.length()) {
            CollationSorter collationSorter = (CollationSorter)arrayList2.get(0);
            CollationSorter collationSorter3 = (CollationSorter)arrayList.get(n2 - 1);
            collationSorter.expansionOrdering = string.substring(n3);
            arrayList.add(n2, collationSorter);
            arrayList2.remove(0);
            ++n2;
        }
        int n7 = 0;
        while (n7 < arrayList2.size()) {
            arrayList.add(n7 + n2, arrayList2.get(n7));
            ++n7;
        }
    }

    private final int subParseString(boolean bl, ArrayList arrayList, int n, String string) throws ParseException {
        int n2;
        boolean bl2 = false;
        if (n == 0) {
            bl2 = true;
        }
        boolean bl3 = bl2;
        int n3 = -1;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        int n4 = 0;
        block10: while (n4 < string.length()) {
            char c = string.charAt(n4);
            n2 = -1;
            if (bl5 || (c < '\t' || c > '\r') && c != ' ') {
                bl7 = bl6;
                bl6 = false;
                if (bl5 && c != '\'') {
                    bl4 = false;
                    stringBuffer.append(c);
                } else if (bl4 && bl5) {
                    stringBuffer.append(c);
                    bl4 = false;
                } else {
                    switch (c) {
                        case '!': {
                            throw new ParseException("Modifier '!' is not yet supported by Classpath", n4 + n);
                        }
                        case '<': {
                            n2 = 0;
                            break;
                        }
                        case ';': {
                            n2 = 1;
                            break;
                        }
                        case ',': {
                            n2 = 2;
                            break;
                        }
                        case '=': {
                            n2 = 3;
                            break;
                        }
                        case '\'': {
                            bl5 ^= true;
                            bl4 = true;
                            break;
                        }
                        case '@': {
                            if (bl3) {
                                throw new ParseException("comparison list has not yet been started. You may only use(<,;=&)", n4 + n);
                            }
                            bl6 = true;
                            n2 = 5;
                            break;
                        }
                        case '&': {
                            n2 = 4;
                            if (!bl) break;
                            break block10;
                        }
                        default: {
                            if (n3 < 0) {
                                throw new ParseException("operator missing at " + (n4 + n), n4 + n);
                            }
                            if (!bl5 && (c >= '!' && c <= '/' || c >= ':' && c <= '@' || c >= '[' && c <= '`' || c >= '{' && c <= '~')) {
                                throw new ParseException("unquoted punctuation character '" + c + '\'', n4 + n);
                            }
                            stringBuffer.append(c);
                        }
                    }
                    if (n2 >= 0) {
                        if (n3 < 0) {
                            n3 = n2;
                        } else {
                            Object object;
                            if (stringBuffer.length() == 0 && !bl7) {
                                throw new ParseException("text element empty at " + (n4 + n), n4 + n);
                            }
                            if (n3 == 4) {
                                object = string.substring(n4);
                                ArrayList arrayList2 = new ArrayList();
                                int n5 = this.subParseString(true, arrayList2, n + n4, (String)object);
                                this.mergeRules(n + n4, stringBuffer.toString(), arrayList, arrayList2);
                                stringBuffer.setLength(0);
                                n3 = -1;
                                n2 = -1;
                                if (n5 < 0) break;
                                n4 += n5 - 1;
                            } else {
                                object = new CollationSorter();
                                if (n3 == 0) {
                                    bl3 = false;
                                }
                                ((CollationSorter)object).comparisonType = n3;
                                ((CollationSorter)object).textElement = stringBuffer.toString();
                                ((CollationSorter)object).hashText = ((CollationSorter)object).textElement.hashCode();
                                ((CollationSorter)object).offset = n + string.length();
                                ((CollationSorter)object).ignore = bl3;
                                stringBuffer.setLength(0);
                                arrayList.add(object);
                                n3 = n2;
                            }
                        }
                    }
                }
            }
            ++n4;
        }
        if (n3 >= 0) {
            CollationSorter collationSorter = new CollationSorter();
            n2 = string.length() + n;
            if (stringBuffer.length() != 0 && bl6 || stringBuffer.length() == 0 && !bl6 && !bl5) {
                throw new ParseException("text element empty at " + n2, n2);
            }
            if (n3 == 0) {
                bl3 = false;
            }
            collationSorter.comparisonType = n3;
            collationSorter.textElement = stringBuffer.toString();
            collationSorter.hashText = collationSorter.textElement.hashCode();
            collationSorter.offset = n + n2;
            collationSorter.ignore = bl3;
            arrayList.add(collationSorter);
        }
        if (n4 == string.length()) {
            return -1;
        }
        return n4;
    }

    public Object clone() {
        return super.clone();
    }

    private final ArrayList parseString(String string) throws ParseException {
        ArrayList arrayList = new ArrayList();
        this.subParseString(false, arrayList, 0, string);
        return arrayList;
    }

    private final void buildCollationVector(ArrayList arrayList) throws ParseException {
        int n = 0;
        short s = 0;
        short s2 = 0;
        short s3 = 0;
        short s4 = 0;
        boolean bl = false;
        boolean bl2 = true;
        ArrayList arrayList2 = new ArrayList();
        int n2 = 0;
        while (n2 < arrayList.size()) {
            block12: {
                CollationSorter collationSorter = (CollationSorter)arrayList.get(n2);
                boolean bl3 = false;
                switch (collationSorter.comparisonType) {
                    case 0: {
                        ++n;
                        if (bl) {
                            s2 = Short.MAX_VALUE;
                            bl2 = false;
                        } else {
                            s2 = 0;
                            bl2 = true;
                        }
                        s3 = 0;
                        s4 = 0;
                        bl = false;
                        break;
                    }
                    case 1: {
                        s2 = !bl2 ? (short)((short)(s2 - 1)) : (short)((short)(s2 + 1));
                        s3 = 0;
                        s4 = 0;
                        break;
                    }
                    case 5: {
                        bl = true;
                        break block12;
                    }
                    case 2: {
                        s3 = (short)(s3 + 1);
                        if (n == 0) {
                            s = s3;
                        }
                        s4 = 0;
                        break;
                    }
                    case 3: {
                        s4 = (short)(s4 + 1);
                        break;
                    }
                    case 4: {
                        throw new ParseException("Invalid reached state 'RESET'. Internal error", collationSorter.offset);
                    }
                    default: {
                        throw new ParseException("Invalid unknown state '" + collationSorter.comparisonType + '\'', collationSorter.offset);
                    }
                }
                arrayList2.add(new CollationElement(collationSorter.textElement, n, s2, s3, s4, collationSorter.expansionOrdering, collationSorter.ignore));
            }
            ++n2;
        }
        this.inverseAccentComparison = bl;
        this.ce_table = arrayList2.toArray();
        this.last_primary_value = n + 1;
        this.last_tertiary_value = s + 1;
    }

    private final void buildPrefixAccess() {
        this.prefix_tree = new HashMap();
        int n = 0;
        while (n < this.ce_table.length) {
            CollationElement collationElement = (CollationElement)this.ce_table[n];
            this.prefix_tree.put(collationElement.key, collationElement);
            ++n;
        }
    }

    public int compare(String string, String string2) {
        CollationElement collationElement = null;
        CollationElement collationElement2 = null;
        boolean bl = true;
        boolean bl2 = true;
        CollationElementIterator collationElementIterator = this.getCollationElementIterator(string);
        CollationElementIterator collationElementIterator2 = this.getCollationElementIterator(string2);
        while (true) {
            short s;
            short s2;
            if (bl && (collationElement = collationElementIterator.nextBlock()) != null && collationElement.ignore) continue;
            if (bl2) {
                collationElement2 = collationElementIterator2.nextBlock();
                if (collationElement2 != null && collationElement2.ignore) {
                    bl = false;
                    continue;
                }
            } else {
                bl2 = true;
            }
            if (!bl) {
                bl = true;
            }
            if (collationElement == null) {
                if (collationElement2 == null) {
                    return 0;
                }
                return -1;
            }
            int n = collationElement.getValue();
            if (collationElement2 == null) {
                return 1;
            }
            int n2 = collationElement2.getValue();
            if (n == n2) {
                if (this.getStrength() != 3 || collationElement.key.equals(collationElement2.key)) continue;
                return collationElement.key.compareTo(collationElement2.key);
            }
            int n3 = CollationElementIterator.primaryOrder(n);
            int n4 = CollationElementIterator.primaryOrder(n2);
            if (n3 == 0 && this.getStrength() < 2) {
                bl2 = false;
                continue;
            }
            if (n4 == 0 && this.getStrength() < 2) {
                bl = false;
                continue;
            }
            if (n3 < n4) {
                return -1;
            }
            if (n3 > n4) {
                return 1;
            }
            if (this.getStrength() == 0) continue;
            short s3 = CollationElementIterator.secondaryOrder(n);
            if (s3 < (s2 = CollationElementIterator.secondaryOrder(n2))) {
                return -1;
            }
            if (s3 > s2) {
                return 1;
            }
            if (this.getStrength() == 1) continue;
            short s4 = CollationElementIterator.tertiaryOrder(n);
            if (s4 < (s = CollationElementIterator.tertiaryOrder(n2))) {
                return -1;
            }
            if (s4 > s) {
                return 1;
            }
            if (this.getStrength() != 2) break;
        }
        return collationElement.key.compareTo(collationElement2.key);
    }

    public boolean equals(Object object) {
        return object == this;
    }

    CollationElement getDefaultElement(char c) {
        int n = this.inverseAccentComparison && c >= '\u02b9' && c <= '\u0361' ? 865 - (c - 697) : (int)c;
        return new CollationElement("" + c, this.last_primary_value + n, 0, 0, 0, null, false);
    }

    CollationElement getDefaultAccentedElement(char c) {
        int n = this.inverseAccentComparison && c >= '\u02b9' && c <= '\u0361' ? 865 - (c - 697) : (int)c;
        return new CollationElement("" + c, 0, 0, (short)(this.last_tertiary_value + n), 0, null, false);
    }

    public CollationElementIterator getCollationElementIterator(String string) {
        return new CollationElementIterator(this, string);
    }

    public CollationElementIterator getCollationElementIterator(CharacterIterator characterIterator) {
        StringBuffer stringBuffer = new StringBuffer("");
        char c = characterIterator.first();
        while (c != (char)-1) {
            this.decomposeCharacter(c, stringBuffer);
            c = characterIterator.next();
        }
        return this.getCollationElementIterator(stringBuffer.toString());
    }

    public CollationKey getCollationKey(String string) {
        CollationElementIterator collationElementIterator = this.getCollationElementIterator(string);
        ArrayList arrayList = new ArrayList();
        int n = collationElementIterator.next();
        collationElementIterator.reset();
        while (n != -1) {
            if (CollationElementIterator.primaryOrder(n) == 0) {
                n = collationElementIterator.next();
                continue;
            }
            switch (this.getStrength()) {
                case 0: {
                    n = CollationElementIterator.primaryOrder(n);
                    break;
                }
                case 1: {
                    n = CollationElementIterator.primaryOrder(n) << 8;
                    n |= CollationElementIterator.secondaryOrder(n);
                }
            }
            arrayList.add(new Integer(n));
            n = collationElementIterator.next();
        }
        Object[] objectArray = arrayList.toArray();
        byte[] byArray = new byte[objectArray.length * 4];
        int n2 = 0;
        while (n2 < objectArray.length) {
            int n3 = (Integer)objectArray[n2];
            byArray[n2 * 4] = (byte)((n3 & 0xFF000000) >> 24);
            byArray[n2 * 4 + 1] = (byte)((n3 & 0xFF0000) >> 16);
            byArray[n2 * 4 + 2] = (byte)((n3 & 0xFF00) >> 8);
            byArray[n2 * 4 + 3] = (byte)(n3 & 0xFF);
            ++n2;
        }
        return new CollationKey(this, string, byArray);
    }

    public String getRules() {
        return this.rules;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public RuleBasedCollator(String string) throws ParseException {
        if (string.equals("")) {
            throw new ParseException("empty rule set", 0);
        }
        this.rules = string;
        this.buildCollationVector(this.parseString(string));
        this.buildPrefixAccess();
    }

    static final class CollationSorter {
        static final int GREATERP = 0;
        static final int GREATERS = 1;
        static final int GREATERT = 2;
        static final int EQUAL = 3;
        static final int RESET = 4;
        static final int INVERSE_SECONDARY = 5;
        int comparisonType;
        String textElement;
        int hashText;
        int offset;
        boolean ignore;
        String expansionOrdering;

        CollationSorter() {
        }
    }

    static final class CollationElement {
        String key;
        int primary;
        short secondary;
        short tertiary;
        short equality;
        boolean ignore;
        String expansion;

        final int getValue() {
            return (this.primary << 16) + (this.secondary << 8) + this.tertiary;
        }

        CollationElement(String string, int n, short s, short s2, short s3, String string2, boolean bl) {
            this.key = string;
            this.primary = n;
            this.secondary = s;
            this.tertiary = s2;
            this.equality = s3;
            this.ignore = bl;
            this.expansion = string2;
        }
    }
}

