/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import gnu.java.security.Engine;
import gnu.java.security.jce.prng.Sha160RandomSpi;
import java.lang.reflect.InvocationTargetException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandomSpi;
import java.security.Security;
import java.util.Enumeration;
import java.util.Random;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SecureRandom
extends Random {
    private static final String SECURE_RANDOM = "SecureRandom";
    private static final long serialVersionUID = 4940670005562187L;
    long counter;
    Provider provider;
    byte[] randomBytes;
    int randomBytesUsed;
    SecureRandomSpi secureRandomSpi;
    byte[] state;

    public static SecureRandom getInstance(String string) throws NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        int n = 0;
        while (n < providerArray.length) {
            try {
                return SecureRandom.getInstance(string, providerArray[n]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                ++n;
            }
        }
        throw new NoSuchAlgorithmException(string);
    }

    public static SecureRandom getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("Illegal provider");
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(string2);
        }
        return SecureRandom.getInstance(string, provider);
    }

    public static SecureRandom getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("Illegal provider");
        }
        try {
            return new SecureRandom((SecureRandomSpi)Engine.getInstance(SECURE_RANDOM, string, provider), provider);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new NoSuchAlgorithmException(string);
        }
        catch (ClassCastException classCastException) {
            throw new NoSuchAlgorithmException(string);
        }
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public void setSeed(byte[] byArray) {
        this.secureRandomSpi.engineSetSeed(byArray);
    }

    public void setSeed(long l) {
        if (this.secureRandomSpi != null) {
            byte[] byArray = new byte[]{(byte)(0xFFL & l >> 56), (byte)(0xFFL & l >> 48), (byte)(0xFFL & l >> 40), (byte)(0xFFL & l >> 32), (byte)(0xFFL & l >> 24), (byte)(0xFFL & l >> 16), (byte)(0xFFL & l >> 8), (byte)(0xFFL & l)};
            this.secureRandomSpi.engineSetSeed(byArray);
        }
    }

    public void nextBytes(byte[] byArray) {
        this.randomBytesUsed += byArray.length;
        ++this.counter;
        this.secureRandomSpi.engineNextBytes(byArray);
    }

    protected final int next(int n) {
        if (n == 0) {
            return 0;
        }
        byte[] byArray = new byte[n / 8 + n % 8];
        this.secureRandomSpi.engineNextBytes(byArray);
        this.randomBytesUsed += byArray.length;
        ++this.counter;
        int n2 = 0;
        int n3 = 0;
        while (n3 < byArray.length) {
            n2 |= (byArray[n3] & 0xFF) << 8 * n3;
            ++n3;
        }
        long l = (1L << n) - 1L;
        return (int)((long)n2 & l);
    }

    public static byte[] getSeed(int n) {
        byte[] byArray = new byte[n];
        new Random().nextBytes(byArray);
        return byArray;
    }

    public byte[] generateSeed(int n) {
        return this.secureRandomSpi.engineGenerateSeed(n);
    }

    private final /* synthetic */ void this() {
        this.counter = 0L;
        this.provider = null;
        this.randomBytes = null;
        this.randomBytesUsed = 0;
        this.secureRandomSpi = null;
        this.state = null;
    }

    public SecureRandom() {
        this.this();
        Provider[] providerArray = Security.getProviders();
        String string = null;
        int n = 0;
        while (n < providerArray.length) {
            Enumeration enumeration = providerArray[n].propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (!string2.startsWith("SECURERANDOM.") || (string = providerArray[n].getProperty(string2)) == null) continue;
                try {
                    this.secureRandomSpi = (SecureRandomSpi)Class.forName(string).newInstance();
                    this.provider = providerArray[n];
                    return;
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {}
            }
            ++n;
        }
        this.secureRandomSpi = new Sha160RandomSpi();
    }

    public SecureRandom(byte[] byArray) {
        this();
        this.setSeed(byArray);
    }

    protected SecureRandom(SecureRandomSpi secureRandomSpi, Provider provider) {
        this.this();
        this.secureRandomSpi = secureRandomSpi;
        this.provider = provider;
    }
}

