/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.sig;

import gnu.javax.crypto.jce.GnuCrypto;
import gnu.javax.crypto.key.dh.RFC2631;
import java.math.BigInteger;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.DHGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DHParametersGenerator
extends AlgorithmParameterGeneratorSpi {
    private static final Provider GNU_CRYPTO = new GnuCrypto();
    private int modulusSize;
    private int exponentSize;
    private SecureRandom rnd;
    private RFC2631 rfc2631;

    protected void engineInit(int n, SecureRandom secureRandom) {
        if (n % 256 != 0 || n < 512) {
            throw new InvalidParameterException("Prime modulus (p) size (in bits) MUST be a multiple of 256, and greater than or equal to 1024");
        }
        this.modulusSize = n;
        this.rnd = secureRandom;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof DHParameterSpec) {
            DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmParameterSpec;
            BigInteger bigInteger = dHParameterSpec.getP();
            int n = bigInteger.bitLength();
            this.engineInit(n, secureRandom);
        } else if (algorithmParameterSpec instanceof DHGenParameterSpec) {
            DHGenParameterSpec dHGenParameterSpec = (DHGenParameterSpec)algorithmParameterSpec;
            int n = dHGenParameterSpec.getPrimeSize();
            this.engineInit(n, secureRandom);
            this.exponentSize = dHGenParameterSpec.getExponentSize();
            if (this.exponentSize % 8 != 0 || this.exponentSize < 160) {
                throw new InvalidParameterException("Random exponent size (in bits) MUST be a multiple of 8, and greater than or equal to 160");
            }
            if (this.exponentSize > this.modulusSize) {
                throw new InvalidParameterException("Random exponent size (in bits) MUST be less than that of the public prime modulus (p)");
            }
        }
        throw new InvalidAlgorithmParameterException("Wrong AlgorithmParameterSpec type: " + algorithmParameterSpec.getClass().getName());
    }

    protected AlgorithmParameters engineGenerateParameters() {
        if (this.modulusSize < 1) {
            this.modulusSize = 512;
        }
        if (this.exponentSize < 1) {
            this.exponentSize = 160;
        }
        this.rfc2631 = new RFC2631(this.exponentSize, this.modulusSize, this.rnd);
        BigInteger[] bigIntegerArray = this.rfc2631.generateParameters();
        BigInteger bigInteger = bigIntegerArray[3];
        BigInteger bigInteger2 = bigIntegerArray[5];
        int n = bigIntegerArray[2].bitLength();
        DHParameterSpec dHParameterSpec = new DHParameterSpec(bigInteger, bigInteger2, n);
        AlgorithmParameters algorithmParameters = null;
        try {
            algorithmParameters = AlgorithmParameters.getInstance("dh", GNU_CRYPTO);
            algorithmParameters.init(dHParameterSpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {}
        return algorithmParameters;
    }

    private final /* synthetic */ void this() {
        this.modulusSize = -1;
        this.exponentSize = -1;
    }

    public DHParametersGenerator() {
        this.this();
    }
}

