/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.java.rmi.server.RMIHashes;
import gnu.java.rmi.server.RMIObjectInputStream;
import gnu.java.rmi.server.RMIVoidValue;
import gnu.java.rmi.server.UnicastConnection;
import gnu.java.rmi.server.UnicastConnectionManager;
import gnu.java.rmi.server.UnicastRef;
import gnu.java.rmi.server.UnicastRemoteCall;
import gnu.java.rmi.server.UnicastRemoteStub;
import gnu.java.rmi.server.UnicastServer;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ObjID;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteObjectInvocationHandler;
import java.rmi.server.RemoteRef;
import java.rmi.server.RemoteServer;
import java.rmi.server.RemoteStub;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.Skeleton;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class UnicastServerRef
extends UnicastRef {
    private static final long serialVersionUID = -5585608108300801246L;
    private static final Class[] stubprototype;
    Remote myself;
    private Skeleton skel;
    private Remote stub;
    private Hashtable methods;
    static /* synthetic */ Class class$java$rmi$server$RemoteRef;
    static /* synthetic */ Class class$java$rmi$server$UnicastRemoteObject;
    static /* synthetic */ Class class$java$rmi$Remote;

    public Remote exportObject(Remote remote) throws RemoteException {
        if (this.myself == null) {
            this.myself = remote;
            this.manager.serverobj = remote;
            ClassLoader classLoader = remote.getClass().getClassLoader();
            String string = classLoader == null ? "false" : System.getProperty("java.rmi.server.ignoreStubClasses", "false");
            if (!string.equals("true")) {
                Class clazz = remote.getClass();
                Class clazz2 = this.findStubSkelClass(clazz);
                if (clazz2 != null) {
                    this.stub = (RemoteStub)this.getHelperClass(clazz2, "_Stub");
                    this.skel = (Skeleton)this.getHelperClass(clazz2, "_Skel");
                }
            }
            if (this.stub == null) {
                this.stub = this.createProxyStub(remote.getClass(), this);
            }
            this.buildMethodHash(remote.getClass(), true);
            UnicastServer.exportObject(this);
        }
        return this.stub;
    }

    public Remote getStub() {
        return this.stub;
    }

    public boolean unexportObject(Remote remote, boolean bl) {
        this.buildMethodHash(remote.getClass(), false);
        return UnicastServer.unexportObject(this, bl);
    }

    private final Class findStubSkelClass(Class clazz) {
        Object object = clazz;
        while (true) {
            Object object2;
            try {
                String string = ((Class)object).getName() + "_Stub";
                object2 = ((Class)object).getClassLoader();
                Class clazz2 = object2 == null ? Class.forName(string) : ((ClassLoader)object2).loadClass(string);
                return object;
            }
            catch (ClassNotFoundException classNotFoundException) {
                block8: {
                    block7: {
                        object2 = ((Class)object).getSuperclass();
                        if (object2 == null) break block7;
                        Class clazz3 = class$java$rmi$server$UnicastRemoteObject;
                        if (clazz3 == null) {
                            clazz3 = UnicastServerRef.class("[Ljava.rmi.server.UnicastRemoteObject;", false);
                        }
                        if (object2 != clazz3) break block8;
                    }
                    return null;
                }
                object = object2;
                continue;
            }
            break;
        }
    }

    private final Object getHelperClass(Class clazz, String string) {
        try {
            Class clazz2;
            String string2 = clazz.getName();
            ClassLoader classLoader = clazz.getClassLoader();
            Class clazz3 = clazz2 = classLoader == null ? Class.forName(string2 + string) : classLoader.loadClass(string2 + string);
            if (string.equals("_Stub")) {
                try {
                    Constructor constructor = clazz2.getConstructor(stubprototype);
                    return constructor.newInstance(new Object[]{this});
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
                RemoteStub remoteStub = (RemoteStub)clazz2.newInstance();
                UnicastRemoteStub.setStubRef(remoteStub, this);
                return remoteStub;
            }
            return clazz2.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        return null;
    }

    public String getClientHost() throws ServerNotActiveException {
        return RemoteServer.getClientHost();
    }

    private final void buildMethodHash(Class clazz, boolean bl) {
        Method[] methodArray = clazz.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            if (!methodArray[n].getDeclaringClass().getName().startsWith("java.")) {
                long l = RMIHashes.getMethodHash(methodArray[n]);
                if (bl) {
                    this.methods.put(new Long(l), methodArray[n]);
                } else {
                    this.methods.remove(new Long(l));
                }
            }
            ++n;
        }
    }

    Class getMethodReturnType(int n, long l) throws Exception {
        if (n == -1) {
            Method method = (Method)this.methods.get(new Long(l));
            return method.getReturnType();
        }
        return null;
    }

    public Object incomingMessageCall(UnicastConnection unicastConnection, int n, long l) throws Exception {
        if (n == -1) {
            Method method = (Method)this.methods.get(new Long(l));
            if (method == null) {
                throw new NoSuchMethodException();
            }
            ObjectInputStream objectInputStream = unicastConnection.getObjectInputStream();
            int n2 = method.getParameterTypes().length;
            Object[] objectArray = new Object[n2];
            int n3 = 0;
            while (n3 < n2) {
                try {
                    objectArray[n3] = ((RMIObjectInputStream)objectInputStream).readValue(method.getParameterTypes()[n3]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw exception;
                }
                ++n3;
            }
            Object object = null;
            try {
                object = method.invoke(this.myself, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new Error("The remote method threw a java.lang.Throwable that is neither java.lang.Exception nor java.lang.Error.", invocationTargetException);
            }
            return object;
        }
        if (this.skel == null) {
            throw new NoSuchMethodException();
        }
        UnicastRemoteCall unicastRemoteCall = new UnicastRemoteCall(unicastConnection);
        this.skel.dispatch(this.myself, unicastRemoteCall, n, l);
        if (!unicastRemoteCall.isReturnValue()) {
            return RMIVoidValue.INSTANCE;
        }
        return unicastRemoteCall.returnValue();
    }

    Remote createProxyStub(Class clazz, RemoteRef remoteRef) {
        Class[] classArray;
        HashSet hashSet = new HashSet();
        Class clazz2 = clazz;
        while (clazz2 != null) {
            classArray = clazz2.getInterfaces();
            int n = 0;
            while (n < classArray.length) {
                Class clazz3 = class$java$rmi$Remote;
                if (clazz3 == null) {
                    clazz3 = UnicastServerRef.class("[Ljava.rmi.Remote;", false);
                }
                if (clazz3.isAssignableFrom(classArray[n])) {
                    hashSet.add(classArray[n]);
                }
                ++n;
            }
            clazz2 = clazz2.getSuperclass();
        }
        classArray = new Class[hashSet.size()];
        Iterator iterator = hashSet.iterator();
        int n = 0;
        while (n < classArray.length) {
            classArray[n] = (Class)iterator.next();
            ++n;
        }
        RemoteObjectInvocationHandler remoteObjectInvocationHandler = new RemoteObjectInvocationHandler(remoteRef);
        Object object = Proxy.newProxyInstance(clazz.getClassLoader(), classArray, remoteObjectInvocationHandler);
        return (Remote)object;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.methods = new Hashtable();
    }

    UnicastServerRef() {
        this.this();
    }

    public UnicastServerRef(ObjID objID, int n, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
        super(objID);
        this.this();
        this.manager = UnicastConnectionManager.getInstance(n, rMIServerSocketFactory);
    }

    static {
        Class[] classArray = new Class[1];
        Class clazz = class$java$rmi$server$RemoteRef;
        if (clazz == null) {
            clazz = class$java$rmi$server$RemoteRef = UnicastServerRef.class("[Ljava.rmi.server.RemoteRef;", false);
        }
        classArray[0] = clazz;
        stubprototype = classArray;
    }
}

