/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import gnu.java.nio.charset.ISO_8859_1;
import gnu.java.nio.charset.US_ASCII;
import gnu.java.nio.charset.UTF_16;
import gnu.java.nio.charset.UTF_16BE;
import gnu.java.nio.charset.UTF_16LE;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

final class UTF_8
extends Charset {
    public final boolean contains(Charset charset) {
        boolean bl = false;
        if (charset instanceof US_ASCII || charset instanceof ISO_8859_1 || charset instanceof UTF_8 || charset instanceof UTF_16BE || charset instanceof UTF_16LE || charset instanceof UTF_16) {
            bl = true;
        }
        return bl;
    }

    public final CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public final CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    UTF_8() {
        super("UTF-8", new String[]{"ibm-1208", "ibm-1209", "ibm-5304", "ibm-5305", "windows-65001", "cp1208", "UTF8"});
    }

    private static final class Decoder
    extends CharsetDecoder {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected final CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            CoderResult coderResult;
            int n = byteBuffer.position();
            try {
                while (byteBuffer.hasRemaining()) {
                    byte by = byteBuffer.get();
                    int n2 = (by & 0xFF) >> 4 & 0xF;
                    switch (n2) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            if (charBuffer.remaining() < 1) {
                                CoderResult coderResult2 = CoderResult.OVERFLOW;
                                Object var5_31 = null;
                                byteBuffer.position(n);
                                return coderResult2;
                            }
                            charBuffer.put((char)by);
                            ++n;
                            break;
                        }
                        case 12: 
                        case 13: {
                            if (byteBuffer.remaining() < 1) {
                                CoderResult coderResult3 = CoderResult.UNDERFLOW;
                                Object var5_32 = null;
                                byteBuffer.position(n);
                                return coderResult3;
                            }
                            if (charBuffer.remaining() < 1) {
                                CoderResult coderResult4 = CoderResult.OVERFLOW;
                                Object var5_33 = null;
                                byteBuffer.position(n);
                                return coderResult4;
                            }
                            byte by2 = byteBuffer.get();
                            if (!Decoder.isContinuation(by2)) {
                                CoderResult coderResult5 = CoderResult.malformedForLength(1);
                                Object var5_34 = null;
                                byteBuffer.position(n);
                                return coderResult5;
                            }
                            char c = (char)((by & 0x1F) << 6 | by2 & 0x3F);
                            if (c <= '\u007f') {
                                CoderResult coderResult6 = CoderResult.malformedForLength(2);
                                Object var5_35 = null;
                                byteBuffer.position(n);
                                return coderResult6;
                            }
                            charBuffer.put(c);
                            n += 2;
                            break;
                        }
                        case 14: {
                            if (byteBuffer.remaining() < 2) {
                                CoderResult coderResult7 = CoderResult.UNDERFLOW;
                                Object var5_36 = null;
                                byteBuffer.position(n);
                                return coderResult7;
                            }
                            if (charBuffer.remaining() < 1) {
                                CoderResult coderResult8 = CoderResult.OVERFLOW;
                                Object var5_37 = null;
                                byteBuffer.position(n);
                                return coderResult8;
                            }
                            byte by2 = byteBuffer.get();
                            if (!Decoder.isContinuation(by2)) {
                                CoderResult coderResult9 = CoderResult.malformedForLength(1);
                                Object var5_38 = null;
                                byteBuffer.position(n);
                                return coderResult9;
                            }
                            byte by3 = byteBuffer.get();
                            if (!Decoder.isContinuation(by3)) {
                                CoderResult coderResult10 = CoderResult.malformedForLength(1);
                                Object var5_39 = null;
                                byteBuffer.position(n);
                                return coderResult10;
                            }
                            char c = (char)((by & 0xF) << 12 | (by2 & 0x3F) << 6 | by3 & 0x3F);
                            if (c <= '\u07ff') {
                                CoderResult coderResult11 = CoderResult.malformedForLength(3);
                                Object var5_40 = null;
                                byteBuffer.position(n);
                                return coderResult11;
                            }
                            charBuffer.put(c);
                            n += 3;
                            break;
                        }
                        case 15: {
                            if (byteBuffer.remaining() < 3) {
                                CoderResult coderResult12 = CoderResult.UNDERFLOW;
                                Object var5_41 = null;
                                byteBuffer.position(n);
                                return coderResult12;
                            }
                            if ((by & 0xF) > 4) {
                                CoderResult coderResult13 = CoderResult.malformedForLength(4);
                                Object var5_42 = null;
                                byteBuffer.position(n);
                                return coderResult13;
                            }
                            if (charBuffer.remaining() < 2) {
                                CoderResult coderResult14 = CoderResult.OVERFLOW;
                                Object var5_43 = null;
                                byteBuffer.position(n);
                                return coderResult14;
                            }
                            byte by2 = byteBuffer.get();
                            if (!Decoder.isContinuation(by2)) {
                                CoderResult coderResult15 = CoderResult.malformedForLength(3);
                                Object var5_44 = null;
                                byteBuffer.position(n);
                                return coderResult15;
                            }
                            byte by3 = byteBuffer.get();
                            if (!Decoder.isContinuation(by3)) {
                                CoderResult coderResult16 = CoderResult.malformedForLength(2);
                                Object var5_45 = null;
                                byteBuffer.position(n);
                                return coderResult16;
                            }
                            byte by4 = byteBuffer.get();
                            if (!Decoder.isContinuation(by4)) {
                                CoderResult coderResult17 = CoderResult.malformedForLength(1);
                                Object var5_46 = null;
                                byteBuffer.position(n);
                                return coderResult17;
                            }
                            int n3 = ((by & 3) << 18 | (by2 & 0x3F) << 12 | (by3 & 0x3F) << 6 | by4 & 0x3F) - 65536;
                            char c = (char)(0xD800 | (n3 & 0xFFC00) >> 10);
                            char c2 = (char)(0xDC00 | n3 & 0x3FF);
                            charBuffer.put(c);
                            charBuffer.put(c2);
                            n += 4;
                            break;
                        }
                        default: {
                            CoderResult coderResult18 = CoderResult.malformedForLength(1);
                            Object var5_47 = null;
                            byteBuffer.position(n);
                            return coderResult18;
                        }
                    }
                }
                coderResult = CoderResult.UNDERFLOW;
                Object var5_48 = null;
            }
            catch (Throwable throwable) {
                Object var5_49 = null;
                byteBuffer.position(n);
                throw throwable;
            }
            byteBuffer.position(n);
            return coderResult;
        }

        private static final boolean isContinuation(byte by) {
            boolean bl = false;
            if ((by & 0xC0) == 128) {
                bl = true;
            }
            return bl;
        }

        Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }
    }

    private static final class Encoder
    extends CharsetEncoder {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected final CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            CoderResult coderResult;
            int n;
            block17: {
                CoderResult coderResult2;
                block24: {
                    CoderResult coderResult3;
                    block23: {
                        CoderResult coderResult4;
                        block22: {
                            CoderResult coderResult5;
                            block21: {
                                CoderResult coderResult6;
                                block20: {
                                    CoderResult coderResult7;
                                    block19: {
                                        CoderResult coderResult8;
                                        n = charBuffer.position();
                                        try {
                                            while (true) {
                                                if (!charBuffer.hasRemaining()) {
                                                    coderResult = CoderResult.UNDERFLOW;
                                                    break block17;
                                                }
                                                int n2 = byteBuffer.remaining();
                                                char c = charBuffer.get();
                                                if (c <= '\u007f') {
                                                    if (n2 < 1) {
                                                        coderResult8 = CoderResult.OVERFLOW;
                                                        Object var5_16 = null;
                                                        break;
                                                    } else {
                                                        byteBuffer.put((byte)c);
                                                        ++n;
                                                        continue;
                                                    }
                                                }
                                                if (c <= '\u07ff') {
                                                    if (n2 < 2) {
                                                        coderResult7 = CoderResult.OVERFLOW;
                                                        break block19;
                                                    } else {
                                                        byteBuffer.put((byte)(0xC0 | c >> 6));
                                                        byteBuffer.put((byte)(0x80 | c & 0x3F));
                                                        ++n;
                                                        continue;
                                                    }
                                                }
                                                if ('\ud800' <= c && c <= '\udfff') {
                                                    if (n2 < 4) {
                                                        coderResult6 = CoderResult.OVERFLOW;
                                                        break block20;
                                                    }
                                                    if (c > '\udbff') {
                                                        coderResult5 = CoderResult.malformedForLength(1);
                                                        break block21;
                                                    }
                                                    if (!charBuffer.hasRemaining()) {
                                                        coderResult4 = CoderResult.UNDERFLOW;
                                                        break block22;
                                                    }
                                                    char c2 = charBuffer.get();
                                                    if (c2 < '\udc00' || c2 > '\udfff') {
                                                        coderResult3 = CoderResult.malformedForLength(1);
                                                        break block23;
                                                    } else {
                                                        int n3 = ((c & 0x3FF) << 10 | c2 & 0x3FF) + 65536;
                                                        byteBuffer.put((byte)(0xF0 | n3 >> 18 & 7));
                                                        byteBuffer.put((byte)(0x80 | n3 >> 12 & 0x3F));
                                                        byteBuffer.put((byte)(0x80 | n3 >> 6 & 0x3F));
                                                        byteBuffer.put((byte)(0x80 | n3 & 0x3F));
                                                        n += 2;
                                                        continue;
                                                    }
                                                }
                                                if (n2 < 3) {
                                                    coderResult2 = CoderResult.OVERFLOW;
                                                    break block24;
                                                }
                                                byteBuffer.put((byte)(0xE0 | c >> 12));
                                                byteBuffer.put((byte)(0x80 | c >> 6 & 0x3F));
                                                byteBuffer.put((byte)(0x80 | c & 0x3F));
                                                ++n;
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            Object var5_24 = null;
                                            charBuffer.position(n);
                                            throw throwable;
                                        }
                                        charBuffer.position(n);
                                        return coderResult8;
                                    }
                                    Object var5_17 = null;
                                    charBuffer.position(n);
                                    return coderResult7;
                                }
                                Object var5_18 = null;
                                charBuffer.position(n);
                                return coderResult6;
                            }
                            Object var5_19 = null;
                            charBuffer.position(n);
                            return coderResult5;
                        }
                        Object var5_20 = null;
                        charBuffer.position(n);
                        return coderResult4;
                    }
                    Object var5_21 = null;
                    charBuffer.position(n);
                    return coderResult3;
                }
                Object var5_22 = null;
                charBuffer.position(n);
                return coderResult2;
            }
            Object var5_23 = null;
            charBuffer.position(n);
            return coderResult;
        }

        Encoder(Charset charset) {
            super(charset, 1.1f, 4);
        }
    }
}

