/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.swing;

import gnu.java.awt.peer.swing.SwingComponent;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.PaintEvent;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;

public class SwingComponentPeer
implements ComponentPeer {
    protected Component awtComponent;
    protected SwingComponent swingComponent;

    protected void init(Component component, SwingComponent swingComponent) {
        this.awtComponent = component;
        this.swingComponent = swingComponent;
    }

    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return Toolkit.getDefaultToolkit().checkImage(image, n, n2, imageObserver);
    }

    public Image createImage(ImageProducer imageProducer) {
        Image image = Toolkit.getDefaultToolkit().createImage(imageProducer);
        return image;
    }

    public Image createImage(int n, int n2) {
        Container container = this.awtComponent.getParent();
        ComponentPeer componentPeer = container.getPeer();
        return componentPeer.createImage(n, n2);
    }

    public void disable() {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setEnabled(false);
        }
    }

    public void dispose() {
        this.awtComponent = null;
        this.swingComponent = null;
    }

    public void enable() {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setEnabled(true);
        }
    }

    public ColorModel getColorModel() {
        return null;
    }

    public FontMetrics getFontMetrics(Font font) {
        Container container = this.awtComponent.getParent();
        ComponentPeer componentPeer = container.getPeer();
        return componentPeer.getFontMetrics(font);
    }

    public Graphics getGraphics() {
        Container container = this.awtComponent.getParent();
        ComponentPeer componentPeer = container.getPeer();
        Graphics graphics = componentPeer.getGraphics();
        graphics.translate(this.awtComponent.getX(), this.awtComponent.getY());
        graphics.setClip(0, 0, this.awtComponent.getWidth(), this.awtComponent.getHeight());
        return graphics;
    }

    public Point getLocationOnScreen() {
        Container container = this.awtComponent.getParent();
        ComponentPeer componentPeer = container.getPeer();
        Point point = componentPeer.getLocationOnScreen();
        point.x += this.awtComponent.getX();
        point.y += this.awtComponent.getY();
        return point;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.swingComponent != null ? this.swingComponent.getJComponent().getMinimumSize() : new Dimension(0, 0);
        return dimension;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.swingComponent != null ? this.swingComponent.getJComponent().getPreferredSize() : new Dimension(0, 0);
        return dimension;
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    public void handleEvent(AWTEvent aWTEvent) {
        switch (aWTEvent.getID()) {
            case 800: 
            case 801: {
                Graphics graphics = this.getGraphics();
                Rectangle rectangle = ((PaintEvent)aWTEvent).getUpdateRect();
                graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                if (aWTEvent.getID() == 801) {
                    this.awtComponent.update(graphics);
                } else {
                    this.awtComponent.paint(graphics);
                }
                this.peerPaint(graphics);
                graphics.dispose();
                break;
            }
            case 500: 
            case 501: 
            case 502: 
            case 504: 
            case 505: {
                this.handleMouseEvent((MouseEvent)aWTEvent);
                break;
            }
            case 503: 
            case 506: {
                this.handleMouseMotionEvent((MouseEvent)aWTEvent);
                break;
            }
            case 400: 
            case 401: 
            case 402: {
                this.handleKeyEvent((KeyEvent)aWTEvent);
                break;
            }
        }
    }

    public void hide() {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setVisible(false);
        }
    }

    public boolean isFocusTraversable() {
        boolean bl = false;
        if (this.swingComponent != null) {
            bl = this.swingComponent.getJComponent().isFocusable();
        }
        return bl;
    }

    public boolean isFocusable() {
        boolean bl = false;
        if (this.swingComponent != null) {
            bl = this.swingComponent.getJComponent().isFocusable();
        }
        return bl;
    }

    public Dimension minimumSize() {
        Dimension dimension = this.swingComponent != null ? this.swingComponent.getJComponent().getMinimumSize() : new Dimension(0, 0);
        return dimension;
    }

    public Dimension preferredSize() {
        Dimension dimension = this.swingComponent != null ? this.swingComponent.getJComponent().getPreferredSize() : new Dimension(0, 0);
        return dimension;
    }

    public void paint(Graphics graphics) {
    }

    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        Container container = this.awtComponent.getParent();
        ComponentPeer componentPeer = container.getPeer();
        return componentPeer.prepareImage(image, n, n2, imageObserver);
    }

    public void print(Graphics graphics) {
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().repaint(l, n, n2, n3, n4);
        } else {
            PaintEvent paintEvent = new PaintEvent(this.awtComponent, 801, new Rectangle(n, n2, n3, n4));
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(paintEvent);
        }
    }

    public void requestFocus() {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().requestFocus();
        }
    }

    public boolean requestFocus(Component component, boolean bl, boolean bl2, long l) {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().requestFocus();
        }
        boolean bl3 = false;
        if (this.swingComponent != null) {
            bl3 = true;
        }
        return bl3;
    }

    public void reshape(int n, int n2, int n3, int n4) {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setBounds(n, n2, n3, n4);
        }
    }

    public void setBackground(Color color) {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setBackground(color);
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setBounds(n, n2, n3, n4);
        }
    }

    public void setCursor(Cursor cursor) {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setCursor(cursor);
        }
    }

    public void setEnabled(boolean bl) {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setEnabled(bl);
        }
    }

    public void setFont(Font font) {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setFont(font);
        }
    }

    public void setForeground(Color color) {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setForeground(color);
        }
    }

    public void setVisible(boolean bl) {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setVisible(bl);
        }
    }

    public void show() {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setVisible(true);
        }
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        Container container = this.awtComponent.getParent();
        ComponentPeer componentPeer = container.getPeer();
        return componentPeer.getGraphicsConfiguration();
    }

    public void setEventMask(long l) {
    }

    public boolean isObscured() {
        return false;
    }

    public boolean canDetermineObscurity() {
        return false;
    }

    public void coalescePaintEvent(PaintEvent paintEvent) {
    }

    public void updateCursorImmediately() {
    }

    public boolean handlesWheelScrolling() {
        return false;
    }

    public VolatileImage createVolatileImage(int n, int n2) {
        Container container = this.awtComponent.getParent();
        ComponentPeer componentPeer = container.getPeer();
        return componentPeer.createVolatileImage(n, n2);
    }

    public void createBuffers(int n, BufferCapabilities bufferCapabilities) throws AWTException {
        Container container = this.awtComponent.getParent();
        ComponentPeer componentPeer = container.getPeer();
        componentPeer.createBuffers(n, bufferCapabilities);
    }

    public Image getBackBuffer() {
        Container container = this.awtComponent.getParent();
        ComponentPeer componentPeer = container.getPeer();
        return componentPeer.getBackBuffer();
    }

    public void flip(BufferCapabilities.FlipContents flipContents) {
        Container container = this.awtComponent.getParent();
        ComponentPeer componentPeer = container.getPeer();
        componentPeer.flip(flipContents);
    }

    public void destroyBuffers() {
        Container container = this.awtComponent.getParent();
        ComponentPeer componentPeer = container.getPeer();
        componentPeer.destroyBuffers();
    }

    public Rectangle getBounds() {
        Rectangle rectangle = this.swingComponent != null ? this.swingComponent.getJComponent().getBounds() : new Rectangle();
        return rectangle;
    }

    public void reparent(ContainerPeer containerPeer) {
    }

    public void setBounds(int n, int n2, int n3, int n4, int n5) {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setBounds(n, n2, n3, n4);
        }
    }

    public boolean isReparentSupported() {
        return true;
    }

    public void layout() {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().doLayout();
        }
    }

    protected void peerPaint(Graphics graphics) {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().paint(graphics);
        }
    }

    protected void handleMouseEvent(MouseEvent mouseEvent) {
        if (this.swingComponent != null) {
            this.swingComponent.handleMouseEvent(mouseEvent);
        }
    }

    protected void handleMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.swingComponent != null) {
            this.swingComponent.handleMouseMotionEvent(mouseEvent);
        }
    }

    protected void handleKeyEvent(KeyEvent keyEvent) {
        if (this.swingComponent != null) {
            this.swingComponent.handleKeyEvent(keyEvent);
        }
    }

    public Component getComponent() {
        return this.awtComponent;
    }

    protected SwingComponentPeer() {
    }
}

