/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.resources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.IStatusListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.IUpdateMessageListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.StatusListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.UpdateListener;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.connection.CVSServerException;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderTree;
import org.eclipse.team.internal.ccvs.core.resources.RemoteResource;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Util;

public class RemoteFolderTreeBuilder {
    private static final int MAX_REVISION_FETCHES_PER_CONNECTION = 1024;
    private Map fileDeltas;
    private List changedFiles;
    private Map remoteFolderTable;
    private ICVSFolder root;
    private RemoteFolderTree remoteRoot;
    private CVSRepositoryLocation repository;
    private CVSTag tag;
    private Command.LocalOption[] updateLocalOptions;
    private boolean rootDoesNotExist = false;
    private static String UNKNOWN = "";
    private static String DELETED = "DELETED";
    private static String ADDED = "ADDED";
    private static String FOLDER = "FOLDER";
    private static Map EMPTY_MAP = new HashMap();
    private boolean newFolderExist = false;

    RemoteFolderTreeBuilder(CVSRepositoryLocation repository, ICVSFolder root, CVSTag tag) {
        this.repository = repository;
        this.root = root;
        this.tag = tag;
        this.fileDeltas = new HashMap();
        this.changedFiles = new ArrayList();
        this.remoteFolderTable = new HashMap();
        ArrayList<Command.LocalOption> localOptions = new ArrayList<Command.LocalOption>();
        if (tag != null) {
            if (tag.getType() == 0) {
                localOptions.add(Update.CLEAR_STICKY);
            } else {
                localOptions.add(Update.makeTagOption(tag));
            }
        }
        this.updateLocalOptions = localOptions.toArray(new Command.LocalOption[localOptions.size()]);
    }

    private Command.LocalOption[] getOptionsWithoutTag() {
        ArrayList<Command.LocalOption> localOptions = new ArrayList<Command.LocalOption>();
        localOptions.add(Update.RETRIEVE_ABSENT_DIRECTORIES);
        return localOptions.toArray(new Command.LocalOption[localOptions.size()]);
    }

    public static RemoteFolder buildBaseTree(CVSRepositoryLocation repository, ICVSFolder root, CVSTag tag, IProgressMonitor progress) throws CVSException {
        try {
            RemoteFolderTreeBuilder builder = new RemoteFolderTreeBuilder(repository, root, tag);
            progress.beginTask(null, 100);
            IProgressMonitor subProgress = Policy.infiniteSubMonitorFor(progress, 100);
            subProgress.beginTask(null, 512);
            subProgress.subTask(NLS.bind((String)CVSMessages.RemoteFolderTreeBuilder_buildingBase, (Object[])new String[]{root.getName()}));
            RemoteFolder remoteFolder = builder.buildBaseTree(null, root, subProgress);
            return remoteFolder;
        }
        finally {
            progress.done();
        }
    }

    public static RemoteFolderTree buildRemoteTree(CVSRepositoryLocation repository, IContainer root, CVSTag tag, IProgressMonitor monitor) throws CVSException {
        return RemoteFolderTreeBuilder.buildRemoteTree(repository, CVSWorkspaceRoot.getCVSFolderFor(root), tag, monitor);
    }

    public static RemoteFolderTree buildRemoteTree(CVSRepositoryLocation repository, ICVSFolder root, CVSTag tag, IProgressMonitor monitor) throws CVSException {
        RemoteFolderTreeBuilder builder = new RemoteFolderTreeBuilder(repository, root, tag);
        return builder.buildTree(new ICVSResource[]{root}, monitor);
    }

    public static RemoteFile buildRemoteTree(CVSRepositoryLocation repository, ICVSFile file, CVSTag tag, IProgressMonitor monitor) throws CVSException {
        RemoteFolderTreeBuilder builder = new RemoteFolderTreeBuilder(repository, file.getParent(), tag);
        return builder.buildTree(file, monitor);
    }

    RemoteFolderTree buildTree(ICVSResource[] resources, IProgressMonitor monitor) throws CVSException {
        Command.QuietOption quietness = CVSProviderPlugin.getPlugin().getQuietness();
        try {
            CVSProviderPlugin.getPlugin().setQuietness(Command.VERBOSE);
            monitor.beginTask(null, 100);
            if (!this.fetchDelta(resources, Policy.subMonitorFor(monitor, 75))) {
                return null;
            }
            this.fetchNewDirectories(Policy.subMonitorFor(monitor, 10));
            this.fetchFileRevisions(Policy.subMonitorFor(monitor, 15));
            RemoteFolderTree remoteFolderTree = this.remoteRoot;
            return remoteFolderTree;
        }
        finally {
            CVSProviderPlugin.getPlugin().setQuietness(quietness);
            monitor.done();
        }
    }

    private boolean fetchDelta(ICVSResource[] resources, IProgressMonitor monitor) throws CVSException {
        ArrayList<String> arguments = new ArrayList<String>();
        int i = 0;
        while (i < resources.length) {
            ICVSResource resource = resources[i];
            arguments.add(resource.getRelativePath(this.root));
            ++i;
        }
        monitor.beginTask(null, 100);
        Policy.checkCanceled(monitor);
        Session session = new Session(this.repository, this.root, false);
        session.open(Policy.subMonitorFor(monitor, 10), false);
        try {
            Policy.checkCanceled(monitor);
            this.fetchDelta(session, arguments.toArray(new String[arguments.size()]), Policy.subMonitorFor(monitor, 90));
            if (this.rootDoesNotExist) {
                if (this.root.isCVSFolder() && !this.root.isManaged()) {
                    throw new CVSException(NLS.bind((String)CVSMessages.RemoteFolderTreeBuild_folderDeletedFromServer, (Object[])new String[]{this.root.getFolderSyncInfo().getRepository()}));
                }
                return false;
            }
        }
        finally {
            session.close();
            monitor.done();
        }
        return true;
    }

    private void fetchNewDirectories(IProgressMonitor monitor) throws CVSException {
        Session session;
        monitor.beginTask(null, 100);
        FolderSyncInfo folderSyncInfo = this.root.getFolderSyncInfo();
        if (folderSyncInfo == null) {
            if (this.root.exists()) {
                IResource resource = this.root.getIResource();
                String path = resource == null ? this.root.getName() : resource.getFullPath().toString();
                throw new CVSException(NLS.bind((String)CVSMessages.RemoteFolderTreeBuilder_0, (Object[])new String[]{path}));
            }
            return;
        }
        this.remoteRoot = new RemoteFolderTree(null, this.root.getName(), this.repository, folderSyncInfo.getRepository(), this.tagForRemoteFolder(this.root, this.tag));
        if (this.newFolderExist) {
            session = new Session(this.repository, this.remoteRoot, false);
            session.open(Policy.subMonitorFor(monitor, 10), false);
        } else {
            session = null;
        }
        try {
            IProgressMonitor subProgress = Policy.infiniteSubMonitorFor(monitor, 90);
            subProgress.beginTask(null, 512);
            this.buildRemoteTree(session, this.root, this.remoteRoot, "", subProgress);
        }
        finally {
            if (session != null) {
                session.close();
            }
            monitor.done();
        }
    }

    private void fetchFileRevisions(IProgressMonitor monitor) throws CVSException {
        if (this.remoteRoot != null && !this.changedFiles.isEmpty()) {
            String[] allChangedFiles = this.changedFiles.toArray(new String[this.changedFiles.size()]);
            int iterations = allChangedFiles.length / 1024 + (allChangedFiles.length % 1024 == 0 ? 0 : 1);
            int i = 0;
            while (i < iterations) {
                int length = Math.min(1024, allChangedFiles.length - 1024 * i);
                String[] buffer = new String[length];
                System.arraycopy(allChangedFiles, i * 1024, buffer, 0, length);
                Session session = new Session(this.repository, this.remoteRoot, false);
                session.open(Policy.subMonitorFor(monitor, 1), false);
                try {
                    this.fetchFileRevisions(session, buffer, Policy.subMonitorFor(monitor, 2));
                }
                finally {
                    session.close();
                }
                ++i;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    RemoteFile buildTree(ICVSFile file, IProgressMonitor monitor) throws CVSException {
        RemoteFile remoteFile;
        Session session;
        Command.QuietOption quietness;
        block20: {
            DeltaNode d;
            block21: {
                block19: {
                    Map deltas;
                    block18: {
                        quietness = CVSProviderPlugin.getPlugin().getQuietness();
                        try {
                            CVSProviderPlugin.getPlugin().setQuietness(Command.VERBOSE);
                            monitor.beginTask(null, 100);
                            Policy.checkCanceled(monitor);
                            session = new Session(this.repository, this.root, false);
                            session.open(Policy.subMonitorFor(monitor, 10), false);
                            try {
                                Policy.checkCanceled(monitor);
                                this.fetchDelta(session, new String[]{file.getName()}, Policy.subMonitorFor(monitor, 50));
                                if (this.rootDoesNotExist) {
                                }
                            }
                            finally {
                                session.close();
                            }
                        }
                        catch (Throwable throwable) {
                            CVSProviderPlugin.getPlugin().setQuietness(quietness);
                            monitor.done();
                            throw throwable;
                        }
                        this.remoteRoot = new RemoteFolderTree(null, this.root.getName(), this.repository, this.root.getFolderSyncInfo().getRepository(), this.tagForRemoteFolder(this.root, this.tag));
                        deltas = (Map)this.fileDeltas.get("");
                        if (deltas != null && !deltas.isEmpty()) break block18;
                        byte[] syncBytes = file.getSyncBytes();
                        if (syncBytes == null || ResourceSyncInfo.isAddition(syncBytes)) break block19;
                        remoteFile = new RemoteFile((RemoteFolder)this.remoteRoot, syncBytes);
                        break block20;
                    }
                    d = (DeltaNode)deltas.get(file.getName());
                    if (d.getRevision() != DELETED) break block21;
                }
                CVSProviderPlugin.getPlugin().setQuietness(quietness);
                monitor.done();
                return null;
            }
            remoteFile = new RemoteFile(this.remoteRoot, d.getSyncState(), file.getName(), null, this.getKeywordMode(file), this.tagForRemoteFolder(this.remoteRoot, this.tag));
        }
        this.remoteRoot.setChildren(new ICVSRemoteResource[]{remoteFile});
        if (!this.changedFiles.isEmpty()) {
            this.recordRemoteFolder(this.remoteRoot);
            session = new Session(this.repository, this.remoteRoot, false);
            session.open(Policy.subMonitorFor(monitor, 10), false);
            try {
                this.fetchFileRevisions(session, this.changedFiles.toArray(new String[this.changedFiles.size()]), Policy.subMonitorFor(monitor, 20));
            }
            finally {
                session.close();
            }
        }
        RemoteFile remoteFile2 = remoteFile;
        CVSProviderPlugin.getPlugin().setQuietness(quietness);
        monitor.done();
        return remoteFile2;
    }

    private Command.KSubstOption getKeywordMode(ICVSFile file) throws CVSException {
        if (file == null) {
            return null;
        }
        byte[] syncBytes = file.getSyncBytes();
        if (syncBytes == null) {
            return null;
        }
        return ResourceSyncInfo.getKeywordMode(syncBytes);
    }

    RemoteFolder buildBaseTree(RemoteFolder parent, ICVSFolder local, IProgressMonitor monitor) throws CVSException {
        Policy.checkCanceled(monitor);
        FolderSyncInfo folderSyncInfo = local.getFolderSyncInfo();
        if (folderSyncInfo == null) {
            return null;
        }
        RemoteFolder remote = this.createRemoteFolder(local, parent, folderSyncInfo);
        ArrayList<RemoteResource> children = new ArrayList<RemoteResource>();
        ICVSResource[] folders = local.members(2);
        int i = 0;
        while (i < folders.length) {
            ICVSFolder folder = (ICVSFolder)folders[i];
            if (folder.isManaged() && folder.isCVSFolder()) {
                monitor.worked(1);
                RemoteFolder tree = this.buildBaseTree(remote, folder, monitor);
                if (tree != null) {
                    children.add(tree);
                }
            }
            ++i;
        }
        ICVSResource[] files = local.members(1);
        int i2 = 0;
        while (i2 < files.length) {
            ICVSFile file = (ICVSFile)files[i2];
            byte[] syncBytes = file.getSyncBytes();
            if (syncBytes != null && !ResourceSyncInfo.isAddition(syncBytes)) {
                if (ResourceSyncInfo.isDeletion(syncBytes)) {
                    syncBytes = ResourceSyncInfo.convertFromDeletion(syncBytes);
                }
                children.add(this.createRemoteFile(remote, syncBytes));
                monitor.worked(1);
            }
            ++i2;
        }
        if (children.isEmpty() && this.isPruneEmptyDirectories() && !local.exists()) {
            return null;
        }
        remote.setChildren(children.toArray(new ICVSRemoteResource[children.size()]));
        return remote;
    }

    protected RemoteFile createRemoteFile(RemoteFolder remote, byte[] syncBytes) throws CVSException {
        return new RemoteFile(remote, syncBytes);
    }

    protected RemoteFolder createRemoteFolder(ICVSFolder local, RemoteFolder parent, FolderSyncInfo folderSyncInfo) {
        return new RemoteFolderTree(parent, local.getName(), this.repository, folderSyncInfo.getRepository(), folderSyncInfo.getTag());
    }

    private void buildRemoteTree(Session session, ICVSFolder local, RemoteFolderTree remote, String localPath, IProgressMonitor monitor) throws CVSException {
        Map deltas;
        Policy.checkCanceled(monitor);
        this.recordRemoteFolder(remote);
        HashMap<String, RemoteResource> children = new HashMap<String, RemoteResource>();
        if (local == null) {
            this.fetchNewDirectory(session, remote, localPath, monitor);
        }
        if ((deltas = (Map)this.fileDeltas.get(localPath)) == null) {
            deltas = EMPTY_MAP;
        }
        if (local != null) {
            ICVSResource[] folders = local.members(2);
            int i = 0;
            while (i < folders.length) {
                ICVSFolder folder = (ICVSFolder)folders[i];
                DeltaNode d = (DeltaNode)deltas.get(folder.getName());
                if (folder.isCVSFolder() && !this.isOrphanedSubtree(folder) && (d == null || d.getRevision() != DELETED)) {
                    children.put(folders[i].getName(), new RemoteFolderTree(remote, folders[i].getName(), this.repository, folder.getFolderSyncInfo().getRepository(), this.tagForRemoteFolder(folder, this.tag)));
                }
                ++i;
            }
            ICVSResource[] files = local.members(1);
            int i2 = 0;
            while (i2 < files.length) {
                ICVSFile file = (ICVSFile)files[i2];
                DeltaNode d = (DeltaNode)deltas.get(file.getName());
                byte[] syncBytes = file.getSyncBytes();
                if (!(syncBytes == null || ResourceSyncInfo.isAddition(syncBytes) && d == null || ResourceSyncInfo.isDeletion(syncBytes) && d == null)) {
                    int type = d == null ? 0 : d.getSyncState();
                    children.put(file.getName(), new RemoteFile(remote, type, syncBytes));
                }
                ++i2;
            }
        }
        for (String name : deltas.keySet()) {
            DeltaNode d = (DeltaNode)deltas.get(name);
            String revision = d.getRevision();
            if (revision == FOLDER) {
                children.put(name, new RemoteFolderTree(remote, this.repository, Util.appendPath(remote.getRepositoryRelativePath(), name), this.tagForRemoteFolder(remote, this.tag)));
            } else if (revision == ADDED) {
                children.put(name, new RemoteFile(remote, d.getSyncState(), name, null, null, this.tagForRemoteFolder(remote, this.tag)));
            } else if (revision == UNKNOWN) {
                children.put(name, new RemoteFile(remote, d.getSyncState(), name, null, this.getKeywordMode((ICVSFile)children.get(name)), this.tagForRemoteFolder(remote, this.tag)));
            } else if (revision == DELETED && children.containsKey(name)) {
                children.remove(name);
            }
            monitor.worked(1);
        }
        remote.setChildren(children.values().toArray(new ICVSRemoteResource[children.size()]));
        Iterator childIterator = children.entrySet().iterator();
        ArrayList<RemoteFolderTree> emptyChildren = new ArrayList<RemoteFolderTree>();
        while (childIterator.hasNext()) {
            Map.Entry entry = childIterator.next();
            if (!((RemoteResource)entry.getValue()).isFolder()) continue;
            RemoteFolderTree remoteFolder = (RemoteFolderTree)entry.getValue();
            String name = (String)entry.getKey();
            DeltaNode d = (DeltaNode)deltas.get(name);
            ICVSFolder localFolder = d != null && d.getRevision() == FOLDER ? null : local.getFolder(name);
            this.buildRemoteTree(session, localFolder, remoteFolder, Util.appendPath(localPath, name), monitor);
            if (!this.isPruneEmptyDirectories() || remoteFolder.getChildren().length != 0) continue;
            if (localFolder == null || localFolder.members(63).length == 0) {
                emptyChildren.add(remoteFolder);
                continue;
            }
            FolderSyncInfo info = localFolder.getFolderSyncInfo();
            if (this.tag == null || info == null || this.tag.equals(CVSTag.DEFAULT) || this.tag.equals(info.getTag())) continue;
            emptyChildren.add(remoteFolder);
        }
        if (this.isPruneEmptyDirectories() && !emptyChildren.isEmpty()) {
            ArrayList newChildren = new ArrayList();
            newChildren.addAll(Arrays.asList(remote.getChildren()));
            newChildren.removeAll(emptyChildren);
            remote.setChildren(newChildren.toArray(new ICVSRemoteResource[newChildren.size()]));
        }
    }

    private List fetchDelta(Session session, String[] arguments, final IProgressMonitor monitor) throws CVSException {
        IUpdateMessageListener listener = new IUpdateMessageListener(){

            public void directoryInformation(ICVSFolder root, String path, boolean newDirectory) {
                if (newDirectory) {
                    RemoteFolderTreeBuilder.this.recordDelta(path, FOLDER, 0);
                    monitor.subTask(NLS.bind((String)CVSMessages.RemoteFolderTreeBuilder_receivingDelta, (Object[])new String[]{Util.toTruncatedPath(path, 3)}));
                }
            }

            public void directoryDoesNotExist(ICVSFolder root, String path) {
                if (path.length() == 0) {
                    RemoteFolderTreeBuilder.this.rootDoesNotExist = true;
                } else {
                    RemoteFolderTreeBuilder.this.recordDelta(path, DELETED, 0);
                    monitor.subTask(NLS.bind((String)CVSMessages.RemoteFolderTreeBuilder_receivingDelta, (Object[])new String[]{Util.toTruncatedPath(path, 3)}));
                }
            }

            public void fileInformation(int type, ICVSFolder root, String filename) {
                switch (type) {
                    case 6: 
                    case 7: {
                        DeltaNode d;
                        Map deltas = (Map)RemoteFolderTreeBuilder.this.fileDeltas.get(Util.removeLastSegment(filename));
                        DeltaNode deltaNode = d = deltas != null ? (DeltaNode)deltas.get(Util.getLastSegment(filename)) : null;
                        if (d != null && d.getRevision() == DELETED) break;
                    }
                    case 3: 
                    case 4: {
                        RemoteFolderTreeBuilder.this.changedFiles.add(filename);
                        RemoteFolderTreeBuilder.this.recordDelta(filename, UNKNOWN, type);
                        monitor.subTask(NLS.bind((String)CVSMessages.RemoteFolderTreeBuilder_receivingDelta, (Object[])new String[]{Util.toTruncatedPath(filename, 3)}));
                    }
                }
            }

            public void fileDoesNotExist(ICVSFolder root, String filename) {
                RemoteFolderTreeBuilder.this.recordDelta(filename, DELETED, 0);
                monitor.subTask(NLS.bind((String)CVSMessages.RemoteFolderTreeBuilder_receivingDelta, (Object[])new String[]{Util.toTruncatedPath(filename, 3)}));
            }
        };
        IStatus status = Command.SYNCUPDATE.execute(session, new Command.GlobalOption[]{Command.DO_NOT_CHANGE}, this.updateLocalOptions, arguments, (ICommandOutputListener)new UpdateListener(listener), monitor);
        if (status.getCode() == -10) {
            CVSServerException e = new CVSServerException(status);
            if (e.isNoTagException()) {
                this.rootDoesNotExist = true;
            } else if (e.containsErrors()) {
                CVSProviderPlugin.log((CoreException)((Object)e));
            }
        }
        return this.changedFiles;
    }

    private void fetchNewDirectory(Session session, RemoteFolderTree newFolder, String localPath, final IProgressMonitor monitor) throws CVSException {
        IUpdateMessageListener listener = new IUpdateMessageListener(){

            public void directoryInformation(ICVSFolder root, String path, boolean newDirectory) {
                if (newDirectory) {
                    RemoteFolderTreeBuilder.this.recordDelta(path, FOLDER, 0);
                    monitor.subTask(NLS.bind((String)CVSMessages.RemoteFolderTreeBuilder_receivingDelta, (Object[])new String[]{Util.toTruncatedPath(path, 3)}));
                }
            }

            public void directoryDoesNotExist(ICVSFolder root, String path) {
            }

            public void fileInformation(int type, ICVSFolder root, String filename) {
                RemoteFolderTreeBuilder.this.changedFiles.add(filename);
                RemoteFolderTreeBuilder.this.recordDelta(filename, ADDED, type);
                monitor.subTask(NLS.bind((String)CVSMessages.RemoteFolderTreeBuilder_receivingDelta, (Object[])new String[]{Util.toTruncatedPath(filename, 3)}));
            }

            public void fileDoesNotExist(ICVSFolder root, String filename) {
            }
        };
        IStatus status = Command.UPDATE.execute(session, new Command.GlobalOption[]{Command.DO_NOT_CHANGE}, this.updateLocalOptions, new String[]{localPath}, (ICommandOutputListener)new UpdateListener(listener), Policy.subMonitorFor(monitor, 1));
        if (status.getCode() == -10) {
            CVSServerException e = new CVSServerException(status);
            if (!e.isNoTagException() && e.containsErrors()) {
                throw e;
            }
            Policy.checkCanceled(monitor);
            status = Command.UPDATE.execute(session, new Command.GlobalOption[]{Command.DO_NOT_CHANGE}, this.getOptionsWithoutTag(), new String[]{localPath}, (ICommandOutputListener)new UpdateListener(listener), Policy.subMonitorFor(monitor, 1));
            if (status.getCode() == -10) {
                throw new CVSServerException(status);
            }
        }
    }

    private void fetchFileRevisions(Session session, String[] fileNames, final IProgressMonitor monitor) throws CVSException {
        final ArrayList exceptions = new ArrayList();
        IStatusListener listener = new IStatusListener(){

            public void fileStatus(ICVSFolder root, String path, String remoteRevision) {
                try {
                    RemoteFolderTreeBuilder.this.updateRevision(path, remoteRevision);
                    monitor.subTask(NLS.bind((String)CVSMessages.RemoteFolderTreeBuilder_receivingRevision, (Object[])new String[]{Util.toTruncatedPath(path, 3)}));
                }
                catch (CVSException e) {
                    exceptions.add(e);
                }
            }
        };
        IStatus status = Command.STATUS.execute(session, Command.NO_GLOBAL_OPTIONS, Command.NO_LOCAL_OPTIONS, fileNames, (ICommandOutputListener)new StatusListener(listener), monitor);
        if (status.getCode() == -10) {
            throw new CVSServerException(status);
        }
        if (!exceptions.isEmpty()) {
            if (exceptions.size() == 1) {
                throw (CVSException)((Object)exceptions.get(0));
            }
            MultiStatus multi = new MultiStatus("org.eclipse.team.cvs.core", 0, CVSMessages.RemoteFolder_errorFetchingRevisions, null);
            int i = 0;
            while (i < exceptions.size()) {
                multi.merge(((CVSException)((Object)exceptions.get(i))).getStatus());
                ++i;
            }
            throw new CVSException((IStatus)multi);
        }
    }

    protected boolean isPruneEmptyDirectories() {
        return false;
    }

    private void recordDelta(String path, String revision, int syncState) {
        String parent;
        HashMap<String, DeltaNode> deltas;
        if (revision == FOLDER) {
            this.newFolderExist = true;
        }
        if ((deltas = (HashMap<String, DeltaNode>)this.fileDeltas.get(parent = Util.removeLastSegment(path))) == null) {
            deltas = new HashMap<String, DeltaNode>();
            this.fileDeltas.put(parent, deltas);
        }
        String name = Util.getLastSegment(path);
        deltas.put(name, new DeltaNode(name, revision, syncState));
    }

    private void updateRevision(String path, String revision) throws CVSException {
        RemoteFolderTree folder = this.getRecoredRemoteFolder(Util.removeLastSegment(path));
        if (folder == null) {
            throw new CVSException(NLS.bind((String)CVSMessages.RemoteFolderTreeBuilder_missingParent, (Object[])new String[]{path.toString(), revision}));
        }
        ((RemoteFile)folder.getFile(Util.getLastSegment(path))).setRevision(revision);
    }

    private CVSTag tagForRemoteFolder(ICVSFolder folder, CVSTag tag) throws CVSException {
        return tag == null ? folder.getFolderSyncInfo().getTag() : tag;
    }

    private boolean isOrphanedSubtree(ICVSFolder mFolder) throws CVSException {
        return mFolder.isCVSFolder() && !mFolder.isManaged() && !mFolder.equals(this.root) && mFolder.getParent().isCVSFolder();
    }

    private void recordRemoteFolder(RemoteFolderTree remote) throws CVSException {
        String path = remote.getFolderSyncInfo().getRemoteLocation();
        this.remoteFolderTable.put(Util.asPath(path), remote);
    }

    private RemoteFolderTree getRecoredRemoteFolder(String path) {
        return (RemoteFolderTree)this.remoteFolderTable.get(Util.asPath(path));
    }

    public String[] getFileDiffs() {
        return this.changedFiles.toArray(new String[this.changedFiles.size()]);
    }

    static class DeltaNode {
        int syncState = 0;
        String name;
        String revision;

        DeltaNode(String name, String revision, int syncState) {
            this.name = name;
            this.revision = revision;
            this.syncState = syncState;
        }

        String getName() {
            return this.name;
        }

        String getRevision() {
            return this.revision;
        }

        int getSyncState() {
            return this.syncState;
        }
    }
}

