/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.client.ResponseHandler;
import org.eclipse.team.internal.ccvs.core.client.Session;

class RemoveEntryHandler
extends ResponseHandler {
    RemoveEntryHandler() {
    }

    public String getResponseID() {
        return "Remove-entry";
    }

    public void handle(Session session, String localDir, IProgressMonitor monitor) throws CVSException {
        String repositoryFile = session.readLine();
        String fileName = repositoryFile.substring(repositoryFile.lastIndexOf("/") + 1);
        ICVSFolder mParent = session.getLocalRoot().getFolder(localDir);
        ICVSFile mFile = mParent.getFile(fileName);
        if (mFile.exists()) {
            CVSProviderPlugin.log((CoreException)((Object)new CVSException(NLS.bind((String)CVSMessages.RemoveEntryHandler_2, (Object[])new String[]{mFile.getRepositoryRelativePath()}))));
        } else {
            mFile.unmanage(null);
        }
    }
}

