/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureContentConsumer;
import org.eclipse.update.core.IInstallHandler;
import org.eclipse.update.core.IInstallHandlerEntry;
import org.eclipse.update.core.IInstallHandlerWithFilter;
import org.eclipse.update.core.INonPluginEntry;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.IVerificationListener;
import org.eclipse.update.core.InstallMonitor;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.osgi.framework.Bundle;

public class InstallHandlerProxy
implements IInstallHandlerWithFilter {
    private IFeature feature = null;
    private int type;
    private IInstallHandler handler = null;
    private IStatus savedStatus = null;
    private boolean DEBUG = false;
    private static final String EXT_PLUGIN = "org.eclipse.update.core";
    private static final String UI_PLUGIN = "org.eclipse.ui";
    private static final String EXT_POINT = "installHandlers";
    private Method nonPluginDataAcceptor = null;

    private InstallHandlerProxy() {
    }

    public InstallHandlerProxy(int type, IFeature feature, IInstallHandlerEntry entry, InstallMonitor monitor) throws CoreException {
        this.initialize(type, feature, entry, monitor);
    }

    public void initialize(int type, IFeature feature, IInstallHandlerEntry entry, InstallMonitor monitor) throws CoreException {
        this.DEBUG = UpdateCore.DEBUG_SHOW_IHANDLER;
        if (feature == null) {
            throw new IllegalArgumentException();
        }
        this.feature = feature;
        this.type = type;
        if (entry == null) {
            if (this.DEBUG) {
                this.debug("not specified");
            }
            return;
        }
        String library = entry.getLibrary();
        String handlerName = entry.getHandlerName();
        if (handlerName == null || handlerName.trim().equals("")) {
            if (this.DEBUG) {
                this.debug("not specified");
            }
            return;
        }
        if (this.DEBUG) {
            this.debug("handler=" + handlerName);
            this.debug("path=   " + library);
        }
        try {
            this.handler = library == null || library.trim().equals("") ? this.getGlobalHandler(handlerName) : this.getLocalHandler(library, handlerName);
            if (this.handler == null) {
                return;
            }
            this.handler.initialize(type, feature, entry, monitor);
        }
        catch (ClassNotFoundException e) {
            this.handleExceptionInInit(NLS.bind((String)Messages.InstallHandler_notFound, (Object[])new String[]{feature.getLabel()}), e);
        }
        catch (ClassCastException e) {
            this.handleExceptionInInit(NLS.bind((String)Messages.InstallHandler_invalidHandler, (Object[])new String[]{feature.getLabel()}), e);
        }
        catch (CoreException e) {
            this.handleExceptionInInit(null, (Exception)((Object)e));
        }
        catch (Exception e) {
            this.handleExceptionInInit(NLS.bind((String)Messages.InstallHandler_unableToCreateHandler, (Object[])new String[]{feature.getLabel()}), e);
        }
    }

    public void installInitiated() throws CoreException {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.DEBUG) {
                this.debug("calling installInitiated()");
            }
            this.handler.installInitiated();
        }
        catch (Throwable e) {
            this.handleExceptionInCall(e, this.feature);
        }
    }

    public void pluginsDownloaded(IPluginEntry[] plugins) throws CoreException {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.DEBUG) {
                this.debug("calling pluginsDownloaded()");
            }
            this.handler.pluginsDownloaded(plugins);
        }
        catch (Throwable e) {
            this.handleExceptionInCall(e, this.feature);
        }
    }

    public void completeInstall(IFeatureContentConsumer consumer) throws CoreException {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.DEBUG) {
                this.debug("calling completeInstall()");
            }
            this.handler.completeInstall(consumer);
        }
        catch (Throwable e) {
            this.handleExceptionInCall(e, this.feature);
        }
    }

    public void nonPluginDataDownloaded(INonPluginEntry[] nonPluginData, IVerificationListener listener) throws CoreException {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.DEBUG) {
                this.debug("calling nonPluginDataDownloaded()");
            }
            this.handler.nonPluginDataDownloaded(nonPluginData, listener);
        }
        catch (Throwable e) {
            this.handleExceptionInCall(e, this.feature);
        }
    }

    public void installCompleted(boolean success) throws CoreException {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.DEBUG) {
                this.debug("calling installCompleted()");
            }
            this.handler.installCompleted(success);
        }
        catch (Throwable e) {
            this.handleExceptionInCall(e, this.feature);
        }
    }

    public void configureInitiated() throws CoreException {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.DEBUG) {
                this.debug("calling configureInitiated()");
            }
            this.handler.configureInitiated();
        }
        catch (Throwable e) {
            this.handleExceptionInCall(e, this.feature);
        }
    }

    public void completeConfigure() throws CoreException {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.DEBUG) {
                this.debug("calling completeConfigure()");
            }
            this.handler.completeConfigure();
        }
        catch (Throwable e) {
            this.handleExceptionInCall(e, this.feature);
        }
    }

    public void configureCompleted(boolean success) throws CoreException {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.DEBUG) {
                this.debug("calling configureCompleted()");
            }
            this.handler.configureCompleted(success);
        }
        catch (Throwable e) {
            this.handleExceptionInCall(e, this.feature);
        }
    }

    public void unconfigureInitiated() throws CoreException {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.DEBUG) {
                this.debug("calling unconfigureInitiated()");
            }
            this.handler.unconfigureInitiated();
        }
        catch (Throwable e) {
            this.handleExceptionInCall(e, this.feature);
        }
    }

    public void completeUnconfigure() throws CoreException {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.DEBUG) {
                this.debug("calling completeUnconfigure()");
            }
            this.handler.completeUnconfigure();
        }
        catch (Throwable e) {
            this.handleExceptionInCall(e, this.feature);
        }
    }

    public void unconfigureCompleted(boolean success) throws CoreException {
        if (this.handler == null) {
            if (this.savedStatus == null) {
                return;
            }
            throw new CoreException(this.savedStatus);
        }
        try {
            if (this.DEBUG) {
                this.debug("calling unconfigureCompleted()");
            }
            this.handler.unconfigureCompleted(success);
        }
        catch (Throwable e) {
            this.handleExceptionInCall(e, this.feature);
        }
        if (this.savedStatus != null) {
            throw new CoreException(this.savedStatus);
        }
    }

    public void uninstallInitiated() throws CoreException {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.DEBUG) {
                this.debug("calling uninstallInitiated()");
            }
            this.handler.uninstallInitiated();
        }
        catch (Throwable e) {
            this.handleExceptionInCall(e, this.feature);
        }
    }

    public void completeUninstall() throws CoreException {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.DEBUG) {
                this.debug("calling completeUninstall()");
            }
            this.handler.completeUninstall();
        }
        catch (Throwable e) {
            this.handleExceptionInCall(e, this.feature);
        }
    }

    public void uninstallCompleted(boolean success) throws CoreException {
        if (this.handler == null) {
            if (this.savedStatus == null) {
                return;
            }
            throw new CoreException(this.savedStatus);
        }
        try {
            if (this.DEBUG) {
                this.debug("calling uninstallCompleted()");
            }
            this.handler.uninstallCompleted(success);
        }
        catch (Throwable e) {
            this.handleExceptionInCall(e, this.feature);
        }
        if (this.savedStatus != null) {
            throw new CoreException(this.savedStatus);
        }
    }

    private void handleExceptionInInit(String s, Exception e) throws CoreException {
        CoreException ce = e instanceof CoreException ? (CoreException)((Object)e) : Utilities.newCoreException(s, e);
        if (!this.isUndoAction()) {
            throw ce;
        }
        String id = UpdateCore.getPlugin().getBundle().getSymbolicName();
        Status status = new Status(4, id, 0, "InstallHandler.deactivated", (Throwable)ce);
        UpdateCore.getPlugin().getLog().log((IStatus)status);
        this.handler = null;
        this.savedStatus = status;
    }

    private void handleExceptionInCall(Throwable e, IFeature feature) throws CoreException {
        CoreException ce = e instanceof CoreException ? (CoreException)e : Utilities.newCoreException(NLS.bind((String)Messages.InstallHandler_callException, (Object[])new String[]{feature.getLabel()}), e);
        if (!this.isUndoAction()) {
            throw ce;
        }
        String id = UpdateCore.getPlugin().getBundle().getSymbolicName();
        Status status = new Status(4, id, 0, "InstallHandler.deactivated", (Throwable)ce);
        UpdateCore.getPlugin().getLog().log((IStatus)status);
        this.handler = null;
        this.savedStatus = status;
    }

    private boolean isUndoAction() {
        return this.type != 1 && this.type != 2;
    }

    private IInstallHandler getLocalHandler(String libs, String name) throws IOException, CoreException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        ContentReference baseRef = this.feature.getFeatureContentProvider().getFeatureManifestReference(null);
        URL base = null;
        if (baseRef != null) {
            base = baseRef.asURL();
        }
        if (base == null) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.InstallHandler_unableToCreateHandler, (Object[])new String[]{this.feature.getLabel()}), null);
        }
        StringTokenizer libraries = new StringTokenizer(libs, ",");
        URL[] cp = new URL[libraries.countTokens()];
        int token = 0;
        while (token < cp.length) {
            cp[token] = new URL(base, libraries.nextToken());
            ++token;
        }
        if (this.type == 4) {
            URL[] jars = new URL[cp.length];
            int jar = 0;
            while (jar < cp.length) {
                File tempLib = File.createTempFile("tmp" + jar, ".jar");
                tempLib.deleteOnExit();
                FileOutputStream fos = null;
                InputStream is = null;
                try {
                    fos = new FileOutputStream(tempLib);
                    is = new FileInputStream(cp[jar].getPath());
                    Utilities.copy(is, fos, null);
                }
                catch (Throwable throwable) {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception exception) {}
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
                jars[jar] = tempLib.toURL();
                ++jar;
            }
            cp = jars;
        }
        InstallHandlerClassLoader loader = new InstallHandlerClassLoader(cp);
        Class<?> clazz = ((ClassLoader)loader).loadClass(name);
        IInstallHandler handler = (IInstallHandler)clazz.newInstance();
        return handler;
    }

    private IInstallHandler getGlobalHandler(String name) throws Exception {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] handlerExtension = reg.getConfigurationElementsFor(EXT_PLUGIN, EXT_POINT, name);
        if (handlerExtension == null || handlerExtension.length <= 0) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.InstallHandler_unableToCreateHandler, (Object[])new String[]{this.feature.getLabel()}), null);
        }
        return (IInstallHandler)handlerExtension[0].createExecutableExtension("class");
    }

    private void debug(String s) {
        String pfx = this.feature == null ? "" : this.feature.getVersionedIdentifier().toString();
        System.out.println("InstallHandler[" + pfx + "]: " + s);
    }

    public boolean acceptNonPluginData(INonPluginEntry data) {
        Boolean result = new Boolean(true);
        if (this.handler != null) {
            if (this.DEBUG) {
                this.debug("calling acceptNonPluginData()");
            }
            if (this.handler instanceof IInstallHandlerWithFilter) {
                return ((IInstallHandlerWithFilter)this.handler).acceptNonPluginData(data);
            }
            if (this.getNonPluginDataAcceptor() != null) {
                try {
                    Object[] param = new Object[]{data};
                    result = (Boolean)this.getNonPluginDataAcceptor().invoke((Object)this.handler, param);
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    private Method getNonPluginDataAcceptor() {
        if (this.nonPluginDataAcceptor == null) {
            try {
                Class[] types = new Class[]{INonPluginEntry.class};
                this.nonPluginDataAcceptor = this.handler.getClass().getMethod("acceptNonPluginData", types);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        return this.nonPluginDataAcceptor;
    }

    private static class InstallHandlerClassLoader
    extends URLClassLoader {
        private Bundle updateCore = Platform.getBundle((String)"org.eclipse.update.core");
        private Bundle eclipseUI = Platform.getBundle((String)"org.eclipse.ui");

        public InstallHandlerClassLoader(URL[] classpath) {
            super(classpath);
            if (this.eclipseUI != null && this.eclipseUI.getState() != 32) {
                this.eclipseUI = null;
            }
        }

        public Class loadClass(String className) throws ClassNotFoundException {
            Class c = null;
            try {
                c = this.updateCore.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    if (this.eclipseUI != null) {
                        c = this.eclipseUI.loadClass(className);
                    }
                }
                catch (ClassNotFoundException classNotFoundException2) {}
            }
            if (c != null) {
                return c;
            }
            return super.loadClass(className);
        }

        public URL getResource(String resName) {
            URL u = this.updateCore.getResource(resName);
            if (u == null && this.eclipseUI != null) {
                u = this.eclipseUI.getResource(resName);
            }
            if (u != null) {
                return u;
            }
            return super.getResource(resName);
        }
    }
}

