/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.mapping;

import java.util.ArrayList;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.ResourceSaveableComparison;
import org.eclipse.team.ui.mapping.ISynchronizationCompareAdapter;
import org.eclipse.ui.model.IWorkbenchAdapter;

public abstract class SynchronizationCompareAdapter
implements ISynchronizationCompareAdapter {
    public ICompareInput asCompareInput(ISynchronizationContext context, Object o) {
        IDiff node;
        IResource resource = Utils.getResource(o);
        if (resource != null && resource.getType() == 1 && (node = context.getDiffTree().getDiff(resource)) != null) {
            return new ResourceSaveableComparison.ResourceDiffCompareInput(node);
        }
        return null;
    }

    public boolean hasCompareInput(ISynchronizationContext context, Object object) {
        return this.asCompareInput(context, object) != null;
    }

    public String getName(ResourceMapping mapping) {
        String label;
        Object object = mapping.getModelObject();
        IWorkbenchAdapter adapter = (IWorkbenchAdapter)Utils.getAdapter(object, IWorkbenchAdapter.class);
        if (adapter != null && (label = adapter.getLabel(object)) != null) {
            return label;
        }
        IResource resource = Utils.getResource(object);
        if (resource != null) {
            return resource.getName();
        }
        if (object instanceof ModelProvider) {
            ModelProvider provider = (ModelProvider)object;
            if (provider.getId().equals("org.eclipse.core.resources.modelProvider")) {
                return TeamUIMessages.SynchronizationCompareAdapter_0;
            }
            return provider.getDescriptor().getLabel();
        }
        return "";
    }

    public String getPathString(ResourceMapping mapping) {
        Object object = mapping.getModelObject();
        IWorkbenchAdapter adapter = (IWorkbenchAdapter)Utils.getAdapter(object, IWorkbenchAdapter.class);
        if (adapter != null) {
            ArrayList<String> segments = new ArrayList<String>();
            Object parent = object;
            do {
                String segment;
                if ((segment = adapter.getLabel(parent)) == null || segment.length() <= 0) continue;
                segments.add(0, segment);
            } while ((parent = adapter.getParent(parent)) != null);
            if (!segments.isEmpty()) {
                Path path = Path.EMPTY;
                for (String segment : segments) {
                    path = path.append(segment);
                }
                return path.toString();
            }
        }
        return this.getName(mapping);
    }
}

