/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.contexts.DebugContextManager;
import org.eclipse.debug.internal.ui.contexts.provisional.IDebugContextListener;
import org.eclipse.debug.internal.ui.contexts.provisional.IDebugContextManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;

public class RunToLineActionDelegate
implements IEditorActionDelegate,
IActionDelegate2,
IViewActionDelegate {
    private IWorkbenchPart fActivePart = null;
    private IRunToLineTarget fPartTarget = null;
    private IAction fAction = null;
    private IDebugContextListener fContextListener = new DebugContextListener();
    private ISuspendResume fTargetElement = null;

    public void dispose() {
        DebugContextManager.getDefault().removeDebugContextListener(this.fContextListener, this.fActivePart.getSite().getWorkbenchWindow());
        this.fActivePart = null;
        this.fPartTarget = null;
    }

    public void run(IAction action) {
        if (this.fPartTarget != null && this.fTargetElement != null) {
            try {
                this.fPartTarget.runToLine(this.fActivePart, this.fActivePart.getSite().getSelectionProvider().getSelection(), this.fTargetElement);
            }
            catch (CoreException e) {
                DebugUIPlugin.errorDialog(this.fActivePart.getSite().getWorkbenchWindow().getShell(), ActionMessages.RunToLineAction_0, ActionMessages.RunToLineAction_1, e.getStatus());
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fAction = action;
        this.update();
    }

    public void update() {
        if (this.fAction == null) {
            return;
        }
        Runnable r = new Runnable(){

            public void run() {
                ISelectionProvider selectionProvider;
                IWorkbenchPartSite site;
                boolean enabled = false;
                if (RunToLineActionDelegate.this.fPartTarget != null && RunToLineActionDelegate.this.fTargetElement != null && (site = RunToLineActionDelegate.this.fActivePart.getSite()) != null && (selectionProvider = site.getSelectionProvider()) != null) {
                    ISelection selection = selectionProvider.getSelection();
                    enabled = RunToLineActionDelegate.this.fTargetElement.isSuspended() && RunToLineActionDelegate.this.fPartTarget.canRunToLine(RunToLineActionDelegate.this.fActivePart, selection, RunToLineActionDelegate.this.fTargetElement);
                }
                RunToLineActionDelegate.this.fAction.setEnabled(enabled);
            }
        };
        DebugUIPlugin.getStandardDisplay().asyncExec(r);
    }

    public void init(IAction action) {
        this.fAction = action;
        if (action != null) {
            action.setText(ActionMessages.RunToLineActionDelegate_4);
            action.setImageDescriptor(DebugUITools.getImageDescriptor("IMG_LCL_RUN_TO_LINE"));
            action.setDisabledImageDescriptor(DebugUITools.getImageDescriptor("IMG_DLCL_RUN_TO_LINE"));
        }
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.init(action);
        this.bindTo((IWorkbenchPart)targetEditor);
    }

    public void init(IViewPart view) {
        this.bindTo((IWorkbenchPart)view);
    }

    private void bindTo(IWorkbenchPart part) {
        IDebugContextManager manager = DebugContextManager.getDefault();
        if (this.fActivePart != null && !this.fActivePart.equals(part)) {
            manager.removeDebugContextListener(this.fContextListener, this.fActivePart.getSite().getWorkbenchWindow());
        }
        this.fPartTarget = null;
        this.fActivePart = part;
        if (part != null) {
            IAdapterManager adapterManager;
            IWorkbenchWindow workbenchWindow = part.getSite().getWorkbenchWindow();
            manager.addDebugContextListener(this.fContextListener, workbenchWindow);
            this.fPartTarget = (IRunToLineTarget)part.getAdapter(IRunToLineTarget.class);
            if (this.fPartTarget == null && (adapterManager = Platform.getAdapterManager()).hasAdapter((Object)part, IRunToLineTarget.class.getName())) {
                this.fPartTarget = (IRunToLineTarget)adapterManager.loadAdapter((Object)part, IRunToLineTarget.class.getName());
            }
            ISelection activeContext = manager.getActiveContext(workbenchWindow);
            this.fContextListener.contextActivated(activeContext, part);
        }
        this.update();
    }

    class DebugContextListener
    implements IDebugContextListener {
        DebugContextListener() {
        }

        public void contextActivated(ISelection selection, IWorkbenchPart part) {
            Object object;
            IStructuredSelection ss;
            RunToLineActionDelegate.this.fTargetElement = null;
            if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (object = ss.getFirstElement()) instanceof ISuspendResume) {
                RunToLineActionDelegate.this.fTargetElement = (ISuspendResume)object;
            }
            RunToLineActionDelegate.this.update();
        }

        public void contextChanged(ISelection selection, IWorkbenchPart part) {
            this.contextActivated(selection, part);
        }
    }
}

