/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.provisional;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.provisional.IPresentationContext;

public abstract class AbstractModelProxy
implements IModelProxy {
    private IPresentationContext fContext;
    private ListenerList fListeners = new ListenerList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] getListeners() {
        ListenerList listenerList = this.fListeners;
        synchronized (listenerList) {
            return this.fListeners.getListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelChangedListener(IModelChangedListener listener) {
        ListenerList listenerList = this.fListeners;
        synchronized (listenerList) {
            this.fListeners.add((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelChangedListener(IModelChangedListener listener) {
        ListenerList listenerList = this.fListeners;
        synchronized (listenerList) {
            this.fListeners.remove((Object)listener);
        }
    }

    public void fireModelChanged(final IModelDelta delta) {
        Object[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IModelChangedListener listener = (IModelChangedListener)listeners[i];
            ISafeRunnable safeRunnable = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    DebugUIPlugin.log(exception);
                }

                public void run() throws Exception {
                    listener.modelChanged(delta);
                }
            };
            SafeRunner.run((ISafeRunnable)safeRunnable);
            ++i;
        }
    }

    public synchronized void dispose() {
        this.fContext = null;
    }

    public void init(IPresentationContext context) {
        this.fContext = context;
    }

    public IPresentationContext getPresentationContext() {
        return this.fContext;
    }

    public void installed() {
    }
}

