/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.internal.ui.actions.RetargetAction;
import org.eclipse.debug.internal.ui.contexts.DebugContextManager;
import org.eclipse.debug.internal.ui.contexts.provisional.IDebugContextListener;
import org.eclipse.debug.internal.ui.contexts.provisional.IDebugContextManager;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class RetargetRunToLineAction
extends RetargetAction {
    private IDebugContextListener fContextListener = new DebugContextListener();
    private ISuspendResume fTargetElement = null;

    public void dispose() {
        DebugContextManager.getDefault().removeDebugContextListener(this.fContextListener, this.fWindow);
        super.dispose();
    }

    public void init(IWorkbenchWindow window) {
        super.init(window);
        IDebugContextManager manager = DebugContextManager.getDefault();
        manager.addDebugContextListener(this.fContextListener, window);
        ISelection activeContext = manager.getActiveContext(window);
        this.fContextListener.contextActivated(activeContext, null);
    }

    protected boolean canPerformAction(Object target, ISelection selection, IWorkbenchPart part) {
        return this.fTargetElement != null && ((IRunToLineTarget)target).canRunToLine(part, selection, this.fTargetElement);
    }

    protected Class getAdapterClass() {
        return IRunToLineTarget.class;
    }

    protected void performAction(Object target, ISelection selection, IWorkbenchPart part) throws CoreException {
        ((IRunToLineTarget)target).runToLine(part, selection, this.fTargetElement);
    }

    class DebugContextListener
    implements IDebugContextListener {
        DebugContextListener() {
        }

        public void contextActivated(ISelection selection, IWorkbenchPart part) {
            Object object;
            IStructuredSelection ss;
            RetargetRunToLineAction.this.fTargetElement = null;
            if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (object = ss.getFirstElement()) instanceof ISuspendResume) {
                RetargetRunToLineAction.this.fTargetElement = (ISuspendResume)object;
            }
            RetargetRunToLineAction.this.update();
        }

        public void contextChanged(ISelection selection, IWorkbenchPart part) {
            this.contextActivated(selection, part);
        }
    }
}

