/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.corext.fix.UnusedCodeFix;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jface.dialogs.IDialogSettings;

public class UnnecessaryCodeCleanUp
extends AbstractCleanUp {
    public static final int REMOVE_UNUSED_CAST = 1;
    private static final int DEFAULT_FLAG = 1;
    private static final String SECTION_NAME = "CleanUp_UnnecessaryCode";

    public UnnecessaryCodeCleanUp(int flag) {
        super(flag);
    }

    public UnnecessaryCodeCleanUp(IDialogSettings settings) {
        super(UnnecessaryCodeCleanUp.getSection(settings, SECTION_NAME), 1);
    }

    public IFix createFix(CompilationUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return UnusedCodeFix.createCleanUp(compilationUnit, false, false, false, false, false, false, this.isFlag(1));
    }

    public IFix createFix(CompilationUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return UnusedCodeFix.createCleanUp(compilationUnit, problems, false, false, false, false, false, false, this.isFlag(1));
    }

    public Map getRequiredOptions() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        if (this.isFlag(1)) {
            options.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "warning");
        }
        return options;
    }

    public void saveSettings(IDialogSettings settings) {
        super.saveSettings(UnnecessaryCodeCleanUp.getSection(settings, SECTION_NAME));
    }

    public String[] getDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isFlag(1)) {
            result.add(MultiFixMessages.UnusedCodeCleanUp_RemoveUnusedCasts_description);
        }
        return result.toArray(new String[result.size()]);
    }

    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        if (this.isFlag(1)) {
            buf.append("Boolean b= Boolean.TRUE;\n");
        } else {
            buf.append("Boolean b= (Boolean) Boolean.TRUE;\n");
        }
        return buf.toString();
    }

    public boolean canFix(CompilationUnit compilationUnit, IProblemLocation problem) throws CoreException {
        IFix fix;
        return this.isFlag(1) && (fix = UnusedCodeFix.createRemoveUnusedCastFix(compilationUnit, problem)) != null;
    }

    public int maximalNumberOfFixes(CompilationUnit compilationUnit) {
        int result = 0;
        IProblem[] problems = compilationUnit.getProblems();
        if (this.isFlag(1)) {
            result += this.getNumberOfProblems(problems, 553648309);
        }
        return result;
    }

    public int getDefaultFlag() {
        return 1;
    }
}

