/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.extensions;

import java.util.Comparator;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorContentExtension;

public class ExtensionPriorityComparator
implements Comparator {
    public static final ExtensionPriorityComparator INSTANCE = new ExtensionPriorityComparator(true);
    public static final ExtensionPriorityComparator DESCENDING = new ExtensionPriorityComparator(false);
    private final int sortAscending;

    public ExtensionPriorityComparator(boolean toSortAscending) {
        this.sortAscending = toSortAscending ? 1 : -1;
    }

    public int compare(Object o1, Object o2) {
        INavigatorContentDescriptor lvalue = null;
        INavigatorContentDescriptor rvalue = null;
        if (o1 instanceof INavigatorContentDescriptor) {
            lvalue = (INavigatorContentDescriptor)o1;
        } else if (o1 instanceof INavigatorContentExtension) {
            lvalue = ((INavigatorContentExtension)o1).getDescriptor();
        }
        if (o2 instanceof INavigatorContentDescriptor) {
            rvalue = (INavigatorContentDescriptor)o2;
        } else if (o2 instanceof INavigatorContentExtension) {
            rvalue = ((INavigatorContentExtension)o2).getDescriptor();
        }
        if (lvalue == null || rvalue == null) {
            return -1 * this.sortAscending;
        }
        int c = lvalue.getPriority() - rvalue.getPriority();
        if (c != 0) {
            return c * this.sortAscending;
        }
        return lvalue.getId().compareTo(rvalue.getId()) * this.sortAscending;
    }
}

