/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional.validation;

import org.eclipse.jface.internal.databinding.internal.BindingMessages;
import org.eclipse.jface.internal.databinding.provisional.validation.IValidator;
import org.eclipse.jface.internal.databinding.provisional.validation.ValidationError;

public class String2FloatValidator
implements IValidator {
    public ValidationError isPartiallyValid(Object fragment) {
        if (((String)fragment).matches("\\-?[0-9]*\\.?[0-9]*([0-9]+[e|E]\\-?([0-9]+\\.)?[0-9]*)?")) {
            return null;
        }
        return ValidationError.error(this.getHint());
    }

    public ValidationError isValid(Object value) {
        try {
            Float.parseFloat((String)value);
            return null;
        }
        catch (Exception exception) {
            return ValidationError.error(this.getHint());
        }
    }

    private String getHint() {
        return String.valueOf(BindingMessages.getString("Validate_Like")) + BindingMessages.getString("Validate_Number_Examples") + Float.MIN_VALUE + ", " + Float.MAX_VALUE + ".";
    }
}

