/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.widgets;

import java.util.Hashtable;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class Section
extends ExpandableComposite {
    public static final int DESCRIPTION = 128;
    private Control descriptionControl;
    private Control separator;
    private Hashtable titleColors;
    private static final String COLOR_BG = "bg";
    private static final String COLOR_GBG = "gbg";
    private static final String COLOR_BORDER = "border";

    public Section(Composite parent, int style) {
        this(parent, 0, style);
    }

    Section(Composite parent, int cstyle, int style) {
        super(parent, cstyle | Section.getBackgroundStyle(style), style);
        int rtl = cstyle & 0x4000000;
        if ((style & 0x80) != 0) {
            this.descriptionControl = new Text((Composite)this, 0x48 | rtl);
        }
        if ((style & 0x100) != 0) {
            Listener listener = new Listener(){

                public void handleEvent(Event e) {
                    Image image = Section.super.getBackgroundImage();
                    if (image != null) {
                        image.dispose();
                    }
                    Section.super.setBackgroundImage(null);
                }
            };
            this.addListener(12, listener);
            this.addListener(11, listener);
        }
    }

    private static int getBackgroundStyle(int estyle) {
        return (estyle & 0x100) != 0 ? 262144 : 0;
    }

    protected void internalSetExpanded(boolean expanded) {
        super.internalSetExpanded(expanded);
        this.reflow();
    }

    protected void reflow() {
        Section c = this;
        while (c != null) {
            c.setRedraw(false);
            c = c.getParent();
            if (c instanceof ScrolledForm) break;
        }
        for (c = this; c != null; c = c.getParent()) {
            c.layout(true);
            if (!(c instanceof ScrolledForm)) continue;
            ((ScrolledForm)((Object)c)).reflow(true);
            break;
        }
        c = this;
        while (c != null) {
            c.setRedraw(true);
            c = c.getParent();
            if (c instanceof ScrolledForm) break;
        }
    }

    public void setDescription(String description) {
        if (this.descriptionControl instanceof Text) {
            ((Text)this.descriptionControl).setText(description);
        }
    }

    public String getDescription() {
        if (this.descriptionControl instanceof Text) {
            return ((Text)this.descriptionControl).getText();
        }
        return null;
    }

    public void setSeparatorControl(Control separator) {
        Assert.isTrue((separator != null && separator.getParent().equals((Object)this) ? 1 : 0) != 0);
        this.separator = separator;
    }

    public Control getSeparatorControl() {
        return this.separator;
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.descriptionControl != null && (this.getExpansionStyle() & 0x80) != 0) {
            this.descriptionControl.setBackground(bg);
        }
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.descriptionControl != null && (this.getExpansionStyle() & 0x80) != 0) {
            this.descriptionControl.setForeground(fg);
        }
    }

    public Control getDescriptionControl() {
        return this.descriptionControl;
    }

    public void setDescriptionControl(Control descriptionControl) {
        Assert.isTrue(((this.getExpansionStyle() & 0x80) == 0 ? 1 : 0) != 0);
        Assert.isTrue((descriptionControl != null && descriptionControl.getParent().equals((Object)this) ? 1 : 0) != 0);
        this.descriptionControl = descriptionControl;
    }

    public void setTitleBarBorderColor(Color color) {
        this.putTitleBarColor(COLOR_BORDER, color);
    }

    public void setTitleBarBackground(Color color) {
        this.putTitleBarColor(COLOR_BG, color);
    }

    public void setTitleBarGradientBackground(Color color) {
        this.putTitleBarColor(COLOR_GBG, color);
    }

    public Color getTitleBarBorderColor() {
        if (this.titleColors == null) {
            return null;
        }
        return (Color)this.titleColors.get(COLOR_BORDER);
    }

    public Color getTitleBarGradientBackground() {
        if (this.titleColors == null) {
            return null;
        }
        if ((this.getExpansionStyle() & 0x200) != 0) {
            return this.getBackground();
        }
        return (Color)this.titleColors.get(COLOR_GBG);
    }

    public Color getTitleBarBackground() {
        if (this.titleColors == null) {
            return null;
        }
        return (Color)this.titleColors.get(COLOR_BG);
    }

    private void putTitleBarColor(String key, Color color) {
        if (color == null) {
            return;
        }
        if (this.titleColors == null) {
            this.titleColors = new Hashtable();
        }
        this.titleColors.put(key, color);
    }

    protected void onPaint(PaintEvent e) {
        Color bg = null;
        Color gbg = null;
        Color fg = null;
        Color border = null;
        GC gc = e.gc;
        Image buffer = null;
        Rectangle bounds = this.getClientArea();
        if ((this.getExpansionStyle() & 0x100) != 0) {
            buffer = new Image((Device)this.getDisplay(), bounds.width, bounds.height);
            buffer.setBackground(this.getBackground());
            gc = new GC((Drawable)buffer);
        }
        if (this.titleColors != null) {
            bg = (Color)this.titleColors.get(COLOR_BG);
            gbg = (Color)this.titleColors.get(COLOR_GBG);
            fg = this.getTitleBarForeground();
            border = (Color)this.titleColors.get(COLOR_BORDER);
        }
        if (bg == null) {
            bg = this.getBackground();
        }
        if (fg == null) {
            fg = this.getForeground();
        }
        if (border == null) {
            border = fg;
        }
        if (gbg == null) {
            gbg = bg;
        }
        int theight = 0;
        int tvmargin = this.GAP;
        if ((this.getExpansionStyle() & 0x100) != 0) {
            Point tsize = null;
            Point tcsize = null;
            if (this.toggle != null) {
                tsize = this.toggle.getSize();
            }
            int twidth = bounds.width - this.marginWidth - this.marginWidth;
            if (tsize != null) {
                twidth -= tsize.x + this.GAP;
            }
            if (this.getTextClient() != null) {
                tcsize = this.getTextClient().getSize();
            }
            if (tcsize != null) {
                twidth -= tcsize.x + this.GAP;
            }
            Point size = this.textLabel.getSize();
            if (tsize != null) {
                theight += Math.max(theight, tsize.y);
            }
            if (tcsize != null) {
                theight = Math.max(theight, tcsize.y);
            }
            theight = Math.max(theight, size.y);
            theight += tvmargin + tvmargin;
        } else {
            theight = 5;
        }
        int midpoint = theight * 66 / 100;
        int rem = theight - midpoint;
        if ((this.getExpansionStyle() & 0x100) != 0) {
            if (this.getBackgroundImage() == null) {
                this.updateHeaderImage(bg, gbg, bounds, theight, midpoint, rem);
            }
            gc.setBackground(this.getBackground());
            gc.fillRectangle(bounds.x, bounds.y, bounds.width, bounds.height);
            this.drawBackground(gc, bounds.x, bounds.y, bounds.width, theight);
            if (this.marginWidth > 0) {
                gc.setBackground(this.getBackground());
                gc.fillRectangle(0, 0, this.marginWidth, theight);
                gc.fillRectangle(bounds.x + bounds.width - this.marginWidth, 0, this.marginWidth, theight);
            }
        } else if (this.isExpanded()) {
            gc.setForeground(bg);
            gc.setBackground(this.getBackground());
            gc.fillGradientRectangle(this.marginWidth, this.marginHeight, bounds.width - this.marginWidth - this.marginWidth, theight, true);
        }
        gc.setBackground(this.getBackground());
        gc.fillPolygon(new int[]{this.marginWidth, this.marginHeight, this.marginWidth, this.marginHeight + 2, this.marginWidth + 2, this.marginHeight});
        gc.fillPolygon(new int[]{bounds.width - this.marginWidth - 3, this.marginHeight, bounds.width - this.marginWidth - 1, this.marginHeight, bounds.width - this.marginWidth - 1, this.marginHeight + 2});
        gc.setForeground(border);
        if (this.isExpanded() || (this.getExpansionStyle() & 0x100) != 0) {
            gc.drawLine(this.marginWidth, this.marginHeight + 2, this.marginWidth + 2, this.marginHeight);
            gc.drawLine(this.marginWidth + 2, this.marginHeight, bounds.width - this.marginWidth - 3, this.marginHeight);
            gc.drawLine(bounds.width - this.marginWidth - 3, this.marginHeight, bounds.width - this.marginWidth - 1, this.marginHeight + 2);
        } else {
            gc.drawLine(this.marginWidth, this.marginHeight, bounds.width - 1, this.marginHeight);
        }
        if ((this.getExpansionStyle() & 0x100) != 0 && this.toggle != null && !this.isExpanded()) {
            gc.drawLine(this.marginWidth, this.marginHeight + 2, this.marginWidth, this.marginHeight + theight - 1);
            gc.drawLine(bounds.width - this.marginWidth - 1, this.marginHeight + 2, bounds.width - this.marginWidth - 1, this.marginHeight + theight - 1);
            gc.drawLine(this.marginWidth, this.marginHeight + theight - 1, bounds.width - this.marginWidth - 1, this.marginHeight + theight - 1);
        } else if (this.isExpanded()) {
            gc.fillGradientRectangle(this.marginWidth, this.marginHeight + 2, 1, theight - 2, true);
            gc.fillGradientRectangle(bounds.width - this.marginWidth - 1, this.marginHeight + 2, 1, theight - 2, true);
        }
        if (buffer != null) {
            e.gc.drawImage(buffer, 0, 0);
            gc.dispose();
            buffer.dispose();
        }
    }

    private void updateHeaderImage(Color bg, Color gbg, Rectangle bounds, int theight, int midpoint, int rem) {
        Image image = new Image((Device)this.getDisplay(), 1, theight);
        image.setBackground(this.getBackground());
        GC gc = new GC((Drawable)image);
        gc.setBackground(this.getBackground());
        gc.fillRectangle(0, 0, 1, theight);
        gc.setForeground(bg);
        gc.setBackground(gbg);
        gc.fillGradientRectangle(0, this.marginHeight, 1, midpoint - 1, true);
        gc.setForeground(gbg);
        gc.setBackground(this.getBackground());
        gc.fillGradientRectangle(0, this.marginHeight + midpoint - 1, 1, rem - 1, true);
        gc.dispose();
        super.setBackgroundImage(image);
    }

    public final void setBackgroundImage(Image image) {
    }
}

