/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.parser;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MarkupParser {
    public static String parseAndTrimTextMarkup(Node parentNode) {
        return MarkupParser.parseMarkup(parentNode).trim();
    }

    private static String parseMarkup(Node parentNode) {
        NodeList children = parentNode.getChildNodes();
        StringBuffer text = new StringBuffer();
        int i = 0;
        while (i < children.getLength()) {
            Node childNode = children.item(i);
            if (childNode.getNodeType() == 3) {
                text.append(MarkupParser.escapeText(childNode.getNodeValue()));
            } else if (childNode.getNodeType() == 1) {
                text.append('<');
                text.append(childNode.getNodeName());
                text.append('>');
                text.append(MarkupParser.parseMarkup(childNode));
                text.append("</");
                text.append(childNode.getNodeName());
                text.append('>');
            }
            ++i;
        }
        return text.toString();
    }

    private static String escapeText(String input) {
        StringBuffer result = new StringBuffer(input.length() + 10);
        int i = 0;
        while (i < input.length()) {
            MarkupParser.appendEscapedChar(result, input.charAt(i));
            ++i;
        }
        return result.toString();
    }

    private static void appendEscapedChar(StringBuffer buffer, char c) {
        String replacement = MarkupParser.getReplacement(c);
        if (replacement != null) {
            buffer.append('&');
            buffer.append(replacement);
            buffer.append(';');
        } else {
            buffer.append(c);
        }
    }

    private static String getReplacement(char c) {
        switch (c) {
            case '<': {
                return "lt";
            }
            case '>': {
                return "gt";
            }
            case '&': {
                return "amp";
            }
        }
        return null;
    }
}

