/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.internal.core.containment;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.wst.rdb.internal.models.sql.schema.Comment;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLSchemaPackage;

public class CommentContainmentProvider extends AbstractContainmentProvider
{
	public EStructuralFeature getContainmentFeature(EObject obj)
	{
		return SQLSchemaPackage.eINSTANCE.getSQLObject_Comments();
	}

	public EObject getContainer(EObject obj)
	{
		return ((Comment) obj).getSQLObject();
	}

	public String getGroupId(EObject obj)
	{
		return GroupID.COMMENT;
	}
}
