/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/

package org.eclipse.wst.rdb.connection.internal.ui.wizards.shared;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.rdb.connection.internal.ui.util.resource.ResourceLoader;
import org.eclipse.wst.rdb.connection.internal.ui.wizards.ConnectionUtils;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;

/**
 * @author ledunnel
 */
public class DatabaseAuthenticationWizardPage extends WizardPage implements Listener{
	private static final ResourceLoader resource = ResourceLoader.INSTANCE;
	
	private Label userIdLabel;

    private Label passwordLabel;

    private Combo userIdCombo;

    private Text passwordText;

    private ConnectionInfo connectionInfo = null;

    /**
     * @param pageName
     */
    public DatabaseAuthenticationWizardPage(String pageName) {
        super(pageName);
        setTitle(resource.queryString("_UI_PAGE_TITLE_DB_AUTHENTICATION")); //$NON-NLS-1$
        setDescription(resource.queryString("_UI_PAGE_DESCRIPTION_DB_AUTHENTICATION")); //$NON-NLS-1$
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
     */
    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, SWT.NONE);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout(layout);

        userIdLabel = new Label(composite, SWT.NONE);
        userIdLabel.setText(resource.queryString("_UI_LABEL_USER_ID")); //$NON-NLS-1$
        GridData gd = new GridData();
        gd.verticalAlignment = GridData.BEGINNING;
        userIdLabel.setLayoutData(gd);

        userIdCombo = new Combo(composite, SWT.SINGLE | SWT.BORDER);
        gd = new GridData();
        gd.widthHint = 100;
        gd.verticalAlignment = GridData.BEGINNING;
        gd.horizontalAlignment = GridData.FILL;
        userIdCombo.setLayoutData(gd);
        userIdCombo.addListener(SWT.Modify, this);

        passwordLabel = new Label(composite, SWT.NONE);
        passwordLabel.setText(resource.queryString("_UI_LABEL_PASSWORD")); //$NON-NLS-1$
        gd = new GridData();
        gd.verticalAlignment = GridData.BEGINNING;
        passwordLabel.setLayoutData(gd);

        passwordText = new Text(composite, SWT.BORDER);
        passwordText.setEchoChar('*');
        gd = new GridData();
        gd.widthHint = 100;
        gd.verticalAlignment = GridData.BEGINNING;
        gd.horizontalAlignment = GridData.FILL;
        passwordText.setLayoutData(gd);
        setControl(composite);
    }

    public void setUserID(String uid) {
        if (userIdCombo != null) {
            if (uid != null){
                userIdCombo.setText(uid);
            } else {
                userIdCombo.setText(""); //$NON-NLS-1$
            }          
        }
    }

    public String getUserID() {
        String uid = ""; //$NON-NLS-1$
        if (userIdCombo != null) {
            uid = userIdCombo.getText();
        }
        return uid;
    }

    public void setPassword(String pwd) {
        if (passwordText != null) {
            passwordText.setText(pwd);
        }
    }

    public String getPassword() {
        String pwd = ""; //$NON-NLS-1$
        if (passwordText != null) {
            pwd = passwordText.getText();
        }
        return pwd;
    }

    public void setConnectionInfo(ConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
        if (this.connectionInfo != null){
            setUserID(this.connectionInfo.getUserName());           
        }
    }

    public IWizardPage getNextPage() {
        IWizardPage nextPage = null;
        if (connectionInfo != null) {
            connectionInfo.setUserName(this.getUserID());
            connectionInfo.setPassword(this.getPassword());
            if (ConnectionUtils.openConnectionWithProgress(connectionInfo, false,
                    this.getWizard().getContainer())) {
                nextPage = super.getNextPage();
            }
        }
        return nextPage;
    }

    public boolean canFlipToNextPage() {
        return isPageComplete();
    }
    
    public void setVisible(boolean visible){
        super.setVisible(visible);
        if (visible){
            if (getUserID().equals("")){ //$NON-NLS-1$
                userIdCombo.setFocus();
            } else{      
                passwordText.setFocus();
            }
        }
    }
    
    /** Implements the Listener interface. */
    public void handleEvent(Event e){
        if (getUserID().equals("")){ //$NON-NLS-1$
            setMessage(resource.queryString("_UI_ERROR_MESSAGE_USER_ID_REQUIRED")); //$NON-NLS-1$
            setPageComplete(false);
        } else {
            setPageComplete(true);
            setMessage(null);
        }
    }
}