/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.editor.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.core.search.pattern.QualifiedName;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSearchListDialogConfiguration;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.common.ui.internal.search.dialogs.IComponentDescriptionProvider;
import org.eclipse.wst.common.ui.internal.search.dialogs.IComponentSearchListProvider;
import org.eclipse.wst.common.ui.internal.search.dialogs.ScopedComponentSearchListDialog;
import org.eclipse.wst.xsd.ui.internal.adt.edit.IComponentDialog;
import org.eclipse.wst.xsd.ui.internal.editor.Messages;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.editor.search.XSDComponentDescriptionProvider;
import org.eclipse.wst.xsd.ui.internal.editor.search.XSDElementsSearchListProvider;
import org.eclipse.wst.xsd.ui.internal.editor.search.XSDTypesSearchListProvider;
import org.eclipse.xsd.XSDSchema;

public class XSDSearchListDialogDelegate
implements IComponentDialog {
    public static final QualifiedName TYPE_META_NAME = new QualifiedName("http://www.w3.org/2001/XMLSchema", "type");
    public static final QualifiedName ELEMENT_META_NAME = new QualifiedName("http://www.w3.org/2001/XMLSchema", "element");
    protected ComponentSpecification selection;
    protected IFile currentFile;
    protected XSDSchema[] schemas;
    protected QualifiedName metaName;
    protected boolean showComplexTypes = true;

    public XSDSearchListDialogDelegate(QualifiedName metaName, IFile currentFile, XSDSchema[] schemas) {
        this.metaName = metaName;
        this.currentFile = currentFile;
        this.schemas = schemas;
    }

    public ComponentSpecification getSelectedComponent() {
        return this.selection;
    }

    public void setInitialSelection(ComponentSpecification componentSpecification) {
    }

    public void showComplexTypes(boolean value) {
        this.showComplexTypes = value;
    }

    public int createAndOpen() {
        Shell shell = XSDEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        int returnValue = 1;
        ScopedComponentSearchListDialog dialog = null;
        if (this.metaName == ELEMENT_META_NAME) {
            XSDComponentDescriptionProvider descriptionProvider = new XSDComponentDescriptionProvider();
            XSDElementsSearchListProvider searchListProvider = new XSDElementsSearchListProvider(this.currentFile, this.schemas);
            ComponentSearchListDialogConfiguration configuration = new ComponentSearchListDialogConfiguration();
            configuration.setDescriptionProvider((IComponentDescriptionProvider)descriptionProvider);
            configuration.setSearchListProvider((IComponentSearchListProvider)searchListProvider);
            configuration.setFilterLabelText(Messages._UI_LABEL_NAME_SEARCH_FILTER_TEXT);
            configuration.setListLabelText(Messages._UI_LABEL_ELEMENTS_COLON);
            dialog = new ScopedComponentSearchListDialog(shell, Messages._UI_LABEL_SET_ELEMENT_REFERENCE, configuration);
        } else if (this.metaName == TYPE_META_NAME) {
            XSDComponentDescriptionProvider descriptionProvider = new XSDComponentDescriptionProvider();
            XSDTypesSearchListProvider searchListProvider = new XSDTypesSearchListProvider(this.currentFile, this.schemas);
            if (!this.showComplexTypes) {
                searchListProvider.showComplexTypes(false);
            }
            ComponentSearchListDialogConfiguration configuration = new ComponentSearchListDialogConfiguration();
            configuration.setDescriptionProvider((IComponentDescriptionProvider)descriptionProvider);
            configuration.setSearchListProvider((IComponentSearchListProvider)searchListProvider);
            configuration.setFilterLabelText(Messages._UI_LABEL_NAME_SEARCH_FILTER_TEXT);
            configuration.setListLabelText(Messages._UI_LABEL_TYPES_COLON);
            dialog = new ScopedComponentSearchListDialog(shell, Messages._UI_LABEL_SET_TYPE, configuration);
        }
        if (dialog != null) {
            dialog.setCurrentResource((IResource)this.currentFile);
            dialog.setBlockOnOpen(true);
            dialog.create();
            returnValue = dialog.open();
            if (returnValue == 0) {
                this.selection = dialog.getSelectedComponent();
            }
        }
        return returnValue;
    }
}

