/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.tasks;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.SSECoreMessages;
import org.eclipse.wst.sse.core.internal.SSECorePlugin;
import org.eclipse.wst.sse.core.internal.tasks.WorkspaceTaskScanner;
import org.eclipse.wst.sse.core.utils.StringUtils;

class TaskScanningJob
extends Job {
    static final int JOB_DELAY_DELTA = 500;
    private static final int JOB_DELAY_PROJECT = 1000;
    static final String TASK_TAG_PROJECTS_ALREADY_SCANNED = "task-tag-projects-already-scanned";
    private List fQueue = new ArrayList();
    private final String OSGI_FRAMEWORK_ID = "org.eclipse.osgi";

    TaskScanningJob() {
        super(SSECoreMessages.TaskScanner_0);
        this.setPriority(50);
        this.setSystem(false);
        SSECorePlugin.getDefault().getPluginPreferences().setDefault(TASK_TAG_PROJECTS_ALREADY_SCANNED, "");
    }

    synchronized void addDelta(IResourceDelta delta) {
        this.fQueue.add(delta);
        if (Logger.DEBUG_TASKSJOB) {
            String kind = null;
            switch (delta.getKind()) {
                case 1: {
                    kind = " [IResourceDelta.ADDED]";
                    break;
                }
                case 4: {
                    kind = " [IResourceDelta.CHANGED]";
                    break;
                }
                case 2: {
                    kind = " [IResourceDelta.REMOVED]";
                    break;
                }
                case 8: {
                    kind = " [IResourceDelta.ADDED_PHANTOM]";
                    break;
                }
                case 16: {
                    kind = " [IResourceDelta.REMOVED_PHANTOM]";
                }
            }
            System.out.println("Adding delta " + delta.getFullPath() + kind);
        }
        this.schedule(500L);
    }

    synchronized void addProject(IProject project) {
        if (this.isEnabledProject((IResource)project)) {
            this.fQueue.add(project);
            if (Logger.DEBUG_TASKSJOB) {
                System.out.println("Adding project " + project.getName());
            }
            this.schedule(1000L);
        }
    }

    boolean frameworkIsShuttingDown() {
        boolean shuttingDown;
        boolean bl = shuttingDown = !Platform.isRunning() || Platform.getBundle((String)"org.eclipse.osgi").getState() == 16;
        if (Logger.DEBUG_TASKSJOB && shuttingDown) {
            System.out.println("TaskScanningJob: system is shutting down!");
        }
        return shuttingDown;
    }

    private boolean isEnabledProject(IResource project) {
        String[] projectsScanned = StringUtils.unpack(SSECorePlugin.getDefault().getPluginPreferences().getString(TASK_TAG_PROJECTS_ALREADY_SCANNED));
        boolean shouldScan = true;
        String name = project.getName();
        int j = 0;
        while (shouldScan && j < projectsScanned.length) {
            if (projectsScanned[j].equals(name)) {
                if (Logger.DEBUG_TASKSJOB) {
                    System.out.println("Scanning Job skipping " + project.getName());
                }
                shouldScan = false;
            }
            ++j;
        }
        return shouldScan;
    }

    synchronized List retrieveQueue() {
        List queue = this.fQueue;
        this.fQueue = new ArrayList();
        return queue;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this.frameworkIsShuttingDown()) {
            return Status.CANCEL_STATUS;
        }
        this.validateRememberedProjectList(TASK_TAG_PROJECTS_ALREADY_SCANNED);
        IStatus status = null;
        List currentQueue = this.retrieveQueue();
        ArrayList<Status> errors = null;
        int ticks = currentQueue.size();
        String taskName = null;
        taskName = Logger.DEBUG_TASKSJOB ? "Scanning (" + ticks + " work items)" : SSECoreMessages.TaskScanningJob_0;
        monitor.beginTask(taskName, ticks);
        SubProgressMonitor scanMonitor = null;
        while (!currentQueue.isEmpty()) {
            Object o = currentQueue.remove(0);
            if (this.frameworkIsShuttingDown()) {
                return Status.CANCEL_STATUS;
            }
            try {
                scanMonitor = new SubProgressMonitor(monitor, 1);
                if (o instanceof IResourceDelta) {
                    WorkspaceTaskScanner.getInstance().scan((IResourceDelta)o, (IProgressMonitor)scanMonitor);
                    continue;
                }
                if (!(o instanceof IProject)) continue;
                WorkspaceTaskScanner.getInstance().scan((IProject)o, (IProgressMonitor)scanMonitor);
                String[] projectsPreviouslyScanned = StringUtils.unpack(SSECorePlugin.getDefault().getPluginPreferences().getString(TASK_TAG_PROJECTS_ALREADY_SCANNED));
                String[] updatedProjects = new String[projectsPreviouslyScanned.length + 1];
                updatedProjects[projectsPreviouslyScanned.length] = ((IResource)o).getName();
                System.arraycopy(projectsPreviouslyScanned, 0, updatedProjects, 0, projectsPreviouslyScanned.length);
                SSECorePlugin.getDefault().getPluginPreferences().setValue(TASK_TAG_PROJECTS_ALREADY_SCANNED, StringUtils.pack(updatedProjects));
            }
            catch (Exception e) {
                if (errors == null) {
                    errors = new ArrayList<Status>();
                }
                errors.add(new Status(4, "org.eclipse.wst.sse.core", 4, "", (Throwable)e));
            }
        }
        monitor.done();
        if (errors == null || errors.isEmpty()) {
            status = Status.OK_STATUS;
        } else if (errors.size() == 1) {
            status = (IStatus)errors.get(0);
        } else {
            IStatus[] statii = errors.toArray(new IStatus[errors.size()]);
            status = new MultiStatus("org.eclipse.wst.sse.core", 4, statii, SSECoreMessages.TaskScanningJob_1, null);
        }
        SSECorePlugin.getDefault().savePluginPreferences();
        return status;
    }

    private void validateRememberedProjectList(String preferenceName) {
        String[] rememberedProjectNames = StringUtils.unpack(SSECorePlugin.getDefault().getPluginPreferences().getString(preferenceName));
        IProject[] workspaceProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        String[] projectNames = new String[workspaceProjects.length];
        int i = 0;
        while (i < projectNames.length) {
            projectNames[i] = workspaceProjects[i].getName();
            ++i;
        }
        ArrayList<String> projectNamesToRemember = new ArrayList<String>(rememberedProjectNames.length);
        int i2 = 0;
        while (i2 < rememberedProjectNames.length) {
            boolean rememberedProjectExists = false;
            int j = 0;
            while (!rememberedProjectExists && j < projectNames.length) {
                if (rememberedProjectNames[i2].equals(projectNames[j])) {
                    rememberedProjectExists = true;
                }
                ++j;
            }
            if (rememberedProjectExists) {
                projectNamesToRemember.add(rememberedProjectNames[i2]);
            } else if (Logger.DEBUG_TASKSJOB) {
                System.out.println("Removing " + rememberedProjectNames[i2] + " removed from " + preferenceName);
            }
            ++i2;
        }
        if (projectNamesToRemember.size() != rememberedProjectNames.length) {
            SSECorePlugin.getDefault().getPluginPreferences().setValue(preferenceName, StringUtils.pack(projectNamesToRemember.toArray(new String[projectNamesToRemember.size()])));
        }
    }
}

