/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.derby.ddl;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.rdb.internal.core.rte.fe.GenericDdlBuilder;
import org.eclipse.wst.rdb.internal.models.sql.expressions.SearchCondition;
import org.eclipse.wst.rdb.internal.models.sql.expressions.ValueExpression;
import org.eclipse.wst.rdb.internal.models.sql.routines.Parameter;
import org.eclipse.wst.rdb.internal.models.sql.routines.ParameterMode;
import org.eclipse.wst.rdb.internal.models.sql.routines.Procedure;
import org.eclipse.wst.rdb.internal.models.sql.routines.Routine;
import org.eclipse.wst.rdb.internal.models.sql.routines.RoutineResultTable;
import org.eclipse.wst.rdb.internal.models.sql.routines.Source;
import org.eclipse.wst.rdb.internal.models.sql.routines.UserDefinedFunction;
import org.eclipse.wst.rdb.internal.models.sql.schema.GenerateType;
import org.eclipse.wst.rdb.internal.models.sql.schema.IdentitySpecifier;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;
import org.eclipse.wst.rdb.internal.models.sql.schema.TypedElement;
import org.eclipse.wst.rdb.internal.models.sql.statements.SQLStatement;
import org.eclipse.wst.rdb.internal.models.sql.tables.ActionGranularityType;
import org.eclipse.wst.rdb.internal.models.sql.tables.ActionTimeType;
import org.eclipse.wst.rdb.internal.models.sql.tables.Column;
import org.eclipse.wst.rdb.internal.models.sql.tables.Trigger;

public class DerbyDdlBuilder
extends GenericDdlBuilder {
    protected static final String IN = "IN";
    protected static final String OUT = "OUT";
    protected static final String INOUT = "INOUT";
    protected static final String LOCATOR = "LOCATOR";
    protected static final String EXTERNAL = "EXTERNAL";
    protected static final String RETURNS = "RETURNS";
    protected static final String CAST = "CAST";
    protected static final String FROM = "FROM";
    protected static final String COMMENT = "COMMENT";
    protected static final String IS = "IS";
    protected static final String COLUMN = "COLUMN";
    protected static final String SCHEMA = "SCHEMA";
    protected static final String DB2SQL = "DB2SQL";
    protected static final String MODE = "MODE";

    public String createProcedure(Procedure procedure, boolean quoteIdentifiers, boolean qualifyNames) {
        procedure.getSchema().getDatabase();
        String text = "CREATE PROCEDURE " + this.getName((Routine)procedure, quoteIdentifiers, qualifyNames) + " " + "(" + this.getParameters((Routine)procedure) + ")";
        text = String.valueOf(text) + NEWLINE + "\t" + "LANGUAGE " + procedure.getLanguage();
        text = String.valueOf(text) + this.getExternalNameOption((Routine)procedure, quoteIdentifiers, qualifyNames);
        text = String.valueOf(text) + this.getParameterStyleOption((Routine)procedure);
        return text;
    }

    public String createUserDefinedFunction(UserDefinedFunction function, boolean quoteIdentifiers, boolean qualifyNames) {
        function.getSchema().getDatabase();
        String text = "CREATE FUNCTION " + this.getName((Routine)function, quoteIdentifiers, qualifyNames);
        Source source = function.getSource();
        if (source != null) {
            text = String.valueOf(text) + source.getBody();
        }
        text = String.valueOf(text) + this.getExternalNameOption((Routine)function, quoteIdentifiers, qualifyNames);
        return text;
    }

    public String dropProcedure(Procedure procedure, boolean quoteIdentifiers, boolean qualifyNames) {
        procedure.getSchema().getDatabase();
        return "DROP PROCEDURE " + this.getName((Routine)procedure, quoteIdentifiers, qualifyNames);
    }

    public String dropFunction(UserDefinedFunction function, boolean quoteIdentifiers, boolean qualifyNames) {
        function.getSchema().getDatabase();
        return "DROP FUNCTION " + this.getName((Routine)function, quoteIdentifiers, qualifyNames);
    }

    public String createSchema(Schema schema, boolean quoteIdentifiers, boolean qualifyNames) {
        String statement = "CREATE SCHEMA " + this.getName(schema, quoteIdentifiers, qualifyNames);
        return statement;
    }

    public String dropSchema(Schema schema, boolean quoteIdentifiers, boolean qualifyNames) {
        return "DROP SCHEMA " + this.getName(schema, quoteIdentifiers, qualifyNames) + "RESTRICT";
    }

    protected String getColumnString(Column column, boolean quoteIdentifiers) {
        String columnName = column.getName();
        if (quoteIdentifiers) {
            columnName = this.getDoubleQuotedString(columnName);
        }
        String columnString = String.valueOf(columnName) + " " + this.getDataTypeString((TypedElement)column, column.getTable().getSchema());
        String defaultValue = column.getDefaultValue();
        if (defaultValue != null) {
            columnString = String.valueOf(columnString) + " " + "DEFAULT" + " " + defaultValue;
        }
        if (!column.isNullable()) {
            columnString = String.valueOf(columnString) + " " + "NOT" + " " + "NULL";
        }
        IdentitySpecifier spec = column.getIdentitySpecifier();
        ValueExpression v = column.getGenerateExpression();
        if (spec != null) {
            GenerateType generateType = spec.getGenerationType();
            columnString = generateType == GenerateType.ALWAYS_GENERATED_LITERAL ? String.valueOf(columnString) + " GENERATED ALWAYS AS IDENTITY " : String.valueOf(columnString) + " GENERATED BY DEFAULT AS IDENTITY ";
            columnString = String.valueOf(columnString) + " (" + this.getIdentityString(spec) + ")";
        } else if (v != null) {
            columnString = String.valueOf(columnString) + " GENERATED ALWAYS AS " + v.getSQL();
        }
        return columnString;
    }

    protected String getIdentityString(IdentitySpecifier identitySpecifier) {
        String clause = "START WITH " + identitySpecifier.getStartValue() + " ,INCREMENT BY " + identitySpecifier.getIncrement();
        return clause;
    }

    protected String getParameters(Routine routine) {
        String parameters = "";
        Iterator it = routine.getParameters().iterator();
        while (it.hasNext()) {
            Parameter p = (Parameter)it.next();
            ParameterMode mode = p.getMode();
            if (mode == ParameterMode.INOUT_LITERAL) {
                parameters = String.valueOf(parameters) + "INOUT ";
            } else if (mode == ParameterMode.OUT_LITERAL) {
                parameters = String.valueOf(parameters) + "OUT ";
            }
            String name = p.getName();
            if (name != null && name.length() != 0) {
                parameters = String.valueOf(parameters) + p.getName() + " ";
            }
            parameters = String.valueOf(parameters) + this.getDataTypeString((TypedElement)p, routine.getSchema());
            if (p.isLocator()) {
                parameters = String.valueOf(parameters) + " AS LOCATOR";
            }
            if (!it.hasNext()) continue;
            parameters = String.valueOf(parameters) + "," + NEWLINE + "\t" + "\t";
        }
        return parameters;
    }

    protected String getExternalNameOption(Routine routine, boolean quoteIdentifiers, boolean qualifyNames) {
        String option = String.valueOf(NEWLINE) + "\t" + EXTERNAL;
        String externalName = routine.getExternalName();
        if (externalName != null && externalName.length() != 0) {
            String schemaName = routine.getSchema().getName();
            if (routine.getLanguage().equalsIgnoreCase("JAVA")) {
                externalName = this.getSingleQuotedString(externalName);
            } else {
                if (quoteIdentifiers) {
                    externalName = this.getDoubleQuotedString(externalName);
                    schemaName = this.getDoubleQuotedString(schemaName);
                }
                if (qualifyNames) {
                    externalName = String.valueOf(schemaName) + "." + externalName;
                }
            }
            option = String.valueOf(option) + " NAME " + externalName;
        }
        return option;
    }

    protected String getParameterStyleOption(Routine routine) {
        return String.valueOf(NEWLINE) + "\t" + "PARAMETER STYLE " + routine.getParameterStyle();
    }

    protected String getFunctionReturnsClause(UserDefinedFunction function) {
        if (function.getReturnScaler() != null) {
            Parameter scaler = function.getReturnScaler();
            String text = "RETURNS " + this.getDataTypeString((TypedElement)scaler, function.getSchema());
            if (function.getReturnCast() != null) {
                Parameter cast = function.getReturnCast();
                text = String.valueOf(text) + " CAST FROM " + this.getDataTypeString((TypedElement)cast, function.getSchema());
            }
            return text;
        }
        if (function.getReturnTable() != null) {
            RoutineResultTable resultTable = function.getReturnTable();
            String text = "RETURNS TABLE (";
            Iterator it = resultTable.getColumns().iterator();
            while (it.hasNext()) {
                Column c = (Column)it.next();
                text = String.valueOf(text) + c.getName() + " " + this.getDataTypeString((TypedElement)c, function.getSchema());
                if (!it.hasNext()) continue;
                text = String.valueOf(text) + ", ";
            }
            text = String.valueOf(text) + ")";
            return text;
        }
        Parameter parameter = function.getReturnCast();
        if (parameter != null) {
            return parameter.getName();
        }
        return null;
    }

    protected String getName(Schema schema, boolean quoteIdentifiers, boolean qualifyNames) {
        String schemaName = schema.getName();
        if (quoteIdentifiers) {
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        return schemaName;
    }

    public String createTrigger(Trigger trigger, boolean quoteIdentifiers, boolean qualifyNames) {
        String c;
        String statement = "CREATE TRIGGER " + this.getName(trigger, quoteIdentifiers, qualifyNames) + " ";
        ActionTimeType actionTime = trigger.getActionTime();
        if (actionTime == ActionTimeType.AFTER_LITERAL) {
            statement = String.valueOf(statement) + NEWLINE + "\t" + "AFTER";
        } else if (actionTime == ActionTimeType.BEFORE_LITERAL) {
            statement = String.valueOf(statement) + NEWLINE + "\t" + "NO" + " " + "CASCADE" + " " + "BEFORE";
        } else if (actionTime == ActionTimeType.INSTEADOF_LITERAL) {
            statement = String.valueOf(statement) + NEWLINE + "\t" + "INSTEAD OF";
        }
        statement = String.valueOf(statement) + " ";
        if (trigger.isDeleteType()) {
            statement = String.valueOf(statement) + "DELETE";
        } else if (trigger.isInsertType()) {
            statement = String.valueOf(statement) + "INSERT";
        } else if (trigger.isUpdateType()) {
            statement = String.valueOf(statement) + "UPDATE";
            EList updateColumns = trigger.getTriggerColumn();
            if (!updateColumns.isEmpty()) {
                statement = String.valueOf(statement) + " OF ";
                Iterator it = updateColumns.iterator();
                while (it.hasNext()) {
                    Column column = (Column)it.next();
                    statement = String.valueOf(statement) + column.getName();
                    if (!it.hasNext()) continue;
                    statement = String.valueOf(statement) + ", ";
                }
            }
        }
        statement = String.valueOf(statement) + " ON " + this.getName(trigger.getSubjectTable(), quoteIdentifiers, qualifyNames) + NEWLINE;
        String newRow = trigger.getNewRow();
        String oldRow = trigger.getOldRow();
        String newTable = trigger.getNewTable();
        String oldTable = trigger.getOldTable();
        if (newRow != null && newRow.length() != 0) {
            statement = String.valueOf(statement) + "\tREFERENCING NEW AS " + newRow + NEWLINE;
        }
        if (oldRow != null && oldRow.length() != 0) {
            statement = String.valueOf(statement) + "\tREFERENCING OLD AS " + oldRow + NEWLINE;
        }
        if (newTable != null && newTable.length() != 0) {
            statement = String.valueOf(statement) + "\tREFERENCING NEW_TABLE AS " + newTable + NEWLINE;
        }
        if (oldTable != null && oldTable.length() != 0) {
            statement = String.valueOf(statement) + "\tREFERENCING OLD_TABLE AS " + oldTable + NEWLINE;
        }
        statement = trigger.getActionGranularity() == ActionGranularityType.ROW_LITERAL ? String.valueOf(statement) + "\tFOR EACH ROW" : String.valueOf(statement) + "\tFOR EACH STATEMENT";
        statement = String.valueOf(statement) + " MODE DB2SQL" + NEWLINE;
        SearchCondition condition = trigger.getWhen();
        if (condition != null && (c = condition.getSQL()) != null && c.trim().length() != 0) {
            statement = String.valueOf(statement) + "WHEN (" + condition.getSQL() + ")" + NEWLINE;
        }
        Iterator it = trigger.getActionStatement().iterator();
        while (it.hasNext()) {
            SQLStatement s = (SQLStatement)it.next();
            statement = String.valueOf(statement) + s.getSQL();
        }
        return statement;
    }
}

