/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.ui;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.Logger;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletBuildUtility;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletExtensionUtil;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletRuntime;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.ui.DialogPanel;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.ui.Messages;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.ui.PropertyPreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;

public class XDocletPreferencePage
extends PropertyPreferencePage
implements SelectionListener {
    DialogPanel panel;
    private Map fData;
    private XDocletRuntime[] runtimes;

    public void applyData(Object data) {
        if (data instanceof Map) {
            this.fData = (Map)data;
        }
    }

    protected Map getData() {
        return this.fData;
    }

    protected boolean useProjectSettings() {
        return this.isProjectPreferencePage();
    }

    protected boolean isProjectPreferencePage() {
        return this.fProject != null;
    }

    protected IProject getProject() {
        return this.fProject;
    }

    public void init(IWorkbench workbench) {
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected Composite createContainer(Composite parent) {
        this.panel = new DialogPanel(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        this.panel.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        this.panel.setLayoutData(gridData);
        return this.panel;
    }

    protected Control createContents(Composite parent) {
        this.runtimes = XDocletExtensionUtil.getRuntimes();
        Composite composite = this.createContainer(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        Composite defPanel = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        defPanel.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        defPanel.setLayoutData((Object)gridData);
        Label label = new Label(defPanel, 64);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.label_set_xdoclet_runtime_preference);
        int numCont = 3;
        if (this.isProjectPreferencePage()) {
            numCont = 4;
        }
        this.panel.preferences = new Control[numCont];
        this.panel.fActive = new Button[numCont];
        if (this.isProjectPreferencePage()) {
            this.panel.preferences[3] = this.panel.createLabeledCheck(3, this.getStore().getBooleanPropertyNoGlobal("XDOCLETUSEGLOBAL"), Messages.label_global_pref, Messages.desc_global_pref, this.getStore().getBooleanPropertyNoGlobal("XDOCLETUSEGLOBAL"), defPanel);
        }
        this.panel.preferences[0] = this.panel.createLabeledCheck(0, false, this.getStore().getBooleanPropertyNoGlobal("XDOCLETBUILDERACTIVE"), Messages.label_enable_xdoclet_builder, Messages.desc_enable_xdoclet_builder, this.getStore().getBooleanPropertyNoGlobal("XDOCLETBUILDERACTIVE"), defPanel);
        this.panel.preferences[2] = this.panel.createLabeledPath(2, true, Messages.label_xdoclet_home, Messages.desc_xdoclet_home, this.getStore().getPropertyNoGlobal("XDOCLETHOME"), defPanel);
        String[] versions = new String[this.runtimes.length];
        int i = 0;
        while (i < versions.length) {
            versions[i] = this.runtimes[i].getVersion();
            ++i;
        }
        this.panel.preferences[1] = this.panel.createLabeledCombo(1, false, true, Messages.label_xdoclet_version, Messages.desc_xdoclet_version, this.getStore().getPropertyNoGlobal("XDOCLETVERSION"), versions, defPanel);
        final Text xDocletPath = (Text)this.panel.preferences[2];
        final Combo xDocletVersion = (Combo)this.panel.preferences[1];
        this.validateCurrentPreferences(xDocletPath, xDocletVersion);
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XDocletPreferencePage.this.validateCurrentPreferences(xDocletPath, xDocletVersion);
            }
        };
        xDocletPath.addModifyListener(listener);
        xDocletVersion.addModifyListener(listener);
        this.applyDialogFont(composite);
        return composite;
    }

    public boolean performOk() {
        Combo combo;
        int itemIndex;
        String itemValue = "";
        itemValue = ((Text)this.panel.preferences[2]).getText();
        this.getStore().setProperty("XDOCLETHOME", itemValue);
        if (this.isProjectPreferencePage()) {
            this.getStore().setProperty("XDOCLETUSEGLOBAL", ((Button)this.panel.preferences[3]).getSelection());
        }
        if ((itemIndex = (combo = (Combo)this.panel.preferences[1]).getSelectionIndex()) == -1) {
            this.getStore().save();
            return false;
        }
        itemValue = combo.getItem(combo.getSelectionIndex());
        this.getStore().setProperty("XDOCLETVERSION", itemValue);
        this.getStore().setProperty("XDOCLETBUILDERACTIVE", ((Button)this.panel.preferences[0]).getSelection());
        this.getStore().save();
        try {
            XDocletBuildUtility.runNecessaryBuilders((IProgressMonitor)new NullProgressMonitor(), (IProject)this.getElement());
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        return super.performOk();
    }

    protected void performDefaults() {
        this.getStore().clear();
        ((Button)this.panel.preferences[0]).setSelection(this.getStore().getBooleanPropertyNoGlobal("XDOCLETBUILDERACTIVE"));
        ((Combo)this.panel.preferences[1]).select(0);
        ((Text)this.panel.preferences[2]).setText(this.getStore().getPropertyNoGlobal("XDOCLETHOME"));
        if (this.isProjectPreferencePage()) {
            ((Button)this.panel.preferences[3]).setSelection(this.getStore().getBooleanPropertyNoGlobal("XDOCLETUSEGLOBAL"));
        }
        this.getStore().save();
        try {
            XDocletBuildUtility.runNecessaryBuilders((IProgressMonitor)new NullProgressMonitor(), (IProject)this.getElement());
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        super.performDefaults();
    }

    protected void validateCurrentPreferences(Text xDocletPath, Combo xDocletVersion) {
        int selection = xDocletVersion.getSelectionIndex();
        if (selection < 0 || selection >= this.runtimes.length) {
            return;
        }
        this.runtimes[selection].setHome(xDocletPath.getText());
        IStatus[] result = this.runtimes[selection].validate();
        this.setErrorMessage(null);
        if (result.length > 0) {
            this.setErrorMessage(result[0].getMessage());
        } else {
            this.setMessage("All libraries found", 1);
        }
    }
}

