/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.engine;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.wst.ws.internal.explorer.platform.engine.data.ActionDescriptor;
import org.eclipse.wst.ws.internal.explorer.platform.engine.data.ScenarioDescriptor;
import org.eclipse.wst.ws.internal.explorer.platform.engine.data.TransactionDescriptor;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ActionDataParser {
    private Document doc;

    public ScenarioDescriptor parseScenario(Element e) {
        ScenarioDescriptor scenarioDescriptor = new ScenarioDescriptor();
        NodeList transactions = e.getElementsByTagName("transaction");
        TransactionDescriptor[] transactionDescriptors = new TransactionDescriptor[transactions.getLength()];
        int i = 0;
        while (i < transactionDescriptors.length) {
            transactionDescriptors[i] = this.parseTransaction((Element)transactions.item(i));
            ++i;
        }
        scenarioDescriptor.setTransactionDescriptors(transactionDescriptors);
        return scenarioDescriptor;
    }

    public TransactionDescriptor parseTransaction(Element e) {
        TransactionDescriptor transactionDescriptor = new TransactionDescriptor();
        NodeList actions = e.getElementsByTagName("action");
        ActionDescriptor[] actionDescriptors = new ActionDescriptor[actions.getLength()];
        int i = 0;
        while (i < actionDescriptors.length) {
            actionDescriptors[i] = this.parseAction((Element)actions.item(i));
            ++i;
        }
        transactionDescriptor.setActionDescriptors(actionDescriptors);
        return transactionDescriptor;
    }

    public ActionDescriptor parseAction(Element e) {
        ActionDescriptor actionDescriptor = new ActionDescriptor();
        actionDescriptor.setId(e.getAttribute("id"));
        try {
            actionDescriptor.setAttempts(Integer.parseInt(e.getAttribute("attempts")));
        }
        catch (Throwable throwable) {
            actionDescriptor.setAttempts(1);
        }
        actionDescriptor.setStatusId(e.getAttribute("statusId"));
        Hashtable<String, Object> propertiesTable = new Hashtable<String, Object>();
        NodeList properties = e.getElementsByTagName("property");
        int i = 0;
        while (i < properties.getLength()) {
            Element property = (Element)properties.item(i);
            String name = property.getAttribute("name");
            NodeList valueList = property.getElementsByTagName("value");
            if (valueList.getLength() > 1) {
                String[] values = new String[valueList.getLength()];
                int j = 0;
                while (j < values.length) {
                    Element value = (Element)valueList.item(j);
                    Node textNode = value.getFirstChild();
                    values[j] = textNode != null ? textNode.getNodeValue().trim() : "";
                    ++j;
                }
                propertiesTable.put(name, values);
            } else {
                Node textNode = ((Element)valueList.item(0)).getFirstChild();
                propertiesTable.put(name, textNode != null ? textNode.getNodeValue().trim() : "");
            }
            ++i;
        }
        actionDescriptor.setProperties(propertiesTable);
        NodeList statusList = e.getElementsByTagName("status");
        int i2 = 0;
        while (i2 < statusList.getLength()) {
            Element status = (Element)statusList.item(i2);
            CDATASection cData = (CDATASection)status.getFirstChild();
            actionDescriptor.addStatus(cData.getData());
            ++i2;
        }
        return actionDescriptor;
    }

    public Element toElement(ScenarioDescriptor scenarioDescriptor) {
        try {
            Document document = this.getDocument();
            Element scenarioElement = document.createElement("scenario");
            TransactionDescriptor[] transactionDescriptors = scenarioDescriptor.getTransactionDescriptors();
            int i = 0;
            while (i < transactionDescriptors.length) {
                Element transactionElement = this.toElement(transactionDescriptors[i]);
                if (transactionElement != null) {
                    scenarioElement.appendChild(transactionElement);
                }
                ++i;
            }
            return scenarioElement;
        }
        catch (DOMException dOMException) {
            return null;
        }
    }

    public Element toElement(TransactionDescriptor transactionDescriptor) {
        try {
            Document document = this.getDocument();
            Element transactionElement = document.createElement("transaction");
            ActionDescriptor[] actionDescriptors = transactionDescriptor.getActionDescriptors();
            int i = 0;
            while (i < actionDescriptors.length) {
                Element actionElement = this.toElement(actionDescriptors[i]);
                if (actionElement != null) {
                    transactionElement.appendChild(actionElement);
                }
                ++i;
            }
            return transactionElement;
        }
        catch (DOMException dOMException) {
            return null;
        }
    }

    public Element toElement(ActionDescriptor actionDescriptor) {
        try {
            List status;
            Hashtable properties;
            Document document = this.getDocument();
            Element actionElement = document.createElement("action");
            actionElement.setAttribute("id", actionDescriptor.getId());
            actionElement.setAttribute("attempts", String.valueOf(actionDescriptor.getAttempts()));
            String statusId = actionDescriptor.getStatusId();
            if (statusId != null) {
                actionElement.setAttribute("statusId", statusId);
            }
            if ((properties = actionDescriptor.getProperties()) != null) {
                Iterator it = properties.keySet().iterator();
                while (it.hasNext()) {
                    Object key = it.next();
                    Object value = properties.get(key);
                    Object[] values = value.getClass().isArray() ? (Object[])value : (value instanceof List ? ((List)value).toArray() : new Object[]{value});
                    boolean isAdded = false;
                    Element propertyElement = document.createElement("property");
                    propertyElement.setAttribute("name", key.toString());
                    int i = 0;
                    while (i < values.length) {
                        if (values[i] instanceof String) {
                            Element valueElement = document.createElement("value");
                            valueElement.appendChild(document.createTextNode(values[i].toString()));
                            propertyElement.appendChild(valueElement);
                            isAdded = true;
                        }
                        ++i;
                    }
                    if (!isAdded) continue;
                    actionElement.appendChild(propertyElement);
                }
            }
            if ((status = actionDescriptor.getStatus()) != null) {
                Iterator it = status.iterator();
                while (it.hasNext()) {
                    Element statusElement = document.createElement("status");
                    CDATASection cData = document.createCDATASection(it.next().toString());
                    statusElement.appendChild(cData);
                    actionElement.appendChild(statusElement);
                }
            }
            return actionElement;
        }
        catch (DOMException dOMException) {
            return null;
        }
    }

    private Document getDocument() {
        try {
            if (this.doc == null) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                this.doc = builder.newDocument();
            }
            return this.doc;
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            return null;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
    }
}

