/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.dialogs;

import java.net.MalformedURLException;
import java.text.ParseException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.dialogs.ChooseUrlDialog;
import org.tigris.subversion.subclipse.ui.dialogs.HistoryDialog;
import org.tigris.subversion.subclipse.ui.util.UrlCombo;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SwitchDialog
extends TrayDialog {
    private static final int REVISION_WIDTH_HINT = 40;
    private IResource resource;
    private UrlCombo urlCombo;
    private Text revisionText;
    private Button logButton;
    private Button headButton;
    private Button revisionButton;
    private Button okButton;
    private SVNUrl url;
    private SVNRevision revision;

    public SwitchDialog(Shell parentShell, IResource resource) {
        super(parentShell);
        this.resource = resource;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Policy.bind("SwitchDialog.title"));
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Label urlLabel = new Label(composite, 0);
        urlLabel.setText(Policy.bind("SwitchDialog.url"));
        this.urlCombo = new UrlCombo(composite, this.resource.getProject().getName());
        ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resource);
        try {
            String anUrl = svnResource.getStatus().getUrlString();
            if (anUrl != null) {
                this.urlCombo.setText(anUrl);
            }
        }
        catch (SVNException sVNException) {}
        this.urlCombo.getCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SwitchDialog.this.setOkButtonStatus();
            }
        });
        Button browseButton = new Button(composite, 8);
        browseButton.setText(Policy.bind("SwitchDialog.browse"));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseUrlDialog dialog = new ChooseUrlDialog(SwitchDialog.this.getShell(), SwitchDialog.this.resource);
                if (dialog.open() == 0 && dialog.getUrl() != null) {
                    SwitchDialog.this.urlCombo.setText(dialog.getUrl());
                    SwitchDialog.this.setOkButtonStatus();
                }
            }
        });
        Group revisionGroup = new Group(composite, 0);
        revisionGroup.setText(Policy.bind("SwitchDialog.revision"));
        GridLayout revisionLayout = new GridLayout();
        revisionLayout.numColumns = 3;
        revisionGroup.setLayout((Layout)revisionLayout);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        revisionGroup.setLayoutData((Object)data);
        this.headButton = new Button((Composite)revisionGroup, 16);
        this.headButton.setText(Policy.bind("SwitchDialog.head"));
        data = new GridData();
        data.horizontalSpan = 3;
        this.headButton.setLayoutData((Object)data);
        this.revisionButton = new Button((Composite)revisionGroup, 16);
        this.revisionButton.setText(Policy.bind("SwitchDialog.revision"));
        this.headButton.setSelection(true);
        this.revisionText = new Text((Composite)revisionGroup, 2048);
        data = new GridData();
        data.widthHint = 40;
        this.revisionText.setLayoutData((Object)data);
        this.revisionText.setEnabled(false);
        this.revisionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SwitchDialog.this.setOkButtonStatus();
            }
        });
        this.logButton = new Button((Composite)revisionGroup, 8);
        this.logButton.setText(Policy.bind("MergeDialog.showLog"));
        this.logButton.setEnabled(false);
        this.logButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SwitchDialog.this.showLog();
            }
        });
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SwitchDialog.this.revisionText.setEnabled(SwitchDialog.this.revisionButton.getSelection());
                SwitchDialog.this.logButton.setEnabled(SwitchDialog.this.revisionButton.getSelection());
                SwitchDialog.this.setOkButtonStatus();
                if (SwitchDialog.this.revisionButton.getSelection()) {
                    SwitchDialog.this.revisionText.selectAll();
                    SwitchDialog.this.revisionText.setFocus();
                }
            }
        };
        this.headButton.addSelectionListener((SelectionListener)listener);
        this.revisionButton.addSelectionListener((SelectionListener)listener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.switch_dialog_context");
        return composite;
    }

    protected void showLog() {
        ISVNRemoteFile remoteResource = null;
        try {
            remoteResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resource).getRepository().getRemoteFile(new SVNUrl(this.urlCombo.getText()));
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("MergeDialog.showLog"), (String)e.toString());
            return;
        }
        if (remoteResource == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("MergeDialog.showLog"), (String)(String.valueOf(Policy.bind("MergeDialog.urlError")) + " " + this.urlCombo.getText()));
            return;
        }
        HistoryDialog dialog = new HistoryDialog(this.getShell(), (ISVNRemoteResource)remoteResource);
        if (dialog.open() == 1) {
            return;
        }
        ILogEntry[] selectedEntries = dialog.getSelectedLogEntries();
        if (selectedEntries.length == 0) {
            return;
        }
        this.revisionText.setText(Long.toString(selectedEntries[selectedEntries.length - 1].getRevision().getNumber()));
        this.setOkButtonStatus();
    }

    protected void okPressed() {
        block5: {
            this.urlCombo.saveUrl();
            try {
                this.url = new SVNUrl(this.urlCombo.getText());
                if (this.headButton.getSelection()) {
                    this.revision = SVNRevision.HEAD;
                    break block5;
                }
                try {
                    this.revision = SVNRevision.getRevision((String)this.revisionText.getText().trim());
                }
                catch (ParseException parseException) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("SwitchDialog.title"), (String)Policy.bind("SwitchDialog.invalid"));
                    return;
                }
            }
            catch (MalformedURLException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("SwitchDialog.title"), (String)e.getMessage());
                return;
            }
        }
        super.okPressed();
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.okButton = button;
        }
        return button;
    }

    private void setOkButtonStatus() {
        this.okButton.setEnabled(this.urlCombo.getText().length() > 0 && (this.headButton.getSelection() || this.revisionText.getText().trim().length() > 0));
    }

    public SVNRevision getRevision() {
        return this.revision;
    }

    public SVNUrl getUrl() {
        return this.url;
    }
}

