/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui;

import java.io.File;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;
import org.tigris.subversion.subclipse.core.SVNClientManager;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;

public class Preferences
implements IPropertyChangeListener {
    private IPreferenceStore store;

    public Preferences(IPreferenceStore store) {
        this.store = store;
        store.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void initializePreferences() {
        PreferenceConverter.setDefault((IPreferenceStore)this.store, (String)"pref_console_command_color", (RGB)new RGB(0, 0, 0));
        PreferenceConverter.setDefault((IPreferenceStore)this.store, (String)"pref_console_message_color", (RGB)new RGB(0, 0, 255));
        PreferenceConverter.setDefault((IPreferenceStore)this.store, (String)"pref_console_error_color", (RGB)new RGB(255, 0, 0));
        this.store.setDefault("pref_show_comments", true);
        this.store.setDefault("pref_wrap_comments", true);
        this.store.setDefault("pref_show_paths", true);
        this.store.setDefault("pref_affected_paths_layout", 1);
        this.store.setDefault("pref_affected_paths_layout2", 1);
        this.store.setDefault("pref_console_show_on_message", false);
        this.store.setDefault("pref_console_show_on_error", true);
        this.store.setDefault("pref_console_limit_output", true);
        this.store.setDefault("pref_console_high_water_mark", 500000);
        this.store.setDefault("pref_filetext_decoration", "{added_flag}{dirty_flag}{name} {revision}  {date}  {author}");
        this.store.setDefault("pref_foldertext_decoration", "{external_flag}{added_flag}{dirty_flag}{name} ");
        this.store.setDefault("pref_projecttext_decoration", "{dirty_flag}{name} [{url_short}]");
        this.store.setDefault("pref_added_flag", "");
        this.store.setDefault("pref_dirty_flag", "");
        this.store.setDefault("pref_external_flag", "");
        this.store.setDefault("pref_show_external", true);
        this.store.setDefault("pref_show_added", true);
        this.store.setDefault("pref_show_hasremote", true);
        this.store.setDefault("pref_show_overlaydirty", true);
        this.store.setDefault("pref_show_newresource", true);
        this.store.setDefault("pref_calculate_dirty", true);
        this.store.setDefault("pref_use_font_decorators", false);
        this.store.setDefault("pref_show_syncinfo_as_text", false);
        this.store.setDefault("pref_prompt_on_mixed_tags", true);
        this.store.setDefault("pref_prompt_on_saving_in_sync", true);
        this.store.setDefault("pref_save_dirty_editors", 2);
        this.store.setDefault("pref_show_compare_revision_in_dialog", false);
        this.store.setDefault("pref_show_unadded_resources_on_commit", true);
        this.store.setDefault("pref_select_unadded_resources_on_commit", false);
        this.store.setDefault("pref_remove_unadded_resources_on_replace", true);
        this.store.setDefault("pref_enable_commit_sets", false);
        this.store.setDefault("pref_svninterface", "javahl");
        this.store.setDefault("pref_svnconfigdir", "");
        this.store.setDefault("pref_fetch_change_path_on_Demand", false);
        this.store.setDefault("pref_log_entries_to_fetch", 25);
        this.store.setDefault("pref_stop_on_copy", false);
        this.store.setDefault("pref_merge_use_external", false);
        this.store.setDefault("pref_merge_program_location", "");
        this.store.setDefault("pref_merge_program_parameters", "");
        this.store.setDefault("pref_use_quickdiffannotate", "prompt");
        this.store.setDefault("pref_menu_icon_set", 1);
        this.setSvnClientInterface(this.store.getString("pref_svninterface"));
        this.setSvnClientConfigDir(this.store.getString("pref_svnconfigdir"));
        this.setSvnChangePathOnDemand(this.store.getBoolean("pref_fetch_change_path_on_Demand"));
    }

    private void setSvnClientInterface(String clientInterface) {
        if ("commandline".equals(clientInterface)) {
            clientInterface = "svnkit";
        }
        if ("javasvn".equals(clientInterface)) {
            clientInterface = "svnkit";
        }
        SVNProviderPlugin.getPlugin().getSVNClientManager().setSvnClientInterface(clientInterface);
    }

    private void setSvnClientConfigDir(String configDir) {
        SVNProviderPlugin plugin = SVNProviderPlugin.getPlugin();
        SVNClientManager svnClientManager = plugin.getSVNClientManager();
        if ("".equals(configDir)) {
            svnClientManager.setConfigDir(null);
        } else {
            File configDirFile = new File(configDir);
            svnClientManager.setConfigDir(configDirFile);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property == "pref_svninterface") {
            String newValue = (String)event.getNewValue();
            this.setSvnClientInterface(newValue);
        }
        if (property == "pref_svnconfigdir") {
            String configDir = (String)event.getNewValue();
            this.setSvnClientConfigDir(configDir);
        }
        if (property == "pref_fetch_change_path_on_Demand") {
            boolean fetchChangePathOnDemand = (Boolean)event.getNewValue();
            this.setSvnChangePathOnDemand(fetchChangePathOnDemand);
        }
    }

    private void setSvnChangePathOnDemand(boolean fetchChangePathOnDemand) {
        SVNProviderPlugin plugin = SVNProviderPlugin.getPlugin();
        SVNClientManager svnClientManager = plugin.getSVNClientManager();
        svnClientManager.setFetchChangePathOnDemand(fetchChangePathOnDemand);
    }
}

