/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui.console;

import java.io.File;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.console.IHyperlink;
import org.rubypeople.rdt.internal.debug.ui.console.RubyStackTraceHyperlink;
import org.rubypeople.rdt.internal.ui.util.StackTraceLine;

public class RubyConsoleTracker
implements IConsoleLineTracker {
    private final FileExistanceChecker existanceChecker;
    private IConsole fConsole;

    public RubyConsoleTracker() {
        this(new StandardFileExistanceChecker());
    }

    public RubyConsoleTracker(FileExistanceChecker fileExistanceChecker) {
        this.existanceChecker = fileExistanceChecker;
    }

    public void init(IConsole iConsole) {
        this.fConsole = iConsole;
    }

    public void lineAppended(IRegion iRegion) {
        try {
            int n = iRegion.getOffset();
            int n2 = iRegion.getLength();
            int n3 = 0;
            String string = this.fConsole.getDocument().get(n, n2);
            while (StackTraceLine.isTraceLine((String)string)) {
                StackTraceLine stackTraceLine = new StackTraceLine(string);
                if (!this.existanceChecker.fileExists(stackTraceLine.getFilename())) {
                    return;
                }
                RubyStackTraceHyperlink rubyStackTraceHyperlink = new RubyStackTraceHyperlink(this.fConsole, stackTraceLine);
                this.fConsole.addLink((IHyperlink)rubyStackTraceHyperlink, iRegion.getOffset() + n3 + stackTraceLine.offset(), stackTraceLine.length());
                n3 = stackTraceLine.offset() + stackTraceLine.length();
                string = string.substring(stackTraceLine.offset() + stackTraceLine.length());
                if (!string.startsWith(":in `require':")) continue;
                string = string.substring(14);
                n3 += 14;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    public void dispose() {
        this.fConsole = null;
    }

    public static interface FileExistanceChecker {
        public boolean fileExists(String var1);
    }

    public static class StandardFileExistanceChecker
    implements FileExistanceChecker {
        public boolean fileExists(String string) {
            File file = new File(string);
            return file.exists();
        }
    }
}

