/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.ruby;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.rubypeople.rdt.core.IParent;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.template.ruby.RubyContextType;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.text.ruby.RubyCompletionProposal;
import org.rubypeople.rdt.internal.ui.text.template.contentassist.RubyTemplateAccess;
import org.rubypeople.rdt.internal.ui.text.template.contentassist.TemplateEngine;
import org.rubypeople.rdt.internal.ui.text.template.contentassist.TemplateProposal;
import org.rubypeople.rdt.ui.IWorkingCopyManager;
import org.rubypeople.rdt.ui.text.RubyTextTools;
import org.rubypeople.rdt.ui.text.ruby.IRubyCompletionProposal;

public class RubyCompletionProcessor
extends TemplateCompletionProcessor
implements IContentAssistProcessor {
    private static String[] keywordProposals;
    protected IContextInformationValidator contextInformationValidator = new RubyContextInformationValidator();
    private static String[] preDefinedGlobals;
    private static String[] globalContexts;
    private static String[] KERNEL_METHODS;
    protected String currentPrefix = null;
    protected int cursorPosition = -1;
    private ITextViewer viewer;
    private IWorkingCopyManager fManager;
    private IEditorPart fEditor;
    private TemplateEngine fRubyTemplateEngine;

    static {
        preDefinedGlobals = new String[]{"$!", "$@", "$_", "$.", "$&", "$n", "$~", "$=", "$/", "$\\", "$0", "$*", "$$", "$?", "$:"};
        globalContexts = new String[]{"error message", "position of an error occurrence", "latest read string by `gets'", "latest read number of line by interpreter", "latest matched string by the regexep.", "latest matched string by nth parentheses of regexp.", "data for latest matche for regexp", "whether or not case-sensitive in string matching", "input record separator", "output record separator", "the name of the ruby scpript file", "command line arguments for the ruby scpript", "PID for ruby interpreter", "status of the latest executed child process", "array of paths that ruby interpreter searches for files"};
        KERNEL_METHODS = new String[]{"abort", "at_exit", "autoload", "binding", "block_given?", "callcc", "caller", "catch", "chomp", "chomp!", "chop", "chop!", "eval", "exec", "exit", "exit!", "fail", "fork", "format", "gets", "global_variables", "gsub", "gsub!", "iterator?", "lambda", "load", "local_variables", "loop", "open", "p", "print", "printf", "proc", "putc", "puts", "raise", "rand", "readline", "readlines", "require", "scan", "select", "set_trace_func", "singleton_method_added", "sleep", "split", "sprintf", "srand", "sub", "sub!", "syscall", "system", "test", "throw", "trace_var", "trap", "untrace_var"};
    }

    public RubyCompletionProcessor(IEditorPart iEditorPart) {
        this.fEditor = iEditorPart;
        this.fManager = RubyPlugin.getDefault().getWorkingCopyManager();
        TemplateContextType templateContextType = RubyPlugin.getDefault().getTemplateContextRegistry().getContextType("ruby");
        if (templateContextType == null) {
            templateContextType = new RubyContextType();
            RubyPlugin.getDefault().getTemplateContextRegistry().addContextType(templateContextType);
        }
        this.fRubyTemplateEngine = templateContextType != null ? new TemplateEngine(templateContextType) : null;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer iTextViewer, int n) {
        this.viewer = iTextViewer;
        ITextSelection iTextSelection = (ITextSelection)iTextViewer.getSelectionProvider().getSelection();
        this.cursorPosition = iTextSelection.getOffset() + iTextSelection.getLength();
        ICompletionProposal[] iCompletionProposalArray = this.determineRubyElementProposals(iTextViewer, n);
        List list = this.determineTemplateProposals(iTextViewer, n);
        ICompletionProposal[] iCompletionProposalArray2 = new ICompletionProposal[list.size()];
        int n2 = 0;
        ICompletionProposal[] iCompletionProposalArray3 = list.iterator();
        while (iCompletionProposalArray3.hasNext()) {
            iCompletionProposalArray2[n2] = (ICompletionProposal)iCompletionProposalArray3.next();
            ++n2;
        }
        iCompletionProposalArray3 = this.merge(iCompletionProposalArray, iCompletionProposalArray2);
        ICompletionProposal[] iCompletionProposalArray4 = this.determineKeywordProposals(iTextViewer, n);
        ICompletionProposal[] iCompletionProposalArray5 = this.merge(iCompletionProposalArray3, iCompletionProposalArray4);
        return iCompletionProposalArray5;
    }

    private ICompletionProposal[] merge(ICompletionProposal[] iCompletionProposalArray, ICompletionProposal[] iCompletionProposalArray2) {
        ICompletionProposal[] iCompletionProposalArray3 = new ICompletionProposal[iCompletionProposalArray.length + iCompletionProposalArray2.length];
        System.arraycopy(iCompletionProposalArray, 0, iCompletionProposalArray3, 0, iCompletionProposalArray.length);
        System.arraycopy(iCompletionProposalArray2, 0, iCompletionProposalArray3, iCompletionProposalArray.length, iCompletionProposalArray2.length);
        return iCompletionProposalArray3;
    }

    private ICompletionProposal[] determineRubyElementProposals(ITextViewer iTextViewer, int n) {
        Collection collection = this.getDocumentsRubyElements();
        String string = this.getCurrentPrefix(iTextViewer.getDocument().get(), n);
        string.length();
        ArrayList<CompletionProposal> arrayList = new ArrayList<CompletionProposal>();
        ICompletionProposal[] iCompletionProposalArray = collection.iterator();
        while (iCompletionProposalArray.hasNext()) {
            String string2 = (String)iCompletionProposalArray.next();
            if (!string2.startsWith(string)) continue;
            String string3 = "{0}";
            ContextInformation contextInformation = new ContextInformation(string2, MessageFormat.format(string3, string2));
            arrayList.add(new CompletionProposal(string2.substring(string.length(), string2.length()), n, 0, string2.length() - string.length(), null, string2, (IContextInformation)contextInformation, MessageFormat.format("Ruby keyword: {0}", string2)));
        }
        iCompletionProposalArray = new ICompletionProposal[arrayList.size()];
        arrayList.toArray(iCompletionProposalArray);
        return iCompletionProposalArray;
    }

    private Collection addKernelMethods() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < KERNEL_METHODS.length) {
            arrayList.add(KERNEL_METHODS[n]);
            ++n;
        }
        return arrayList;
    }

    protected Image getImage(Template template) {
        return RubyPluginImages.get("org.rubypeople.rdt.ui.template_obj.gif");
    }

    protected TemplateContextType getContextType(ITextViewer iTextViewer, IRegion iRegion) {
        return RubyTemplateAccess.getDefault().getContextTypeRegistry().getContextType("ruby");
    }

    private List determineTemplateProposals(ITextViewer iTextViewer, int n) {
        TemplateEngine templateEngine = this.fRubyTemplateEngine;
        if (templateEngine != null) {
            IRubyScript iRubyScript = this.fManager.getWorkingCopy(this.fEditor.getEditorInput());
            if (iRubyScript == null) {
                return Collections.EMPTY_LIST;
            }
            templateEngine.reset();
            templateEngine.complete(iTextViewer, n, iRubyScript);
            TemplateProposal[] templateProposalArray = templateEngine.getResults();
            ArrayList<TemplateProposal> arrayList = new ArrayList<TemplateProposal>(Arrays.asList(templateProposalArray));
            IRubyCompletionProposal[] iRubyCompletionProposalArray = this.getKeywordProposals(n);
            if (iRubyCompletionProposalArray.length > 0) {
                ArrayList<TemplateProposal> arrayList2 = new ArrayList<TemplateProposal>();
                if (iRubyCompletionProposalArray.length > 0) {
                    int n2 = 0;
                    while (n2 < templateProposalArray.length) {
                        block8: {
                            TemplateProposal templateProposal = templateProposalArray[n2];
                            String string = templateProposal.getTemplate().getName();
                            int n3 = 0;
                            while (n3 < iRubyCompletionProposalArray.length) {
                                String string2 = iRubyCompletionProposalArray[n3].getDisplayString();
                                if (string.startsWith(string2)) {
                                    templateProposal.setRelevance(iRubyCompletionProposalArray[n3].getRelevance() + 1);
                                    break block8;
                                }
                                ++n3;
                            }
                            if (this.isKeyword(string)) {
                                arrayList2.add(templateProposal);
                            }
                        }
                        ++n2;
                    }
                }
                arrayList.removeAll(arrayList2);
            }
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    private IRubyCompletionProposal[] getKeywordProposals(int n) {
        List list = this.getKeywords();
        ArrayList<IRubyCompletionProposal> arrayList = new ArrayList<IRubyCompletionProposal>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.getCurrentPrefix(this.viewer.getDocument().get(), n);
            if (string2.length() >= string.length()) continue;
            arrayList.add(this.createKeywordProposal(string, string2, n));
        }
        return arrayList.toArray(new RubyCompletionProposal[arrayList.size()]);
    }

    private IRubyCompletionProposal createKeywordProposal(String string, String string2, int n) {
        String string3 = string.substring(string2.length(), string.length());
        return new RubyCompletionProposal(string3, n, string3.length(), RubyPluginImages.get("org.rubypeople.rdt.ui.template_obj.gif"), string, 0);
    }

    private List getKeywords() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = RubyTextTools.getKeyWords();
        int n = 0;
        while (n < stringArray.length) {
            arrayList.add(stringArray[n]);
            ++n;
        }
        return arrayList;
    }

    private boolean isKeyword(String string) {
        return this.getKeywords().contains(string);
    }

    private String getContext(String string) {
        int n = 0;
        while (n < preDefinedGlobals.length) {
            if (string.equals(preDefinedGlobals[n])) {
                return globalContexts[n];
            }
            ++n;
        }
        return "";
    }

    private boolean isPredefinedGlobal(String string) {
        int n = 0;
        while (n < preDefinedGlobals.length) {
            if (string.equals(preDefinedGlobals[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private Collection getDocumentsRubyElements() {
        IRubyScript iRubyScript = this.fManager.getWorkingCopy(this.fEditor.getEditorInput());
        Collection collection = this.getElements((IParent)iRubyScript);
        IRubyProject iRubyProject = iRubyScript.getRubyProject();
        collection.addAll(this.addClassesAndModulesInProject(iRubyProject));
        Iterator iterator = iRubyProject.getReferencedProjects().iterator();
        while (iterator.hasNext()) {
            collection.addAll(this.addClassesAndModulesInProject((IRubyProject)iterator.next()));
        }
        collection.addAll(this.addKernelMethods());
        return collection;
    }

    private Collection addClassesAndModulesInProject(IRubyProject iRubyProject) {
        return this.getElementsOfType((IParent)iRubyProject, new int[]{3});
    }

    private Collection getElementsOfType(IParent iParent, int[] nArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            IRubyElement[] iRubyElementArray = iParent.getChildren();
            if (iRubyElementArray == null) {
                return arrayList;
            }
            int n = 0;
            while (n < iRubyElementArray.length) {
                IRubyElement iRubyElement = iRubyElementArray[n];
                int n2 = 0;
                while (n2 < nArray.length) {
                    if (iRubyElement.getElementType() == nArray[n2]) {
                        arrayList.add(iRubyElement.getElementName());
                        break;
                    }
                    ++n2;
                }
                if (iRubyElement instanceof IParent) {
                    arrayList.addAll(this.getElementsOfType((IParent)iRubyElement, nArray));
                }
                ++n;
            }
        }
        catch (RubyModelException rubyModelException) {
            rubyModelException.printStackTrace();
        }
        return arrayList;
    }

    private Collection getElements(IParent iParent) {
        return this.getElementsOfType(iParent, new int[]{3, 4, 5, 7, 8, 9});
    }

    private ICompletionProposal[] determineKeywordProposals(ITextViewer iTextViewer, int n) {
        this.initKeywordProposals();
        String string = this.getCurrentPrefix(iTextViewer.getDocument().get(), n);
        if (string.length() < 1) {
            return new ICompletionProposal[0];
        }
        List<String> list = Arrays.asList(keywordProposals);
        ArrayList<CompletionProposal> arrayList = new ArrayList<CompletionProposal>();
        int n2 = 0;
        while (n2 < list.size()) {
            String string2 = list.get(n2);
            if (string2.startsWith(string)) {
                String string3 = this.isPredefinedGlobal(string2) ? "{0} " + this.getContext(string2) : "{0}";
                ContextInformation contextInformation = new ContextInformation(string2, MessageFormat.format(string3, string2));
                arrayList.add(new CompletionProposal(string2.substring(string.length(), string2.length()), n, 0, string2.length() - string.length(), null, string2, (IContextInformation)contextInformation, MessageFormat.format("Ruby keyword: {0}", string2)));
            }
            ++n2;
        }
        ICompletionProposal[] iCompletionProposalArray = new ICompletionProposal[arrayList.size()];
        arrayList.toArray(iCompletionProposalArray);
        return iCompletionProposalArray;
    }

    private void initKeywordProposals() {
        if (keywordProposals == null) {
            String[] stringArray = RubyTextTools.getKeyWords();
            keywordProposals = new String[stringArray.length + preDefinedGlobals.length];
            System.arraycopy(stringArray, 0, keywordProposals, 0, stringArray.length);
            System.arraycopy(preDefinedGlobals, 0, keywordProposals, stringArray.length, preDefinedGlobals.length);
        }
    }

    protected String getCurrentPrefix(String string, int n) {
        int n2 = 0;
        while (n - n2 > 0 && !Character.isWhitespace(string.charAt(n - n2 - 1))) {
            ++n2;
        }
        return string.substring(n - n2, n);
    }

    protected Template[] getTemplates(String string) {
        return RubyTemplateAccess.getDefault().getTemplateStore().getTemplates();
    }

    public IContextInformation[] computeContextInformation(ITextViewer iTextViewer, int n) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[]{'#'};
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.contextInformationValidator;
    }

    public String getErrorMessage() {
        return null;
    }

    protected class RubyContextInformationValidator
    implements IContextInformationValidator,
    IContextInformationPresenter {
        protected int installDocumentPosition;

        protected RubyContextInformationValidator() {
        }

        public void install(IContextInformation iContextInformation, ITextViewer iTextViewer, int n) {
            this.installDocumentPosition = n;
        }

        public boolean isContextInformationValid(int n) {
            return Math.abs(this.installDocumentPosition - n) < 1;
        }

        public boolean updatePresentation(int n, TextPresentation textPresentation) {
            return false;
        }
    }
}

