/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.matcher;

import fr.jayasoft.ivy.matcher.AnyMatcher;
import fr.jayasoft.ivy.matcher.ExactPatternMatcher;
import fr.jayasoft.ivy.matcher.Matcher;
import fr.jayasoft.ivy.matcher.PatternMatcher;
import fr.jayasoft.ivy.matcher.RegexpPatternMatcher;

public final class ExactOrRegexpPatternMatcher
implements PatternMatcher {
    private static final ExactOrRegexpPatternMatcher INSTANCE = new ExactOrRegexpPatternMatcher();

    public static PatternMatcher getInstance() {
        return INSTANCE;
    }

    private ExactOrRegexpPatternMatcher() {
    }

    public String getName() {
        return "exactOrRegexp";
    }

    public Matcher getMatcher(String exp) {
        if ("*".equals(exp)) {
            return AnyMatcher.getInstance();
        }
        return new ExactOrRegexpMatcher(exp);
    }

    public static class ExactOrRegexpMatcher
    implements Matcher {
        private Matcher _exact;
        private Matcher _regexp;

        public ExactOrRegexpMatcher(String exp) {
            this._exact = ExactPatternMatcher.getInstance().getMatcher(exp);
            this._regexp = RegexpPatternMatcher.getInstance().getMatcher(exp);
        }

        public boolean matches(String str) {
            return this._exact.matches(str) || this._regexp.matches(str);
        }

        public boolean isExact() {
            return false;
        }
    }
}

