/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileName;
import org.apache.commons.vfs.provider.UriParser;

public class GenericFileName
extends AbstractFileName {
    private final String userName;
    private final String hostName;
    private final int defaultPort;
    private final String password;
    private final int port;
    private static final char[] USERNAME_RESERVED = new char[]{':', '@', '/'};
    private static final char[] PASSWORD_RESERVED = new char[]{'@', '/', '?'};

    protected GenericFileName(String scheme, String hostName, int port, int defaultPort, String userName, String password, String path, FileType type) {
        super(scheme, path, type);
        this.hostName = hostName;
        this.defaultPort = defaultPort;
        this.password = password;
        this.userName = userName;
        this.port = port > 0 ? port : this.getDefaultPort();
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public FileName createName(String absPath, FileType type) {
        return new GenericFileName(this.getScheme(), this.hostName, this.port, this.defaultPort, this.userName, this.password, absPath, type);
    }

    protected void appendRootUri(StringBuffer buffer) {
        buffer.append(this.getScheme());
        buffer.append("://");
        this.appendCredentials(buffer);
        buffer.append(this.hostName);
        if (this.port != this.getDefaultPort()) {
            buffer.append(':');
            buffer.append(this.port);
        }
    }

    protected void appendCredentials(StringBuffer buffer) {
        if (this.userName != null && this.userName.length() != 0) {
            UriParser.appendEncoded(buffer, this.userName, USERNAME_RESERVED);
            if (this.password != null && this.password.length() != 0) {
                buffer.append(':');
                UriParser.appendEncoded(buffer, this.password, PASSWORD_RESERVED);
            }
            buffer.append('@');
        }
    }
}

