/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.repository.vfs;

import fr.jayasoft.ivy.repository.vfs.IvyWebdavConnectionManager;
import fr.jayasoft.ivy.url.HttpClientHandler;
import java.io.IOException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.webdav.WebdavConnectionManager;
import org.apache.commons.vfs.provider.webdav.WebdavFileSystemConfigBuilder;
import org.apache.webdav.lib.WebdavResource;

class IvyWebdavClientFactory {
    private IvyWebdavClientFactory() {
    }

    public static HttpClient createConnection(String hostname, int port, String username, String password, FileSystemOptions fileSystemOptions) throws FileSystemException {
        HttpClient client;
        try {
            HttpURL url = new HttpURL(username, password, hostname, port, "/");
            WebdavResource resource = new WebdavResource(){};
            if (fileSystemOptions != null) {
                String proxyHost = WebdavFileSystemConfigBuilder.getInstance().getProxyHost(fileSystemOptions);
                int proxyPort = WebdavFileSystemConfigBuilder.getInstance().getProxyPort(fileSystemOptions);
                if (proxyHost != null && proxyPort > 0) {
                    resource.setProxy(proxyHost, proxyPort);
                }
            }
            resource.setHttpURL(url, 1, 1);
            client = resource.retrieveSessionInstance();
            HttpClientHandler handler = new HttpClientHandler();
            int httpClientVersion = handler.getHttpClientMajorVersion();
            if (httpClientVersion == 2) {
                client.setHttpConnectionManager((HttpConnectionManager)new WebdavConnectionManager());
            } else {
                client.setHttpConnectionManager((HttpConnectionManager)new IvyWebdavConnectionManager());
            }
        }
        catch (IOException e) {
            throw new FileSystemException("vfs.provider.webdav/connect.error", (Object)hostname, (Throwable)e);
        }
        return client;
    }
}

