/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.impl;

import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.ICodeBase;
import edu.umd.cs.findbugs.classfile.ICodeBaseEntry;
import edu.umd.cs.findbugs.classfile.InvalidClassFileFormatException;
import edu.umd.cs.findbugs.classfile.impl.AbstractScannableCodeBase;
import edu.umd.cs.findbugs.classfile.impl.AbstractScannableCodeBaseEntry;
import edu.umd.cs.findbugs.classfile.impl.DirectoryCodeBase;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class DirectoryCodeBaseEntry
extends AbstractScannableCodeBaseEntry
implements ICodeBaseEntry {
    private final DirectoryCodeBase codeBase;
    private final String realResourceName;

    public DirectoryCodeBaseEntry(DirectoryCodeBase codeBase, String realResourceName) {
        this.codeBase = codeBase;
        this.realResourceName = realResourceName;
    }

    public int getNumBytes() {
        File fullPath = this.codeBase.getFullPathOfResource(this.realResourceName);
        if (!fullPath.exists()) {
            return -1;
        }
        return (int)fullPath.length();
    }

    public InputStream openResource() throws IOException {
        return this.codeBase.openFile(this.realResourceName);
    }

    public AbstractScannableCodeBase getCodeBase() {
        return this.codeBase;
    }

    public String getRealResourceName() {
        return this.realResourceName;
    }

    public ClassDescriptor getClassDescriptor() throws InvalidClassFileFormatException {
        return ClassDescriptor.fromResourceName(this.getResourceName());
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DirectoryCodeBaseEntry other = (DirectoryCodeBaseEntry)obj;
        return this.codeBase.equals(other.codeBase) && this.realResourceName.equals(other.realResourceName);
    }

    public int hashCode() {
        return 7919 * this.codeBase.hashCode() + this.realResourceName.hashCode();
    }

    public String toString() {
        return this.getCodeBase() + ":" + this.getResourceName();
    }

    public /* synthetic */ ICodeBase getCodeBase() {
        return this.getCodeBase();
    }
}

