/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.SystemProperties;
import org.apache.bcel.Constants;

public class BytecodeScanner
implements Constants {
    private static final boolean DEBUG;
    private static final int[] PAD;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static short unsignedValueOf(byte value) {
        short result;
        if ((value & 0x80) != 0) {
            result = (short)(value & 0x7F);
            result = (short)(result | 0x80);
        } else {
            result = value;
        }
        return result;
    }

    private static int extractInt(byte[] arr, int offset) {
        return (arr[offset] & 0xFF) << 24 | (arr[offset + 1] & 0xFF) << 16 | (arr[offset + 2] & 0xFF) << 8 | arr[offset + 3] & 0xFF;
    }

    public void scan(byte[] instructionList, Callback callback) {
        boolean wide = false;
        int index = 0;
        while (index < instructionList.length) {
            short opcode = BytecodeScanner.unsignedValueOf(instructionList[index]);
            callback.handleInstruction(opcode, index);
            if (DEBUG) {
                System.out.println(index + ": " + OPCODE_NAMES[opcode]);
            }
            switch (opcode) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 190: 
                case 191: 
                case 194: 
                case 195: {
                    ++index;
                    break;
                }
                case 16: 
                case 18: 
                case 188: {
                    index += 2;
                    break;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 169: {
                    if (wide) {
                        index += 3;
                        wide = false;
                        break;
                    }
                    index += 2;
                    break;
                }
                case 132: {
                    if (wide) {
                        index += 5;
                        wide = false;
                        break;
                    }
                    index += 3;
                    break;
                }
                case 17: 
                case 19: 
                case 20: 
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 187: 
                case 189: 
                case 192: 
                case 193: 
                case 198: 
                case 199: {
                    index += 3;
                    break;
                }
                case 197: {
                    index += 4;
                    break;
                }
                case 185: 
                case 200: 
                case 201: {
                    index += 5;
                    break;
                }
                case 170: {
                    int offset = index + 1;
                    offset += PAD[offset & 3];
                    if (!$assertionsDisabled && (offset & 3) != 0) {
                        throw new AssertionError();
                    }
                    int low = BytecodeScanner.extractInt(instructionList, offset + 4);
                    int high = BytecodeScanner.extractInt(instructionList, offset + 8);
                    int tableSize = high - low + 1;
                    if (DEBUG) {
                        System.out.println("tableswitch: low=" + low + ", high=" + high + ", tableSize=" + tableSize);
                    }
                    index = offset + 12 + tableSize * 4;
                    break;
                }
                case 171: {
                    int offset = index + 1;
                    offset += PAD[offset & 3];
                    if (!$assertionsDisabled && (offset & 3) != 0) {
                        throw new AssertionError();
                    }
                    int numPairs = BytecodeScanner.extractInt(instructionList, offset + 4);
                    if (DEBUG) {
                        System.out.println("lookupswitch: numPairs=" + numPairs);
                    }
                    index = offset + 8 + numPairs * 8;
                    break;
                }
                case 196: {
                    wide = true;
                    ++index;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad opcode " + opcode + " at offset " + index);
                }
            }
            if (index >= 0) continue;
            throw new IllegalStateException("index=" + index + ", opcode=" + opcode);
        }
    }

    static {
        $assertionsDisabled = !BytecodeScanner.class.desiredAssertionStatus();
        DEBUG = SystemProperties.getBoolean("bs.debug");
        PAD = new int[]{0, 3, 2, 1};
    }

    public static interface Callback {
        public void handleInstruction(int var1, int var2);
    }
}

