/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FindBugsAnalysisFeatures;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowAnalysis;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DataflowTestDriver;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.IncompatibleTypes;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.type.ExceptionSetFactory;
import edu.umd.cs.findbugs.ba.type.ExtendedTypes;
import edu.umd.cs.findbugs.ba.type.StandardTypeMerger;
import edu.umd.cs.findbugs.ba.type.TypeAnalysis;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.ba.type.TypeFrameModelingVisitor;
import edu.umd.cs.findbugs.ba.type.TypeMerger;
import edu.umd.cs.findbugs.detect.RefComparisonWarningProperty;
import edu.umd.cs.findbugs.props.WarningProperty;
import edu.umd.cs.findbugs.props.WarningPropertySet;
import edu.umd.cs.findbugs.props.WarningPropertyUtil;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LDC2_W;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindRefComparison
implements Detector,
ExtendedTypes {
    private static final boolean DEBUG = SystemProperties.getBoolean((String)"frc.debug");
    private static final boolean REPORT_ALL_REF_COMPARISONS = SystemProperties.getBoolean((String)"findbugs.refcomp.reportAll");
    private static final int BASE_ES_PRIORITY = SystemProperties.getInteger((String)"es.basePriority", (int)2);
    private static final HashSet<String> suspiciousSet = new HashSet();
    private static final BitSet invokeInstanceSet;
    private static final BitSet prescreenSet;
    private static final byte T_DYNAMIC_STRING = 100;
    private static final byte T_STATIC_STRING = 101;
    private static final byte T_PARAMETER_STRING = 102;
    private static final String STRING_SIGNATURE = "Ljava/lang/String;";
    private static final Type dynamicStringTypeInstance;
    private static final Type staticStringTypeInstance;
    private static final Type parameterStringTypeInstance;
    private BugReporter bugReporter;
    private ClassContext classContext;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$detect$FindRefComparison;

    public FindRefComparison(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        this.classContext = classContext;
        JavaClass jclass = classContext.getJavaClass();
        for (Method method : methodList = jclass.getMethods()) {
            BitSet bytecodeSet;
            MethodGen methodGen = classContext.getMethodGen(method);
            if (methodGen == null || (bytecodeSet = classContext.getBytecodeSet(method)) == null || !bytecodeSet.intersects(prescreenSet)) continue;
            if (DEBUG) {
                System.out.println(new StringBuffer().append("FindRefComparison: analyzing ").append(SignatureConverter.convertMethodSignature((MethodGen)methodGen)).toString());
            }
            try {
                this.analyzeMethod(classContext, method);
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError(new StringBuffer().append("Error analyzing ").append(method.toString()).toString(), (Throwable)e);
            }
            catch (DataflowAnalysisException e) {
                // empty catch block
            }
        }
    }

    private void analyzeMethod(ClassContext classContext, final Method method) throws CFGBuilderException, DataflowAnalysisException {
        MethodGen methodGen = classContext.getMethodGen(method);
        if (methodGen == null) {
            return;
        }
        boolean sawCallToEquals = false;
        JavaClass jclass = classContext.getJavaClass();
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        LinkedList<WarningWithProperties> refComparisonList = new LinkedList<WarningWithProperties>();
        LinkedList<WarningWithProperties> stringComparisonList = new LinkedList<WarningWithProperties>();
        CFG cfg = classContext.getCFG(method);
        DepthFirstSearch dfs = classContext.getDepthFirstSearch(method);
        ExceptionSetFactory exceptionSetFactory = classContext.getExceptionSetFactory(method);
        RefComparisonTypeMerger typeMerger = new RefComparisonTypeMerger((RepositoryLookupFailureCallback)this.bugReporter, exceptionSetFactory);
        RefComparisonTypeFrameModelingVisitor visitor = new RefComparisonTypeFrameModelingVisitor(methodGen.getConstantPool(), (RepositoryLookupFailureCallback)this.bugReporter);
        TypeAnalysis typeAnalysis = new TypeAnalysis(method, methodGen, cfg, dfs, (TypeMerger)typeMerger, visitor, (RepositoryLookupFailureCallback)this.bugReporter, exceptionSetFactory){

            public void initEntryFact(TypeFrame result) {
                super.initEntryFact(result);
                for (int i = 0; i < this.methodGen.getMaxLocals(); ++i) {
                    Type t = (Type)result.getValue(i);
                    if (!t.equals((Object)ObjectType.STRING)) continue;
                    result.setValue(i, (Object)parameterStringTypeInstance);
                }
            }

            public /* synthetic */ void initEntryFact(Object x0) throws DataflowAnalysisException {
                this.initEntryFact((TypeFrame)x0);
            }
        };
        TypeDataflow typeDataflow = new TypeDataflow(cfg, typeAnalysis);
        typeDataflow.execute();
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            Location location = (Location)i.next();
            sawCallToEquals = this.inspectLocation(sawCallToEquals, jclass, cpg, method, methodGen, refComparisonList, stringComparisonList, visitor, typeDataflow, location);
        }
        final boolean sawEquals = sawCallToEquals;
        this.decorateWarnings(stringComparisonList, new WarningDecorator(){

            public void decorate(WarningWithProperties warn) {
                if (sawEquals) {
                    warn.propertySet.addProperty((WarningProperty)RefComparisonWarningProperty.SAW_CALL_TO_EQUALS);
                }
            }
        });
        this.decorateWarnings(refComparisonList, new WarningDecorator(){

            public void decorate(WarningWithProperties warn) {
                if (sawEquals) {
                    warn.propertySet.addProperty((WarningProperty)RefComparisonWarningProperty.SAW_CALL_TO_EQUALS);
                }
            }
        });
        boolean relaxed = FindBugsAnalysisFeatures.isRelaxedMode();
        this.reportBest(classContext, method, stringComparisonList, relaxed);
        this.reportBest(classContext, method, refComparisonList, relaxed);
    }

    private boolean inspectLocation(boolean sawCallToEquals, JavaClass jclass, ConstantPoolGen cpg, Method method, MethodGen methodGen, LinkedList<WarningWithProperties> refComparisonList, LinkedList<WarningWithProperties> stringComparisonList, RefComparisonTypeFrameModelingVisitor visitor, TypeDataflow typeDataflow, Location location) throws DataflowAnalysisException {
        String methodSig;
        InvokeInstruction inv;
        String methodName;
        Instruction ins = location.getHandle().getInstruction();
        short opcode = ins.getOpcode();
        if (opcode == 165 || opcode == 166) {
            this.checkRefComparison(location, jclass, methodGen, visitor, typeDataflow, stringComparisonList, refComparisonList);
        } else if (invokeInstanceSet.get(opcode) && this.isEqualsMethod(methodName = (inv = (InvokeInstruction)ins).getMethodName(cpg), methodSig = inv.getSignature(cpg))) {
            sawCallToEquals = true;
            this.checkEqualsComparison(location, jclass, method, methodGen, typeDataflow);
        }
        return sawCallToEquals;
    }

    private void decorateWarnings(LinkedList<WarningWithProperties> stringComparisonList, WarningDecorator warningDecorator) {
        for (WarningWithProperties warn : stringComparisonList) {
            warningDecorator.decorate(warn);
            warn.instance.setPriority(warn.propertySet.computePriority(2));
        }
    }

    private void reportBest(ClassContext classContext, Method method, LinkedList<WarningWithProperties> warningList, boolean relaxed) {
        boolean reportAll = relaxed || REPORT_ALL_REF_COMPARISONS;
        WarningWithProperties best = null;
        for (WarningWithProperties warn : warningList) {
            if (best == null || warn.instance.getPriority() < best.instance.getPriority()) {
                best = warn;
            }
            if (!reportAll) continue;
            if (relaxed) {
                WarningPropertyUtil.addPropertiesForLocation((WarningPropertySet)warn.propertySet, (ClassContext)classContext, (Method)method, (Location)warn.location);
                warn.propertySet.decorateBugInstance(warn.instance);
            }
            this.bugReporter.reportBug(warn.instance);
        }
        if (best != null && !reportAll) {
            this.bugReporter.reportBug(best.instance);
        }
    }

    private boolean isEqualsMethod(String methodName, String methodSig) {
        return methodName.equals("equals") && methodSig.equals("(Ljava/lang/Object;)Z") || methodName.equals("equalIgnoreCases") && methodSig.equals("(Ljava/lang/String;)Z");
    }

    private void checkRefComparison(Location location, JavaClass jclass, MethodGen methodGen, RefComparisonTypeFrameModelingVisitor visitor, TypeDataflow typeDataflow, List<WarningWithProperties> stringComparisonList, List<WarningWithProperties> refComparisonList) throws DataflowAnalysisException {
        InstructionHandle handle = location.getHandle();
        TypeFrame frame = typeDataflow.getFactAtLocation(location);
        if (frame.getStackDepth() < 2) {
            throw new DataflowAnalysisException("Stack underflow", methodGen, handle);
        }
        int numSlots = frame.getNumSlots();
        Type lhsType = (Type)frame.getValue(numSlots - 1);
        Type rhsType = (Type)frame.getValue(numSlots - 2);
        if (lhsType instanceof ReferenceType && rhsType instanceof ReferenceType) {
            String rhs;
            String lhs = SignatureConverter.convert((String)lhsType.getSignature());
            if (!lhs.equals(rhs = SignatureConverter.convert((String)rhsType.getSignature()))) {
                return;
            }
            if (lhs.equals("java.lang.String")) {
                this.handleStringComparison(jclass, methodGen, visitor, stringComparisonList, location, lhsType, rhsType);
            } else if (suspiciousSet.contains(lhs)) {
                this.handleSuspiciousRefComparison(jclass, methodGen, refComparisonList, location, lhs);
            }
        }
    }

    private void handleStringComparison(JavaClass jclass, MethodGen methodGen, RefComparisonTypeFrameModelingVisitor visitor, List<WarningWithProperties> stringComparisonList, Location location, Type lhsType, Type rhsType) {
        if (DEBUG) {
            System.out.println(new StringBuffer().append("String/String comparison at ").append(location.getHandle()).toString());
        }
        byte type1 = lhsType.getType();
        byte type2 = rhsType.getType();
        String bugPattern = "ES_COMPARING_STRINGS_WITH_EQ";
        WarningPropertySet propertySet = new WarningPropertySet();
        if (type1 == 101 && type2 == 101) {
            propertySet.addProperty((WarningProperty)RefComparisonWarningProperty.COMPARE_STATIC_STRINGS);
        } else if (type1 == 100 || type2 == 100) {
            propertySet.addProperty((WarningProperty)RefComparisonWarningProperty.DYNAMIC_AND_UNKNOWN);
        } else if (type2 == 102 || type1 == 102) {
            bugPattern = "ES_COMPARING_PARAMETER_STRING_WITH_EQ";
            if (methodGen.isPublic() || methodGen.isProtected()) {
                propertySet.addProperty((WarningProperty)RefComparisonWarningProperty.STRING_PARAMETER_IN_PUBLIC_METHOD);
            } else {
                propertySet.addProperty((WarningProperty)RefComparisonWarningProperty.STRING_PARAMETER);
            }
        } else if (type1 == 101 || type2 == 101) {
            propertySet.addProperty((WarningProperty)RefComparisonWarningProperty.STATIC_AND_UNKNOWN);
        } else if (visitor.sawStringIntern()) {
            propertySet.addProperty((WarningProperty)RefComparisonWarningProperty.SAW_INTERN);
        }
        String sourceFile = jclass.getSourceFileName();
        BugInstance instance = new BugInstance((Detector)this, bugPattern, BASE_ES_PRIORITY).addClassAndMethod(methodGen, sourceFile).addType(STRING_SIGNATURE).describe("TYPE_FOUND").addSourceLine(this.classContext, methodGen, sourceFile, location.getHandle());
        WarningWithProperties warn = new WarningWithProperties(instance, propertySet, location);
        stringComparisonList.add(warn);
    }

    private void handleSuspiciousRefComparison(JavaClass jclass, MethodGen methodGen, List<WarningWithProperties> refComparisonList, Location location, String lhs) {
        String sourceFile = jclass.getSourceFileName();
        BugInstance instance = new BugInstance((Detector)this, "RC_REF_COMPARISON", lhs.equals("java.lang.Boolean") ? 2 : 1).addClassAndMethod(methodGen, sourceFile).addType(new StringBuffer().append("L").append(lhs.replace('.', '/')).append(";").toString()).describe("TYPE_FOUND").addSourceLine(this.classContext, methodGen, sourceFile, location.getHandle());
        refComparisonList.add(new WarningWithProperties(instance, new WarningPropertySet(), location));
    }

    private static boolean testLikeName(String name) {
        return name.toLowerCase().indexOf("test") >= 0;
    }

    private void checkEqualsComparison(Location location, JavaClass jclass, Method method, MethodGen methodGen, TypeDataflow typeDataflow) throws DataflowAnalysisException {
        IncompatibleTypes result;
        InstructionHandle handle = location.getHandle();
        String sourceFile = jclass.getSourceFileName();
        TypeFrame frame = typeDataflow.getFactAtLocation(location);
        if (frame.getStackDepth() < 2) {
            throw new DataflowAnalysisException("Stack underflow", methodGen, handle);
        }
        int numSlots = frame.getNumSlots();
        Type lhsType_ = (Type)frame.getValue(numSlots - 2);
        Type rhsType_ = (Type)frame.getValue(numSlots - 1);
        if (lhsType_.getType() == 17 || lhsType_.getType() == 20 || rhsType_.getType() == 17 || rhsType_.getType() == 20) {
            return;
        }
        boolean looksLikeTestCase = method.getName().startsWith("test") && method.isPublic() && method.getSignature().equals("()V") || FindRefComparison.testLikeName(jclass.getClassName()) || FindRefComparison.testLikeName(jclass.getSuperclassName());
        int priorityModifier = 0;
        if (looksLikeTestCase) {
            priorityModifier = 1;
        }
        if (methodGen.getName().startsWith("test") && methodGen.getSignature().equals("()V")) {
            try {
                if (jclass.getSuperclassName().equals("junit.framework.TestCase") || Hierarchy.isSubtype((String)methodGen.getClassName(), (String)"junit.framework.TestCase")) {
                    priorityModifier = 2;
                }
            }
            catch (ClassNotFoundException e) {
                AnalysisContext.reportMissingClass((ClassNotFoundException)e);
            }
        }
        if (!(lhsType_ instanceof ReferenceType) || !(rhsType_ instanceof ReferenceType)) {
            if (rhsType_.getType() == 21) {
                if (!looksLikeTestCase) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "EC_NULL_ARG", 2).addClassAndMethod(methodGen, sourceFile).addSourceLine(this.classContext, methodGen, sourceFile, location.getHandle()));
                }
            } else if (lhsType_.getType() != 21) {
                this.bugReporter.logError(new StringBuffer().append("equals() used to compare non-object type(s) ").append(lhsType_).append(" and ").append(rhsType_).append(" in ").append(SignatureConverter.convertMethodSignature((MethodGen)methodGen)).append(" at ").append(location.getHandle()).toString());
            }
            return;
        }
        if (lhsType_ instanceof ArrayType && rhsType_ instanceof ArrayType) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "EC_BAD_ARRAY_COMPARE", 2).addClassAndMethod(methodGen, sourceFile).addFoundAndExpectedType(rhsType_.getSignature(), lhsType_.getSignature()).addSourceLine(this.classContext, methodGen, sourceFile, location.getHandle()));
        }
        if ((result = IncompatibleTypes.getPriorityForAssumingCompatible((Type)lhsType_, (Type)rhsType_)) == IncompatibleTypes.ARRAY_AND_NON_ARRAY || result == IncompatibleTypes.ARRAY_AND_OBJECT) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "EC_ARRAY_AND_NONARRAY", result.getPriority()).addClassAndMethod(methodGen, sourceFile).addFoundAndExpectedType(rhsType_.getSignature(), lhsType_.getSignature()).addSourceLine(this.classContext, methodGen, sourceFile, location.getHandle()));
        } else if (result == IncompatibleTypes.INCOMPATIBLE_CLASSES) {
            boolean core;
            String lhsSig = lhsType_.getSignature();
            String rhsSig = rhsType_.getSignature();
            boolean bl = core = lhsSig.startsWith("Ljava") && rhsSig.startsWith("Ljava");
            if (core) {
                looksLikeTestCase = false;
                priorityModifier = 0;
            }
            if (!looksLikeTestCase) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "EC_UNRELATED_TYPES", result.getPriority() + priorityModifier).addClassAndMethod(methodGen, sourceFile).addFoundAndExpectedType(rhsType_.getSignature(), lhsType_.getSignature()).addSourceLine(this.classContext, methodGen, sourceFile, location.getHandle()));
            }
        } else if (result == IncompatibleTypes.UNRELATED_CLASS_AND_INTERFACE) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "EC_UNRELATED_CLASS_AND_INTERFACE", result.getPriority()).addClassAndMethod(methodGen, sourceFile).addFoundAndExpectedType(rhsType_.getSignature(), lhsType_.getSignature()).addSourceLine(this.classContext, methodGen, sourceFile, location.getHandle()));
        } else if (result == IncompatibleTypes.UNRELATED_INTERFACES) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "EC_UNRELATED_INTERFACES", result.getPriority()).addClassAndMethod(methodGen, sourceFile).addFoundAndExpectedType(rhsType_.getSignature(), lhsType_.getSignature()).addSourceLine(this.classContext, methodGen, sourceFile, location.getHandle()));
        }
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length != 1) {
            System.err.println(new StringBuffer().append("Usage: ").append((class$edu$umd$cs$findbugs$detect$FindRefComparison == null ? (class$edu$umd$cs$findbugs$detect$FindRefComparison = FindRefComparison.class$("edu.umd.cs.findbugs.detect.FindRefComparison")) : class$edu$umd$cs$findbugs$detect$FindRefComparison).getName()).append(" <class file>").toString());
            System.exit(1);
        }
        DataflowTestDriver<TypeFrame, TypeAnalysis> driver = new DataflowTestDriver<TypeFrame, TypeAnalysis>(){

            public Dataflow<TypeFrame, TypeAnalysis> createDataflow(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
                RepositoryLookupFailureCallback lookupFailureCallback = classContext.getLookupFailureCallback();
                MethodGen methodGen = classContext.getMethodGen(method);
                if (methodGen == null) {
                    throw new DataflowAnalysisException(new StringBuffer().append("Could not get methodGen for ").append(method.toString()).toString());
                }
                DepthFirstSearch dfs = classContext.getDepthFirstSearch(method);
                CFG cfg = classContext.getCFG(method);
                ExceptionSetFactory exceptionSetFactory = classContext.getExceptionSetFactory(method);
                RefComparisonTypeMerger typeMerger = new RefComparisonTypeMerger(lookupFailureCallback, exceptionSetFactory);
                RefComparisonTypeFrameModelingVisitor visitor = new RefComparisonTypeFrameModelingVisitor(methodGen.getConstantPool(), lookupFailureCallback);
                TypeAnalysis analysis = new TypeAnalysis(method, methodGen, cfg, dfs, (TypeMerger)typeMerger, (TypeFrameModelingVisitor)visitor, lookupFailureCallback, exceptionSetFactory);
                Dataflow dataflow = new Dataflow(cfg, (DataflowAnalysis)analysis);
                dataflow.execute();
                return dataflow;
            }
        };
        driver.execute(argv[0]);
    }

    public void report() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        suspiciousSet.add("java.lang.Boolean");
        suspiciousSet.add("java.lang.Byte");
        suspiciousSet.add("java.lang.Character");
        suspiciousSet.add("java.lang.Double");
        suspiciousSet.add("java.lang.Float");
        suspiciousSet.add("java.lang.Integer");
        suspiciousSet.add("java.lang.Long");
        suspiciousSet.add("java.lang.Short");
        invokeInstanceSet = new BitSet();
        invokeInstanceSet.set(182);
        invokeInstanceSet.set(185);
        invokeInstanceSet.set(183);
        prescreenSet = new BitSet();
        prescreenSet.or(invokeInstanceSet);
        prescreenSet.set(165);
        prescreenSet.set(166);
        dynamicStringTypeInstance = new DynamicStringType();
        staticStringTypeInstance = new StaticStringType();
        parameterStringTypeInstance = new ParameterStringType();
    }

    private static interface WarningDecorator {
        public void decorate(WarningWithProperties var1);
    }

    private static class WarningWithProperties {
        BugInstance instance;
        WarningPropertySet propertySet;
        Location location;

        WarningWithProperties(BugInstance warning, WarningPropertySet propertySet, Location location) {
            this.instance = warning;
            this.propertySet = propertySet;
            this.location = location;
        }
    }

    private static class RefComparisonTypeMerger
    extends StandardTypeMerger {
        public RefComparisonTypeMerger(RepositoryLookupFailureCallback lookupFailureCallback, ExceptionSetFactory exceptionSetFactory) {
            super(lookupFailureCallback, exceptionSetFactory);
        }

        protected boolean isReferenceType(byte type) {
            return super.isReferenceType(type) || type == 101 || type == 100;
        }

        protected Type mergeReferenceTypes(ReferenceType aRef, ReferenceType bRef) throws DataflowAnalysisException {
            byte aType = aRef.getType();
            byte bType = bRef.getType();
            if (this.isExtendedStringType(aType) || this.isExtendedStringType(bType)) {
                if (aType == bType) {
                    return aRef;
                }
                if (this.isExtendedStringType(aType)) {
                    aRef = Type.STRING;
                }
                if (this.isExtendedStringType(bType)) {
                    bRef = Type.STRING;
                }
            }
            return super.mergeReferenceTypes(aRef, bRef);
        }

        private boolean isExtendedStringType(byte type) {
            return type == 100 || type == 101 || type == 102;
        }
    }

    private static class RefComparisonTypeFrameModelingVisitor
    extends TypeFrameModelingVisitor {
        private RepositoryLookupFailureCallback lookupFailureCallback;
        private boolean sawStringIntern;

        public RefComparisonTypeFrameModelingVisitor(ConstantPoolGen cpg, RepositoryLookupFailureCallback lookupFailureCallback) {
            super(cpg);
            this.lookupFailureCallback = lookupFailureCallback;
            this.sawStringIntern = false;
        }

        public boolean sawStringIntern() {
            return this.sawStringIntern;
        }

        public void visitINVOKESTATIC(INVOKESTATIC obj) {
            this.consumeStack((Instruction)obj);
            if (this.returnsString((InvokeInstruction)obj)) {
                String className = obj.getClassName(this.getCPG());
                if (className.equals("java.lang.String")) {
                    this.pushValue(dynamicStringTypeInstance);
                } else {
                    this.pushReturnType((InvokeInstruction)obj);
                }
            } else {
                this.pushReturnType((InvokeInstruction)obj);
            }
        }

        public void visitINVOKESPECIAL(INVOKESPECIAL obj) {
            this.handleInstanceMethod((InvokeInstruction)obj);
        }

        public void visitINVOKEINTERFACE(INVOKEINTERFACE obj) {
            this.handleInstanceMethod((InvokeInstruction)obj);
        }

        public void visitINVOKEVIRTUAL(INVOKEVIRTUAL obj) {
            this.handleInstanceMethod((InvokeInstruction)obj);
        }

        private boolean returnsString(InvokeInstruction inv) {
            String methodSig = inv.getSignature(this.getCPG());
            return methodSig.endsWith(")Ljava/lang/String;");
        }

        private void handleInstanceMethod(InvokeInstruction obj) {
            this.consumeStack((Instruction)obj);
            if (this.returnsString(obj)) {
                String className = obj.getClassName(this.getCPG());
                String methodName = obj.getName(this.getCPG());
                if (methodName.equals("intern") && className.equals("java.lang.String")) {
                    this.sawStringIntern = true;
                    this.pushValue(staticStringTypeInstance);
                } else if (methodName.equals("toString") || className.equals("java.lang.String")) {
                    this.pushValue(dynamicStringTypeInstance);
                } else {
                    this.pushReturnType(obj);
                }
            } else {
                this.pushReturnType(obj);
            }
        }

        public void visitLDC(LDC obj) {
            Type type = obj.getType(this.getCPG());
            this.pushValue(this.isString(type) ? staticStringTypeInstance : type);
        }

        public void visitLDC2_W(LDC2_W obj) {
            Type type = obj.getType(this.getCPG());
            this.pushValue(this.isString(type) ? staticStringTypeInstance : type);
        }

        private boolean isString(Type type) {
            return type.getSignature().equals(FindRefComparison.STRING_SIGNATURE);
        }

        public void visitGETSTATIC(GETSTATIC obj) {
            this.handleLoad((FieldInstruction)obj);
        }

        public void visitGETFIELD(GETFIELD obj) {
            this.handleLoad((FieldInstruction)obj);
        }

        private void handleLoad(FieldInstruction obj) {
            this.consumeStack((Instruction)obj);
            Type type = obj.getType(this.getCPG());
            if (type.getSignature().equals(FindRefComparison.STRING_SIGNATURE)) {
                try {
                    String className = obj.getClassName(this.getCPG());
                    String fieldName = obj.getName(this.getCPG());
                    Field field = Hierarchy.findField((String)className, (String)fieldName);
                    if (field != null) {
                        if (field.isFinal()) {
                            this.pushValue(staticStringTypeInstance);
                        } else {
                            this.pushValue(type);
                        }
                        return;
                    }
                }
                catch (ClassNotFoundException ex) {
                    this.lookupFailureCallback.reportMissingClass(ex);
                }
            }
            this.pushValue(type);
        }
    }

    private static class ParameterStringType
    extends ObjectType {
        private static final long serialVersionUID = 1L;

        public ParameterStringType() {
            super("java.lang.String");
        }

        public byte getType() {
            return 102;
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }

        public boolean equals(Object o) {
            return o == this;
        }

        public String toString() {
            return "<parameter string>";
        }
    }

    private static class StaticStringType
    extends ObjectType {
        private static final long serialVersionUID = 1L;

        public StaticStringType() {
            super("java.lang.String");
        }

        public byte getType() {
            return 101;
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }

        public boolean equals(Object o) {
            return o == this;
        }

        public String toString() {
            return "<static string>";
        }
    }

    private static class DynamicStringType
    extends ObjectType {
        private static final long serialVersionUID = 1L;

        public DynamicStringType() {
            super("java.lang.String");
        }

        public byte getType() {
            return 100;
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }

        public boolean equals(Object o) {
            return o == this;
        }

        public String toString() {
            return "<dynamic string>";
        }
    }
}

