/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.genmodel.generator;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.CodeGenEcorePlugin;
import org.eclipse.emf.codegen.ecore.Generator;
import org.eclipse.emf.codegen.ecore.generator.AbstractGeneratorAdapter;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenBase;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.jet.JETEmitter;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class GenBaseGeneratorAdapter
extends AbstractGeneratorAdapter {
    public static final String MODEL_PROJECT_TYPE = "org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject";
    public static final String EDIT_PROJECT_TYPE = "org.eclipse.emf.codegen.ecore.genmodel.generator.EditProject";
    public static final String EDITOR_PROJECT_TYPE = "org.eclipse.emf.codegen.ecore.genmodel.generator.EditorProject";
    public static final String TESTS_PROJECT_TYPE = "org.eclipse.emf.codegen.ecore.genmodel.generator.TestsProject";

    public GenBaseGeneratorAdapter() {
    }

    public GenBaseGeneratorAdapter(GeneratorAdapterFactory generatorAdapterFactory) {
        super(generatorAdapterFactory);
    }

    public boolean canGenerate(Object object, Object projectType) {
        if (MODEL_PROJECT_TYPE.equals(projectType)) {
            return this.canGenerateModel(object);
        }
        if (EDIT_PROJECT_TYPE.equals(projectType)) {
            return this.canGenerateEdit(object);
        }
        if (EDITOR_PROJECT_TYPE.equals(projectType)) {
            return this.canGenerateEditor(object);
        }
        if (TESTS_PROJECT_TYPE.equals(projectType)) {
            return this.canGenerateTests(object);
        }
        return false;
    }

    public boolean canGenerateModel(Object object) {
        return ((GenBase)object).canGenerate();
    }

    public boolean canGenerateEdit(Object object) {
        return ((GenBase)object).canGenerateEdit();
    }

    public boolean canGenerateEditor(Object object) {
        return ((GenBase)object).canGenerateEditor();
    }

    public boolean canGenerateTests(Object object) {
        return ((GenBase)object).canGenerateTests();
    }

    public Collection getGenerateChildren(Object object, Object projectType) {
        if (MODEL_PROJECT_TYPE.equals(projectType)) {
            return this.getGenerateModelChildren(object);
        }
        if (EDIT_PROJECT_TYPE.equals(projectType)) {
            return this.getGenerateEditChildren(object);
        }
        if (EDITOR_PROJECT_TYPE.equals(projectType)) {
            return this.getGenerateEditorChildren(object);
        }
        if (TESTS_PROJECT_TYPE.equals(projectType)) {
            return this.getGenerateTestsChildren(object);
        }
        return Collections.EMPTY_LIST;
    }

    protected Collection getGenerateModelChildren(Object object) {
        return Collections.EMPTY_LIST;
    }

    protected Collection getGenerateEditChildren(Object object) {
        return Collections.EMPTY_LIST;
    }

    protected Collection getGenerateEditorChildren(Object object) {
        return Collections.EMPTY_LIST;
    }

    protected Collection getGenerateTestsChildren(Object object) {
        return Collections.EMPTY_LIST;
    }

    protected Object getParent(Object object) {
        EObject result = ((GenBase)object).eContainer();
        return result instanceof GenBase ? result : null;
    }

    public Diagnostic doGenerate(Object object, Object projectType, Monitor monitor) {
        if (MODEL_PROJECT_TYPE.equals(projectType)) {
            return this.generateModel(object, monitor);
        }
        if (EDIT_PROJECT_TYPE.equals(projectType)) {
            return this.generateEdit(object, monitor);
        }
        if (EDITOR_PROJECT_TYPE.equals(projectType)) {
            return this.generateEditor(object, monitor);
        }
        if (TESTS_PROJECT_TYPE.equals(projectType)) {
            return this.generateTests(object, monitor);
        }
        throw new IllegalArgumentException("Invalid projectType: " + projectType.toString());
    }

    protected Diagnostic generateModel(Object object, Monitor monitor) {
        return Diagnostic.OK_INSTANCE;
    }

    protected Diagnostic generateEdit(Object object, Monitor monitor) {
        return Diagnostic.OK_INSTANCE;
    }

    protected Diagnostic generateEditor(Object object, Monitor monitor) {
        return Diagnostic.OK_INSTANCE;
    }

    protected Diagnostic generateTests(Object object, Monitor monitor) {
        return Diagnostic.OK_INSTANCE;
    }

    protected List getUserTemplatePath() {
        String templateLocation = ((GenBase)this.generatingObject).getGenModel().getTemplateDirectory();
        if (templateLocation != null && templateLocation.length() != 0) {
            if (templateLocation.indexOf(58) == -1) {
                templateLocation = URI.createPlatformResourceURI((String)templateLocation, (boolean)true).toString();
            }
            return Collections.singletonList(templateLocation);
        }
        return Collections.EMPTY_LIST;
    }

    protected void addBaseTemplatePathEntries(List templatePath) {
        templatePath.add(String.valueOf(CodeGenEcorePlugin.INSTANCE.getBaseURL().toString()) + "templates");
        super.addBaseTemplatePathEntries(templatePath);
    }

    protected void addClasspathEntries(JETEmitter jetEmitter) throws JETException {
        jetEmitter.addVariable("EMF_CODEGEN", "org.eclipse.emf.codegen");
        jetEmitter.addVariable("EMF_CODEGEN_ECORE", "org.eclipse.emf.codegen.ecore");
        jetEmitter.addVariable("EMF_COMMON", "org.eclipse.emf.common");
        jetEmitter.addVariable("EMF_ECORE", "org.eclipse.emf.ecore");
    }

    protected void createImportManager(String packageName, String className) {
        super.createImportManager(packageName, className);
        this.updateImportManager();
    }

    protected void clearImportManager() {
        super.clearImportManager();
        this.updateImportManager();
    }

    private void updateImportManager() {
        if (this.generatingObject != null) {
            ((GenBase)this.generatingObject).getGenModel().setImportManager(this.importManager);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void ensureProjectExists(String workspacePath, Object object, Object projectType, boolean force, Monitor monitor) {
        try {
            if (EMFPlugin.IS_ECLIPSE_RUNNING) {
                EclipseHelper.ensureProjectExists(workspacePath, object, projectType, force, monitor);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        monitor.done();
    }

    private static class EclipseHelper {
        private EclipseHelper() {
        }

        public static boolean ensureProjectExists(String workspacePath, Object object, Object projectType, boolean force, Monitor monitor) {
            try {
                Path path = new Path(workspacePath);
                if (path.isAbsolute()) {
                    GenModel genModel = ((GenBase)object).getGenModel();
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    IProject project = workspace.getRoot().getProject(path.segment(0));
                    if (!project.exists() || force) {
                        IPath projectLocation = null;
                        UniqueEList referencedProjects = new UniqueEList();
                        if (project.exists()) {
                            referencedProjects.addAll(Arrays.asList(project.getDescription().getReferencedProjects()));
                            projectLocation = project.getDescription().getLocation();
                        } else {
                            URI genModelURI = genModel.eResource().getURI();
                            if (genModelURI.toString().startsWith("platform:/resource/")) {
                                IProject genModelProject = workspace.getRoot().getProject(genModelURI.segments()[1]);
                                projectLocation = genModelProject.getDescription().getLocation();
                            }
                        }
                        IProject modelProject = workspace.getRoot().getProject(genModel.getModelProjectDirectory());
                        Path javaSource = new Path(genModel.getModelDirectory());
                        int style = 0;
                        if (GenBaseGeneratorAdapter.MODEL_PROJECT_TYPE.equals(projectType)) {
                            style = Generator.EMF_MODEL_PROJECT_STYLE;
                        }
                        if (GenBaseGeneratorAdapter.EDIT_PROJECT_TYPE.equals(projectType)) {
                            style = Generator.EMF_EDIT_PROJECT_STYLE;
                        }
                        if (GenBaseGeneratorAdapter.EDITOR_PROJECT_TYPE.equals(projectType)) {
                            style = Generator.EMF_EDITOR_PROJECT_STYLE;
                        }
                        if (GenBaseGeneratorAdapter.TESTS_PROJECT_TYPE.equals(projectType)) {
                            style = Generator.EMF_TESTS_PROJECT_STYLE;
                        }
                        if ((style & Generator.EMF_TESTS_PROJECT_STYLE) != 0) {
                            IProject testsProject = workspace.getRoot().getProject(genModel.getTestsProjectDirectory());
                            if (!genModel.sameModelTestsProject()) {
                                javaSource = new Path(genModel.getTestsDirectory());
                                if (testsProject.exists()) {
                                    projectLocation = testsProject.getDescription().getLocation();
                                }
                                referencedProjects.add(modelProject);
                                referencedProjects.addAll(Arrays.asList(modelProject.getDescription().getReferencedProjects()));
                            }
                        } else if ((style & Generator.EMF_MODEL_PROJECT_STYLE) == 0 && genModel.hasEditSupport()) {
                            IProject editProject = workspace.getRoot().getProject(genModel.getEditProjectDirectory());
                            if (!genModel.sameModelEditProject()) {
                                javaSource = new Path(genModel.getEditDirectory());
                                if (editProject.exists()) {
                                    projectLocation = editProject.getDescription().getLocation();
                                }
                                referencedProjects.add(modelProject);
                            }
                            Iterator i = genModel.getUsedGenPackages().iterator();
                            while (i.hasNext()) {
                                IProject otherEditProject;
                                GenModel otherGenModel = ((GenPackage)i.next()).getGenModel();
                                if (!otherGenModel.hasEditSupport() || !(otherEditProject = workspace.getRoot().getProject(otherGenModel.getEditProjectDirectory())).exists()) continue;
                                referencedProjects.add(otherEditProject);
                                referencedProjects.addAll(Arrays.asList(otherEditProject.getDescription().getReferencedProjects()));
                            }
                            if ((style & Generator.EMF_EDIT_PROJECT_STYLE) == 0 && genModel.hasEditorSupport()) {
                                javaSource = new Path(genModel.getEditorDirectory());
                                if (!genModel.sameEditEditorProject()) {
                                    referencedProjects.add(editProject);
                                    referencedProjects.addAll(Arrays.asList(editProject.getDescription().getReferencedProjects()));
                                }
                            }
                        }
                        Iterator i = referencedProjects.iterator();
                        while (i.hasNext()) {
                            IProject referencedProject = (IProject)i.next();
                            IJavaProject referencedJavaProject = JavaCore.create((IProject)referencedProject);
                            if (referencedJavaProject.exists()) continue;
                            i.remove();
                        }
                        if (projectLocation != null) {
                            projectLocation = projectLocation.removeLastSegments(1).append(javaSource.segment(0));
                        }
                        if (genModel.hasXMLDependency()) {
                            style |= Generator.EMF_XML_PROJECT_STYLE;
                        }
                        if ((style & Generator.EMF_MODEL_PROJECT_STYLE) == 0 || genModel.hasPluginSupport()) {
                            style |= Generator.EMF_PLUGIN_PROJECT_STYLE;
                        }
                        Generator.createEMFProject((IPath)javaSource, projectLocation, (List)referencedProjects, monitor, style, genModel.getEffectiveModelPluginVariables());
                    }
                    return workspace.getRoot().getProject(path.segment(0)).exists();
                }
            }
            catch (Exception exception) {
                CodeGenEcorePlugin.INSTANCE.log(exception);
            }
            return false;
        }
    }
}

