/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql;

import ca.sqlpower.sql.DBConnectionSpec;
import ca.sqlpower.sql.DatabaseListReadException;
import ca.sqlpower.sql.SQL;
import ca.sqlpower.sql.XMLFileDBCSSource;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.List;

public class BeanGenerator {
    public static final String VERSION_STRING = "SQLPower BeanGenerator v1.0";
    PrintWriter out;
    ResultSetMetaData md;
    String tableName;
    String className;
    String packageName;
    String uniqueIdColName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanGenerator(ResultSet rs, String schemaName, String tableName, String packageName, String destDir) throws SQLException, IOException {
        this.md = rs.getMetaData();
        this.tableName = tableName;
        this.className = BeanGenerator.convertToClassName(tableName);
        List priKey = SQL.findPrimaryKey(rs.getStatement().getConnection(), schemaName, tableName);
        this.uniqueIdColName = (String)priKey.get(priKey.size() - 1);
        try {
            this.out = new PrintWriter(new FileOutputStream(destDir + this.className + ".java"));
            this.outputPackageStatement();
            this.outputImports();
            this.outputDeclaration();
            this.outputConstructor();
            this.outputStoreMethod();
            this.outputFindMethod();
            this.outputSetGetMethods();
            this.outputEnding();
        }
        finally {
            this.out.close();
        }
    }

    void outputPackageStatement() {
        if (this.packageName != null && this.packageName.length() > 0) {
            this.out.print("package ");
            this.out.println(this.packageName);
            this.out.println();
        }
    }

    void outputImports() {
        this.out.println("import java.sql.*;");
        this.out.println("import ca.sqlpower.sql.SQL;");
        this.out.println();
    }

    void outputDeclaration() throws SQLException {
        this.out.println("/**");
        this.out.println(" * The " + this.className + " class is a database persistence ");
        this.out.println(" * object which is tightly coupled with the underlying ");
        this.out.println(" * " + this.tableName + " database table.");
        this.out.println(" * ");
        this.out.println(" * @author Autogenerated by SQLPower BeanGenerator v1.0");
        this.out.println(" * @version Autogenerated on " + new Date());
        this.out.println(" */");
        this.out.println("public class " + this.className + " {");
        this.out.print("    protected static final String UNIQUE_ID_COL_NAME=\"");
        this.out.print(this.uniqueIdColName);
        this.out.println("\";");
        this.out.println("    protected boolean _alreadyInDatabase;");
        for (int col = 1; col <= this.md.getColumnCount(); ++col) {
            this.out.print("    protected String ");
            this.out.print(BeanGenerator.convertToMemberName(this.md.getColumnName(col)));
            this.out.println(";");
        }
        this.out.println();
    }

    void outputConstructor() throws SQLException {
        this.out.println("    public " + this.className + "() {");
        this.out.println("        _alreadyInDatabase=false;");
        for (int col = 1; col <= this.md.getColumnCount(); ++col) {
            this.out.print("        ");
            this.out.print(BeanGenerator.convertToMemberName(this.md.getColumnName(col)));
            this.out.println("=null;");
        }
        this.out.println("    }");
        this.out.println();
    }

    void outputStoreMethod() throws SQLException {
        int col;
        StringBuffer upd = new StringBuffer(1000);
        upd.append("UPDATE ");
        upd.append(this.tableName);
        upd.append(" SET (");
        for (int col2 = 1; col2 <= this.md.getColumnCount(); ++col2) {
            if (col2 > 1) {
                upd.append(", ");
            }
            upd.append(this.md.getColumnName(col2));
            upd.append("=\"+SQL.quote(");
            upd.append(BeanGenerator.convertToMemberName(this.md.getColumnName(col2)));
            upd.append(")+\"");
        }
        upd.append(") WHERE \"+UNIQUE_ID_COL_NAME+\" = \"+");
        upd.append("SQL.quote(getUniqueId())");
        StringBuffer ins = new StringBuffer(1000);
        ins.append("INSERT INTO ");
        ins.append(this.tableName);
        ins.append("(");
        for (col = 1; col <= this.md.getColumnCount(); ++col) {
            if (col > 1) {
                ins.append(", ");
            }
            ins.append(this.md.getColumnName(col));
        }
        ins.append(") VALUES (");
        for (col = 1; col <= this.md.getColumnCount(); ++col) {
            if (col > 1) {
                ins.append(", ");
            }
            ins.append("\"+SQL.quote(");
            ins.append(BeanGenerator.convertToMemberName(this.md.getColumnName(col)));
            ins.append(")+\"");
        }
        ins.append(")\"");
        this.out.println("    public void store(Connection con) throws SQLException {");
        this.out.println("        Statement stmt=null;");
        this.out.println("        try {");
        this.out.println("            stmt=con.createStatement();");
        this.out.println("            if(_alreadyInDatabase) {");
        this.out.println("                stmt.executeUpdate(\"" + upd.toString() + ");");
        this.out.println("            } else {");
        this.out.println("                stmt.executeUpdate(\"" + ins.toString() + ");");
        this.out.println("                _alreadyInDatabase=true;");
        this.out.println("            }");
        this.out.println("        } finally {");
        this.out.println("            if(stmt != null) {");
        this.out.println("                stmt.close();");
        this.out.println("            }");
        this.out.println("        }");
        this.out.println("    }");
    }

    void outputFindMethod() throws SQLException {
        int col;
        StringBuffer sql = new StringBuffer(1000);
        sql.append("SELECT ");
        for (col = 1; col <= this.md.getColumnCount(); ++col) {
            if (col > 1) {
                sql.append(", ");
            }
            sql.append(this.md.getColumnName(col));
        }
        sql.append(" FROM ");
        sql.append(this.tableName);
        sql.append(" WHERE ");
        sql.append(this.uniqueIdColName);
        sql.append(" = \"+");
        sql.append("SQL.quote(");
        sql.append(BeanGenerator.convertToMemberName(this.uniqueIdColName));
        sql.append(")+\"");
        this.out.print("    public static ");
        this.out.print(this.className);
        this.out.print(" findByPrimaryKey(Connection con, String ");
        this.out.print(BeanGenerator.convertToMemberName(this.uniqueIdColName));
        this.out.println(") throws SQLException {");
        this.out.println("        Statement stmt=null;");
        this.out.println("        ResultSet rs=null;");
        this.out.println("        try {");
        this.out.println("            stmt=con.createStatement();");
        this.out.println("            rs=stmt.executeQuery(\"" + sql.toString() + "\");");
        this.out.println("            if(!rs.next()) { return null; }");
        this.out.println("            " + this.className + " newBean=new " + this.className + "();");
        this.out.println("            newBean._alreadyInDatabase=true;");
        for (col = 1; col <= this.md.getColumnCount(); ++col) {
            this.out.print("            newBean.set");
            this.out.print(BeanGenerator.convertToClassName(this.md.getColumnName(col)));
            this.out.print("(rs.getString(");
            this.out.print(col);
            this.out.println("));");
        }
        this.out.println("            return newBean;");
        this.out.println("        } finally {");
        this.out.println("            if(stmt != null) {");
        this.out.println("                stmt.close();");
        this.out.println("            }");
        this.out.println("        }");
        this.out.println("    }");
    }

    void outputSetGetMethods() throws SQLException {
        this.out.println("    public String getUniqueId() {");
        this.out.print("        return get");
        this.out.print(BeanGenerator.convertToClassName(this.uniqueIdColName));
        this.out.println("();");
        this.out.println("    }");
        this.out.println();
        for (int col = 1; col <= this.md.getColumnCount(); ++col) {
            String Member = BeanGenerator.convertToClassName(this.md.getColumnName(col));
            String member = BeanGenerator.convertToMemberName(this.md.getColumnName(col));
            this.out.println("    public String get" + Member + "() {");
            this.out.print("        return ");
            this.out.print(member);
            this.out.println(";");
            this.out.println("    }");
            this.out.println();
            this.out.println("    public void set" + Member + "(String v) {");
            this.out.print("        ");
            this.out.print(member);
            this.out.println("=v;");
            this.out.println("    }");
            this.out.println();
        }
    }

    void outputEnding() throws SQLException {
        this.out.println("}");
    }

    static String convertToClassName(String underscores) {
        return BeanGenerator.convertToCamelCaps(underscores, true);
    }

    static String convertToMemberName(String underscores) {
        return BeanGenerator.convertToCamelCaps(underscores, false);
    }

    static String convertToCamelCaps(String underscores, boolean initialCap) {
        boolean nextCharIsUpper = initialCap;
        StringBuffer camelCaps = new StringBuffer(underscores.length());
        for (int srcIndex = 0; srcIndex < underscores.length(); ++srcIndex) {
            char c = underscores.charAt(srcIndex);
            if (c == '_') {
                nextCharIsUpper = true;
                continue;
            }
            if (nextCharIsUpper) {
                c = Character.toUpperCase(c);
                nextCharIsUpper = false;
            } else {
                c = Character.toLowerCase(c);
            }
            camelCaps.append(c);
        }
        return camelCaps.toString();
    }

    public static void main(String[] args) throws Exception {
        try {
            String dbxml = "databases.xml";
            String name = args[0];
            XMLFileDBCSSource xmlSource = new XMLFileDBCSSource(dbxml);
            List dbcsList = xmlSource.getDBCSList();
            DBConnectionSpec dbcs = DBConnectionSpec.searchListForName(dbcsList, name);
            if (dbcs == null) {
                System.err.println("No database definition '" + name + "' in " + dbxml + ".");
                return;
            }
            String dbclass = dbcs.getDriverClass();
            String dburl = dbcs.getUrl();
            String dbuser = dbcs.getUser();
            String dbpass = dbcs.getPass();
            String schemaName = args[1];
            String tableName = args[2];
            Class.forName(dbclass).newInstance();
            Connection con = DriverManager.getConnection(dburl, dbuser, dbpass);
            Statement stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName);
            new BeanGenerator(rs, schemaName, tableName, null, "");
            con.close();
        }
        catch (Exception e) {
            if (e instanceof DatabaseListReadException) {
                System.out.println("Caught DatabaseListReadException. Root cause:");
                ((DatabaseListReadException)e).getRootCause().printStackTrace();
            }
            e.printStackTrace();
        }
    }
}

