/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.AbstractAction;
import org.apache.log4j.Logger;

public class ZoomAction
extends AbstractAction
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(ZoomAction.class);
    protected PlayPen playpen;
    protected double zoomStep;
    public static final String ZOOM_IN = "ca.sqlpower.architect.swingui.ZoomAction.ZOOM_IN";
    public static final String ZOOM_OUT = "ca.sqlpower.architect.swingui.ZoomAction.ZOOM_OUT";
    public static final String ZOOM_ALL = "ca.sqlpower.architect.swingui.ZoomAction.ZOOM_ALL";

    public ZoomAction(double amount) {
        super(amount > 0.0 ? "Zoom In" : "Zoom Out", ASUtils.createJLFIcon(amount > 0.0 ? "general/ZoomIn" : "general/ZoomOut", amount > 0.0 ? "Zoom In" : "Zoom Out", ArchitectFrame.getMainInstance().getSprefs().getInt("SwingUserSettings.ICON_SIZE", 24)));
        this.putValue("ShortDescription", amount > 0.0 ? "Zoom In" : "Zoom Out");
        this.zoomStep = amount;
    }

    public void actionPerformed(ActionEvent e) {
        logger.debug((Object)("oldZoom=" + this.playpen.getZoom() + ",zoomStep=" + this.zoomStep));
        this.playpen.setZoom(this.playpen.getZoom() * Math.pow(2.0, this.zoomStep));
        logger.debug((Object)("newZoom=" + this.playpen.getZoom()));
        Rectangle scrollTo = null;
        Iterator<PlayPenComponent> it = this.playpen.getSelectedItems().iterator();
        while (it.hasNext()) {
            Rectangle bounds = it.next().getBounds();
            logger.debug((Object)("new rectangle, bounds: " + bounds));
            if (scrollTo == null) {
                scrollTo = new Rectangle(bounds);
                continue;
            }
            logger.debug((Object)("added rectangles, new bounds: " + scrollTo));
            scrollTo.add(bounds);
        }
        if (scrollTo != null && !scrollTo.isEmpty()) {
            this.playpen.zoomRect(scrollTo);
            this.playpen.scrollRectToVisible(scrollTo);
        }
    }

    public void setPlayPen(PlayPen pp) {
        if (this.playpen != null) {
            this.playpen.removePropertyChangeListener(this);
        }
        this.playpen = pp;
        this.playpen.addPropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent e) {
    }
}

