/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.undo.UndoManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class UndoAction
extends AbstractAction {
    private static final Logger logger = Logger.getLogger(UndoAction.class);
    private UndoManager manager;
    private ChangeListener managerListener = new ManagerListener();

    public UndoAction() {
        this.putValue("SmallIcon", ASUtils.createJLFIcon("general/Undo", "Undo", ArchitectFrame.getMainInstance().getSwingUserSettings().getInt("SwingUserSettings.ICON_SIZE", 24)));
        this.putValue("Name", "Undo");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.updateSettingsFromManager();
    }

    public void actionPerformed(ActionEvent evt) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)this.manager);
            int choice = JOptionPane.showConfirmDialog(null, "Undo manager state dumped to logger.\n\nProceed with undo?");
            if (choice == 0) {
                this.manager.undo();
            }
        } else {
            this.manager.undo();
        }
    }

    public void setManager(UndoManager manager) {
        if (this.manager != null) {
            this.manager.removeChangeListener(this.managerListener);
        }
        this.manager = manager;
        if (this.manager != null) {
            this.manager.addChangeListener(this.managerListener);
        }
        this.updateSettingsFromManager();
    }

    private void updateSettingsFromManager() {
        if (this.manager == null) {
            this.putValue("ShortDescription", "Can't Undo");
            this.setEnabled(false);
        } else {
            this.putValue("ShortDescription", this.manager.getUndoPresentationName());
            this.setEnabled(this.manager.canUndo());
        }
    }

    private class ManagerListener
    implements ChangeListener {
        private ManagerListener() {
        }

        public void stateChanged(ChangeEvent e) {
            UndoAction.this.updateSettingsFromManager();
        }
    }
}

