/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.jdbc;

import ca.sqlpower.architect.jdbc.DatabaseMetaDataDecorator;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

public class OracleDatabaseMetaDataDecorator
extends DatabaseMetaDataDecorator {
    private static final int DREADED_ORACLE_ERROR_CODE_1722 = 1722;
    private static final String ORACLE_1722_MESSAGE = "That caught ORA-1722; in this context it normally means that you are using the Oracle 10 driver with Oracle 8. Please check your driver settings";
    private static final int DREADED_ORACLE_ERROR_CODE_1031 = 1031;
    private static final String ORACLE_1031_MESSAGE = "That caught ORA-1031; in this context it normally means that you are accessing Indices without having the 'analyze any' permission";

    public OracleDatabaseMetaDataDecorator(DatabaseMetaData delegate) {
        super(delegate);
    }

    public ResultSet getTypeInfo() throws SQLException {
        try {
            return super.getTypeInfo();
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 1722) {
                SQLException newE = new SQLException(ORACLE_1722_MESSAGE);
                newE.setNextException(e);
                throw newE;
            }
            throw e;
        }
    }

    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        try {
            return super.getIndexInfo(catalog, schema, table, unique, approximate);
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 1031) {
                SQLException newE = new SQLException(ORACLE_1031_MESSAGE);
                newE.setNextException(e);
                throw newE;
            }
            throw e;
        }
    }
}

