/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.utils;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;

public final class Utilities {
    private Utilities() {
    }

    public static String[] tokenize(String string) {
        return Utilities.tokenize(string, " \t\n\r\f");
    }

    public static String[] tokenize(String string, String string2) {
        if (string == null) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    public static int rnd(int n) {
        return (int)(Math.random() * (double)n);
    }

    public static float[] parsePattern(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        float[] fArray = new float[stringTokenizer.countTokens()];
        if (fArray.length > 0) {
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                fArray[n++] = Float.parseFloat(stringTokenizer.nextToken());
            }
        }
        return fArray;
    }

    public static String getClassNameWithoutPackage(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46) + 1;
        if (n == -1) {
            n = 0;
        }
        String string2 = string.substring(n);
        return string2;
    }

    public static void center(Window window) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = window.getSize();
        window.setLocation(dimension.width / 2 - dimension2.width / 2, dimension.height / 2 - dimension2.height / 2);
    }

    public static boolean createDirectoryRecursively(File file) {
        String string;
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return true;
        }
        if (!file.isAbsolute()) {
            file = new File(file.getAbsolutePath());
        }
        if ((string = file.getParent()) == null) {
            return false;
        }
        if (!Utilities.createDirectoryRecursively(new File(string))) {
            return false;
        }
        file.mkdir();
        return file.exists();
    }

    public static final Properties readPropertiesFromFile(Frame frame, File file) {
        try {
            return Utilities.readPropertiesFromFile(frame, file.getAbsolutePath());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static final Properties readPropertiesFromFile(Frame frame, String string) {
        try {
            return Utilities.readPropertiesFromFile(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static final Properties readPropertiesFromFile(String string) throws IOException, Exception {
        File file = null;
        FileInputStream fileInputStream = null;
        Properties properties = new Properties();
        try {
            file = new File(string);
            if (file.exists()) {
                fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    fileInputStream = null;
                    throw iOException;
                }
                fileInputStream = null;
            }
        }
        return properties;
    }

    public static final void writePropertiesToFile(Frame frame, Properties properties, File file, String string) {
        try {
            Utilities.writePropertiesToFile(frame, properties, file.getAbsolutePath(), string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static final void writePropertiesToFile(Frame frame, Properties properties, String string, String string2) {
        try {
            Utilities.writePropertiesToFile(properties, string, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static final void writePropertiesToFile(Properties properties, String string, String string2) throws IOException, Exception {
        FileOutputStream fileOutputStream = null;
        try {
            if (properties != null) {
                fileOutputStream = new FileOutputStream(string);
                System.out.println("Writing properties file: " + string);
                properties.save(fileOutputStream, string2);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    fileOutputStream = null;
                    throw iOException;
                }
                fileOutputStream = null;
            }
        }
    }
}

