/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src;

import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.ElementFormat;
import org.openide.src.ElementPrinter;
import org.openide.src.ElementPrinterInterruptException;
import org.openide.src.Identifier;
import org.openide.src.MethodParameter;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.util.NbBundle;

public final class MethodElement
extends ConstructorElement {
    private static final ElementFormat HEADER_FORMAT = new ElementFormat("{m,,\" \"}{r} {n}({a}){e,\" throws \",}");
    static final long serialVersionUID = 2366156788906032138L;

    public MethodElement() {
        this(new Memory(), null);
    }

    public MethodElement(Impl impl, ClassElement clazz) {
        super(impl, clazz);
    }

    public Object clone() {
        return new MethodElement(new Memory(this), null);
    }

    final Impl getMethodImpl() {
        return (Impl)this.impl;
    }

    public Type getReturn() {
        return this.getMethodImpl().getReturn();
    }

    public void setReturn(Type ret) throws SourceException {
        this.getMethodImpl().setReturn(ret);
    }

    public int getModifiersMask() {
        if (this.isDeclaredInInterface()) {
            return 1025;
        }
        return 1343;
    }

    public final void setName(Identifier name) throws SourceException {
        ClassElement c = this.getDeclaringClass();
        if (c != null) {
            MethodParameter[] params = this.getParameters();
            Type[] types = new Type[params.length];
            for (int i = 0; i < types.length; ++i) {
                types[i] = params[i].getType();
            }
            MethodElement m = c.getMethod(name, types);
            if (m != null && m != this) {
                String msg = NbBundle.getMessage((Class)ElementFormat.class, (String)"FMT_EXC_RenameMethod", (Object)c.getName().getName(), (Object)name);
                this.throwSourceException(msg);
            }
        }
        super.setName(name);
    }

    ElementFormat getFormat() {
        return HEADER_FORMAT;
    }

    void printerMark(ElementPrinter printer, int what) throws ElementPrinterInterruptException {
        printer.markMethod(this, what);
    }

    static class Memory
    extends ConstructorElement.Memory
    implements Impl {
        private Type type;
        static final long serialVersionUID = 2015834437815195149L;

        Memory() {
            this.type = Type.VOID;
        }

        Memory(MethodElement el) {
            super(el);
            this.type = el.getReturn();
        }

        public Type getReturn() {
            return this.type;
        }

        public void setReturn(Type ret) {
            Type t = this.type;
            this.type = ret;
            this.firePropertyChange("return", t, ret);
        }

        public Object readResolve() {
            return new MethodElement(this, null);
        }
    }

    public static final class Key
    extends ConstructorElement.Key {
        private Identifier name;
        private Type returnType;

        public Key(Identifier name, Type[] params) {
            super(params);
            this.name = name;
        }

        public Key(Identifier name, Type[] params, Type returnType) {
            this(name, params);
            this.returnType = returnType;
        }

        public Key(MethodElement me) {
            super(me);
            this.name = me.getName();
        }

        public Key(MethodElement me, boolean checkReturn) {
            this(me);
            if (checkReturn) {
                this.returnType = me.getReturn();
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            if (!this.name.equals(other.name) || !super.equals(obj)) {
                return false;
            }
            if (this.returnType == null || other.returnType == null) {
                return true;
            }
            return this.returnType.equals(other.returnType);
        }

        public int hashCode() {
            return super.hashCode() ^ this.name.getFullName().hashCode();
        }
    }

    public static interface Impl
    extends ConstructorElement.Impl {
        public static final long serialVersionUID = 7273573865765501815L;

        public Type getReturn();

        public void setReturn(Type var1) throws SourceException;
    }
}

