/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.InitializerElement;
import org.openide.src.MemberElement;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.Type;

abstract class MemoryCollection
implements Serializable {
    LinkedList array;
    ClassElement.Memory memory;
    private Element insertionMark;
    private boolean insertAfter;
    private String propertyName;
    private Object[] template;
    static final long serialVersionUID = -9215370960397120952L;

    public MemoryCollection(ClassElement.Memory memory, String propertyName, Object[] emptyArray) {
        this.memory = memory;
        this.propertyName = propertyName;
        this.template = emptyArray;
    }

    Collection makeClones(Object[] els) {
        List contents = this.array == null ? Collections.EMPTY_LIST : this.array;
        HashSet hashContents = new HashSet(contents.size() * 4 / 3 + 1);
        Iterator it = contents.iterator();
        while (it.hasNext()) {
            Object e = it.next();
            hashContents.add(e);
        }
        ArrayList<Object> result = new ArrayList<Object>(els.length);
        for (int i = 0; i < els.length; ++i) {
            Object el = els[i];
            if (!hashContents.contains(el)) {
                result.add(this.clone(el));
                continue;
            }
            result.add(el);
        }
        return result;
    }

    Collection cloneElements(Object[] els) {
        ArrayList<Object> n = new ArrayList<Object>(els.length);
        for (int i = 0; i < els.length; ++i) {
            n.add(this.clone(els[i]));
        }
        return n;
    }

    protected abstract Object clone(Object var1);

    public void change(Object[] arr, int action) {
        Collection<Object> data;
        switch (action) {
            case 1: {
                data = this.cloneElements(arr);
                break;
            }
            case -1: {
                data = Arrays.asList(arr);
                break;
            }
            case 0: {
                data = this.makeClones(arr);
                break;
            }
            default: {
                return;
            }
        }
        this.change(data, action);
    }

    protected void change(Collection c, int action) {
        boolean anChange;
        switch (action) {
            case 1: {
                boolean bl = anChange = c.size() > 0;
                if (this.array != null) {
                    if (this.insertionMark != null) {
                        int index = this.array.indexOf(this.insertionMark);
                        if (index == -1) {
                            this.insertionMark = null;
                            index = this.array.size();
                        } else if (this.insertAfter) {
                            ++index;
                        }
                        this.array.addAll(index, c);
                        break;
                    }
                    this.array.addAll(c);
                    break;
                }
            }
            case 0: {
                anChange = c.size() > 0 || this.array != null && this.array.size() > 0;
                this.array = new LinkedList(c);
                this.insertionMark = null;
                break;
            }
            case -1: {
                Element newMark = null;
                if (this.insertionMark != null && c.contains(this.insertionMark)) {
                    HashSet removing = new HashSet(c.size() * 4 / 3);
                    removing.addAll(c);
                    int markIndex = this.array.indexOf(this.insertionMark);
                    if (markIndex == -1) {
                        this.insertionMark = null;
                    } else {
                        Object x;
                        ListIterator it = this.array.listIterator(markIndex);
                        while (it.hasNext()) {
                            x = it.next();
                            if (removing.contains(x)) continue;
                            newMark = (Element)x;
                            this.insertAfter = false;
                            break;
                        }
                        if (newMark == null) {
                            it = this.array.listIterator(markIndex);
                            while (it.hasPrevious()) {
                                x = it.previous();
                                if (removing.contains(x)) continue;
                                newMark = (Element)x;
                                this.insertAfter = true;
                                break;
                            }
                        }
                    }
                    this.insertionMark = newMark;
                }
                anChange = this.array != null && this.array.removeAll(c);
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        if (anChange) {
            this.memory.firePropertyChange(this.propertyName, null, null);
        }
    }

    public Object[] toArray() {
        if (this.array == null) {
            return this.template;
        }
        return this.array.toArray(this.template);
    }

    void markCurrent(Element el, boolean after) {
        this.insertionMark = el;
        this.insertAfter = after;
    }

    static class Class
    extends Member {
        private static final ClassElement[] EMPTY = new ClassElement[0];
        static final long serialVersionUID = 3206093459760846163L;

        public Class(ClassElement.Memory ce) {
            super(ce, "classes", EMPTY);
        }

        public MemberElement find(Identifier name, Type[] types) {
            if (this.array == null) {
                return null;
            }
            Iterator it = this.array.iterator();
            while (it.hasNext()) {
                String fname;
                ClassElement ce = (ClassElement)it.next();
                Identifier cname = ce.getName();
                if (name.getFullName().equals(cname.getFullName())) {
                    return ce;
                }
                if (!name.getName().equals(cname.getName()) || !(fname = name.getFullName()).equals(name.getName())) continue;
                return ce;
            }
            return null;
        }

        protected Object clone(Object obj) {
            ClassElement.Memory ceMem = new ClassElement.Memory((ClassElement)obj);
            ClassElement newElement = new ClassElement((ClassElement.Impl)ceMem, this.memory.getClassElement());
            ceMem.initialize((ClassElement)obj);
            return newElement;
        }
    }

    static class Field
    extends Member {
        private static final FieldElement[] EMPTY = new FieldElement[0];
        static final long serialVersionUID = 5747776340409139399L;

        public Field(ClassElement.Memory ce) {
            super(ce, "fields", EMPTY);
        }

        protected Object clone(Object obj) {
            return new FieldElement(new FieldElement.Memory((FieldElement)obj), this.memory.getClassElement());
        }
    }

    static class Method
    extends Member {
        private static final MethodElement[] EMPTY = new MethodElement[0];
        static final long serialVersionUID = -745714645316747109L;

        public Method(ClassElement.Memory ce) {
            super(ce, "methods", EMPTY);
        }

        protected Object clone(Object obj) {
            return new MethodElement(new MethodElement.Memory((MethodElement)obj), this.memory.getClassElement());
        }
    }

    static class Constructor
    extends Member {
        private static final ConstructorElement[] EMPTY = new ConstructorElement[0];
        static final long serialVersionUID = 4314343816469864217L;

        public Constructor(ClassElement.Memory ce) {
            super(ce, "constructors", EMPTY);
        }

        protected Object clone(Object obj) {
            ConstructorElement.Memory m = new ConstructorElement.Memory((ConstructorElement)obj);
            Identifier id = this.memory.getName();
            if (id != null) {
                m.setName(Identifier.create(id.getName()));
            }
            return new ConstructorElement(m, this.memory.getClassElement());
        }
    }

    static abstract class Member
    extends MemoryCollection {
        static final long serialVersionUID = 7875426480834524238L;

        public Member(ClassElement.Memory memory, String propertyName, Object[] emptyArray) {
            super(memory, propertyName, emptyArray);
        }

        public MemberElement find(Identifier id, Type[] types) {
            if (this.array == null) {
                return null;
            }
            Iterator it = this.array.iterator();
            while (it.hasNext()) {
                MemberElement me = (MemberElement)it.next();
                if (id != null && !id.equals(me.getName()) || types != null && !Member.equalTypes(types, me)) continue;
                return me;
            }
            return null;
        }

        private static boolean equalTypes(Type[] types, MemberElement el) {
            MethodParameter[] test = ((ConstructorElement)el).getParameters();
            if (test.length != types.length) {
                return false;
            }
            int l = test.length;
            for (int i = 0; i < l; ++i) {
                if (test[i].getType().equals(types[i])) continue;
                return false;
            }
            return true;
        }
    }

    static final class Initializer
    extends MemoryCollection {
        private static final InitializerElement[] EMPTY = new InitializerElement[0];
        static final long serialVersionUID = 5715072242254795093L;

        public Initializer(ClassElement.Memory memory) {
            super(memory, "initializers", EMPTY);
        }

        protected Object clone(Object el) {
            return new InitializerElement(new InitializerElement.Memory((InitializerElement)el), this.memory.getClassElement());
        }
    }

    static final class Interface
    extends MemoryCollection {
        Interface(ClassElement.Memory memory) {
            super(memory, "interfaces", new Identifier[0]);
        }

        Collection makeClones(Object[] arr) {
            return Arrays.asList(arr);
        }

        Collection cloneElements(Object[] arr) {
            return Arrays.asList(arr);
        }

        protected Object clone(Object o) {
            return o;
        }
    }
}

