/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.InitializerElement;
import org.openide.src.MemberElement;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.Type;
import org.openide.util.NbBundle;

public final class ElementFormat
extends Format {
    static final long serialVersionUID = 3775521938640169753L;
    private static final String PROPERTIES_NAMES_INDEX = "mnfCtrscpaie";
    private static final String[] PROPERTIES_NAMES = new String[]{"modifiers", "name", "name", "name", "type", "return", "superclass", "static", "parameters", "parameters", "interfaces", "exceptions"};
    private static final byte STATUS_OUTSIDE = 0;
    private static final byte STATUS_INSIDE = 1;
    private static final byte STATUS_RBRACE = 2;
    private String pattern;
    private boolean source;
    private transient LinkedList list;

    public ElementFormat(String pattern) {
        this.applyPattern(pattern);
        this.source = true;
    }

    public void setSourceFormat(boolean source) {
        this.source = source;
    }

    public boolean isSourceFormat() {
        return this.source;
    }

    public String getPattern() {
        return this.pattern;
    }

    public StringBuffer format(Object o, StringBuffer toAppendTo, FieldPosition pos) {
        try {
            Element element = (Element)o;
            Iterator it = this.list.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (obj instanceof String) {
                    toAppendTo.append((String)obj);
                    continue;
                }
                ((Tag)obj).format(element, toAppendTo);
            }
            return toAppendTo;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(NbBundle.getMessage((Class)ElementFormat.class, (String)"MSG_badArgument"));
        }
    }

    public String format(Element element) {
        return this.format(element, new StringBuffer(), null).toString();
    }

    public boolean dependsOnProperty(String prop) {
        Iterator it = this.list.iterator();
        while (it.hasNext()) {
            int index;
            Object obj = it.next();
            if (!(obj instanceof Tag) || !PROPERTIES_NAMES[index = PROPERTIES_NAMES_INDEX.indexOf(((Tag)obj).kind)].equals(prop)) continue;
            return true;
        }
        return false;
    }

    public Object parseObject(String source, ParsePosition status) {
        return null;
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.applyPattern(this.pattern);
    }

    private void applyPattern(String pattern) {
        this.pattern = pattern;
        this.list = new LinkedList();
        int status = 0;
        StringTokenizer tokenizer = new StringTokenizer(pattern, "{}", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            switch (status) {
                case 0: {
                    if (token.equals("}")) {
                        throw new IllegalArgumentException(NbBundle.getMessage((Class)ElementFormat.class, (String)"MSG_badPattern"));
                    }
                    if (token.equals("{")) {
                        status = 1;
                        break;
                    }
                    this.list.add(token);
                    break;
                }
                case 1: {
                    if (token.equals("{") || token.equals("}")) {
                        throw new IllegalArgumentException(NbBundle.getMessage((Class)ElementFormat.class, (String)"MSG_badPattern"));
                    }
                    this.list.add(this.createTag(token));
                    status = 2;
                    break;
                }
                case 2: {
                    if (!token.equals("}")) {
                        throw new IllegalArgumentException(NbBundle.getMessage((Class)ElementFormat.class, (String)"MSG_badPattern"));
                    }
                    status = 0;
                }
            }
        }
    }

    private Tag createTag(String s) {
        if (s.length() > 0) {
            char c = s.charAt(0);
            String[] params = new String[]{};
            if (s.length() > 1) {
                if (s.length() < 2 || s.charAt(1) != ',') {
                    throw new IllegalArgumentException(NbBundle.getMessage((Class)ElementFormat.class, (String)"MSG_badPattern"));
                }
                params = this.parseParams(s.substring(2));
            }
            if ("mnfCtrsc".indexOf(c) != -1) {
                switch (params.length) {
                    case 0: {
                        return new Tag(c, "", "");
                    }
                    case 2: {
                        return new Tag(c, params[0], params[1]);
                    }
                }
            } else if ("paie".indexOf(c) != -1) {
                switch (params.length) {
                    case 0: {
                        return new ArrayTag(c, "", "", ", ");
                    }
                    case 2: {
                        return new ArrayTag(c, params[0], params[1], ", ");
                    }
                    case 3: {
                        return new ArrayTag(c, params[0], params[1], params[2]);
                    }
                }
            }
        }
        throw new IllegalArgumentException(NbBundle.getMessage((Class)ElementFormat.class, (String)"MSG_badPattern"));
    }

    private String[] parseParams(String s) {
        StringTokenizer tokenizer = new StringTokenizer(s, ",", true);
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer token = new StringBuffer();
        boolean comma = false;
        boolean inString = false;
        while (tokenizer.hasMoreTokens()) {
            String t = tokenizer.nextToken();
            if (inString) {
                token.append(t);
                if (!t.endsWith("\"")) continue;
                if (token.length() > 1) {
                    token.setLength(token.length() - 1);
                }
                list.add(token.toString());
                token.setLength(0);
                inString = false;
                comma = true;
                continue;
            }
            if (t.equals(",")) {
                if (comma) {
                    comma = false;
                    continue;
                }
                list.add("");
                continue;
            }
            if (comma) {
                throw new IllegalArgumentException(NbBundle.getMessage((Class)ElementFormat.class, (String)"MSG_badPattern"));
            }
            String stringToAdd = t;
            if (t.startsWith("\"")) {
                if (t.endsWith("\"") && t.length() > 1) {
                    stringToAdd = t.length() <= 2 ? "" : t.substring(1, t.length() - 1);
                } else {
                    token.append(t.substring(1));
                    inString = true;
                    continue;
                }
            }
            list.add(stringToAdd);
            comma = true;
            token.setLength(0);
        }
        if (!comma) {
            list.add("");
        }
        String[] ret = new String[list.size()];
        list.toArray(ret);
        return ret;
    }

    private static void resolveClassName(StringBuffer sb, ClassElement element) {
        ClassElement c = element.getDeclaringClass();
        if (c == null) {
            sb.append(element.getName().getName());
            return;
        }
        ElementFormat.resolveClassName(sb, c);
        sb.append('.').append(element.getName().getName());
    }

    String identifierToString(Identifier id) {
        return this.source ? id.getSourceName() : id.getFullName();
    }

    String typeToString(Type id) {
        return this.source ? id.getSourceString() : id.getFullString();
    }

    private class ArrayTag
    extends Tag {
        String delim;
        static final long serialVersionUID = 2060398944304753010L;

        ArrayTag(char kind, String prefix, String suffix, String delim) {
            super(kind, prefix, suffix);
            this.delim = delim;
        }

        void format(Element element, StringBuffer buf) {
            try {
                int mark = buf.length();
                buf.append(this.prefix);
                switch (this.kind) {
                    case 'e': {
                        Identifier[] ids = ((ConstructorElement)element).getExceptions();
                        for (int i = 0; i < ids.length; ++i) {
                            if (i > 0) {
                                buf.append(this.delim);
                            }
                            buf.append(ElementFormat.this.identifierToString(ids[i]));
                        }
                        break;
                    }
                    case 'a': 
                    case 'p': {
                        MethodParameter[] args = ((ConstructorElement)element).getParameters();
                        for (int i = 0; i < args.length; ++i) {
                            if (i > 0) {
                                buf.append(this.delim);
                            }
                            if (this.kind == 'a') {
                                args[i].getAsString(buf, ElementFormat.this.source);
                                continue;
                            }
                            args[i].getType().getAsString(buf, ElementFormat.this.source);
                        }
                        break;
                    }
                    case 'i': {
                        Identifier[] ids = ((ClassElement)element).getInterfaces();
                        for (int i = 0; i < ids.length; ++i) {
                            if (i > 0) {
                                buf.append(this.delim);
                            }
                            buf.append(ElementFormat.this.identifierToString(ids[i]));
                        }
                        break;
                    }
                }
                if (buf.length() > mark + this.prefix.length()) {
                    buf.append(this.suffix);
                } else {
                    buf.setLength(mark);
                }
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(NbBundle.getMessage((Class)(class$org$openide$src$ElementFormat == null ? (class$org$openide$src$ElementFormat = ElementFormat.class$("org.openide.src.ElementFormat")) : class$org$openide$src$ElementFormat), (String)"MSG_badPattern"));
            }
        }
    }

    private class Tag
    implements Serializable {
        char kind;
        String prefix;
        String suffix;
        static final long serialVersionUID = 4946774706959011193L;

        Tag(char kind, String prefix, String suffix) {
            this.kind = kind;
            this.prefix = prefix;
            this.suffix = suffix;
        }

        void format(Element element, StringBuffer buf) {
            try {
                int mark = buf.length();
                buf.append(this.prefix);
                switch (this.kind) {
                    case 'm': {
                        buf.append(Modifier.toString(((MemberElement)element).getModifiers()));
                        break;
                    }
                    case 'n': {
                        buf.append(ElementFormat.this.identifierToString(((MemberElement)element).getName()));
                        break;
                    }
                    case 'f': {
                        buf.append(((MemberElement)element).getName().getFullName());
                        break;
                    }
                    case 'C': {
                        ElementFormat.resolveClassName(buf, (ClassElement)element);
                        break;
                    }
                    case 't': {
                        buf.append(ElementFormat.this.typeToString(((FieldElement)element).getType()));
                        break;
                    }
                    case 'r': {
                        buf.append(ElementFormat.this.typeToString(((MethodElement)element).getReturn()));
                        break;
                    }
                    case 's': {
                        Identifier id = ((ClassElement)element).getSuperclass();
                        if (id == null) break;
                        buf.append(ElementFormat.this.identifierToString(id));
                        break;
                    }
                    case 'c': {
                        if (!((InitializerElement)element).isStatic()) break;
                        buf.append(Modifier.toString(8));
                    }
                }
                if (buf.length() > mark + this.prefix.length()) {
                    buf.append(this.suffix);
                } else {
                    buf.setLength(mark);
                }
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(NbBundle.getMessage((Class)(class$org$openide$src$ElementFormat == null ? (class$org$openide$src$ElementFormat = ElementFormat.class$("org.openide.src.ElementFormat")) : class$org$openide$src$ElementFormat), (String)"MSG_badPattern"));
            }
        }
    }
}

