/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.users;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.Locale;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.users.RoleForm;

public final class SetUpRoleAction
extends Action {
    private MBeanServer mserver = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.mserver == null) {
            this.mserver = ((ApplicationServlet)this.getServlet()).getServer();
        }
        MessageResources resources = this.getResources(request);
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        String databaseName = URLDecoder.decode(request.getParameter("databaseName"), "UTF-8");
        String objectName = request.getParameter("objectName");
        RoleForm roleForm = new RoleForm();
        if (objectName == null) {
            roleForm.setNodeLabel(resources.getMessage(locale, "users.role.newRole"));
            roleForm.setObjectName(null);
        } else {
            roleForm.setNodeLabel(resources.getMessage(locale, "users.role.oldRole"));
            roleForm.setObjectName(objectName);
            String attribute = null;
            try {
                ObjectName oname = new ObjectName(objectName);
                attribute = "rolename";
                roleForm.setRolename((String)this.mserver.getAttribute(oname, attribute));
                attribute = "description";
                roleForm.setDescription((String)this.mserver.getAttribute(oname, attribute));
            }
            catch (Exception e) {
                this.getServlet().log(resources.getMessage(locale, "users.error.attribute.get", (Object)attribute), (Throwable)e);
                response.sendError(500, resources.getMessage(locale, "users.error.attribute.get", (Object)attribute));
                return null;
            }
        }
        roleForm.setDatabaseName(databaseName);
        this.saveToken(request);
        request.setAttribute("roleForm", (Object)roleForm);
        return mapping.findForward("Role");
    }
}

