/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support.ui;

import java.awt.Component;
import java.awt.Image;
import java.awt.Panel;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.spi.java.project.support.ui.PackageViewChildren;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.ErrorManager;
import org.openide.actions.FileSystemAction;
import org.openide.actions.FindAction;
import org.openide.actions.PasteAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openidex.search.SearchInfo;
import org.openidex.search.SearchInfoFactory;

final class PackageRootNode
extends AbstractNode
implements Runnable,
FileStatusListener {
    static Image PACKAGE_BADGE = Utilities.loadImage((String)"org/netbeans/spi/java/project/support/ui/packageBadge.gif");
    private static Action[] actions;
    private SourceGroup group;
    private final FileObject file;
    private final Set files;
    private FileStatusListener fileSystemListener;
    private RequestProcessor.Task task;
    private volatile boolean iconChange;
    private volatile boolean nameChange;
    private static Component CONVERTOR_COMPONENT;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$netbeans$spi$java$project$support$ui$PackageRootNode;

    PackageRootNode(SourceGroup group) {
        this(group, new InstanceContent());
    }

    private PackageRootNode(SourceGroup group, InstanceContent ic) {
        super((Children)new PackageViewChildren(group.getRootFolder()), (Lookup)new ProxyLookup(new Lookup[]{PackageRootNode.createLookup(group), new AbstractLookup((AbstractLookup.Content)ic)}));
        ic.add((Object)PackageRootNode.alwaysSearchableSearchInfo(SearchInfoFactory.createSearchInfoBySubnodes((Node)this)));
        this.group = group;
        this.file = group.getRootFolder();
        this.files = Collections.singleton(this.file);
        try {
            FileSystem fs = this.file.getFileSystem();
            this.fileSystemListener = FileUtil.weakFileStatusListener((FileStatusListener)this, (Object)fs);
            fs.addFileStatusListener(this.fileSystemListener);
        }
        catch (FileStateInvalidException e) {
            ErrorManager err = ErrorManager.getDefault();
            err.annotate((Throwable)e, "Can not get " + this.file + " filesystem, ignoring...");
            err.notify(1, (Throwable)e);
        }
        this.setName(group.getName());
        this.setDisplayName(group.getDisplayName());
    }

    public Image getIcon(int type) {
        return this.computeIcon(false, type);
    }

    public Image getOpenedIcon(int type) {
        return this.computeIcon(true, type);
    }

    public String getDisplayName() {
        String s = super.getDisplayName();
        try {
            s = this.file.getFileSystem().getStatus().annotateName(s, this.files);
        }
        catch (FileStateInvalidException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return s;
    }

    public String getHtmlDisplayName() {
        try {
            FileSystem.Status stat = this.file.getFileSystem().getStatus();
            if (stat instanceof FileSystem.HtmlStatus) {
                FileSystem.HtmlStatus hstat = (FileSystem.HtmlStatus)stat;
                String result = hstat.annotateNameHtml(super.getDisplayName(), this.files);
                if (!super.getDisplayName().equals(result)) {
                    return result;
                }
            }
        }
        catch (FileStateInvalidException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return super.getHtmlDisplayName();
    }

    public void run() {
        if (this.iconChange) {
            this.fireIconChange();
            this.fireOpenedIconChange();
            this.iconChange = false;
        }
        if (this.nameChange) {
            this.fireDisplayNameChange(null, null);
            this.nameChange = false;
        }
    }

    public void annotationChanged(FileStatusEvent event) {
        if (this.task == null) {
            this.task = RequestProcessor.getDefault().create((Runnable)this);
        }
        if ((!this.iconChange && event.isIconChange() || !this.nameChange && event.isNameChange()) && event.hasChanged(this.file)) {
            this.iconChange |= event.isIconChange();
            this.nameChange |= event.isNameChange();
        }
        this.task.schedule(50);
    }

    public Action[] getActions(boolean context) {
        if (actions == null) {
            actions = new Action[]{CommonProjectActions.newFileAction(), null, SystemAction.get((Class)FileSystemAction.class), null, SystemAction.get((Class)FindAction.class), null, SystemAction.get((Class)PasteAction.class), null, SystemAction.get((Class)ToolsAction.class)};
        }
        return actions;
    }

    public Node.PropertySet[] getPropertySets() {
        Node.PropertySet[] properties = this.getDataFolderNodeDelegate().getPropertySets();
        for (int i = 0; i < properties.length; ++i) {
            if (!"properties".equals(properties[i].getName())) continue;
            properties[i] = Sheet.createPropertiesSet();
            ((Sheet.Set)properties[i]).put((Node.Property)new PropertySupport.ReadOnly("name", class$java$lang$String == null ? PackageRootNode.class$("java.lang.String") : class$java$lang$String, NbBundle.getMessage((Class)(class$org$netbeans$spi$java$project$support$ui$PackageRootNode == null ? PackageRootNode.class$("org.netbeans.spi.java.project.support.ui.PackageRootNode") : class$org$netbeans$spi$java$project$support$ui$PackageRootNode), (String)"PROP_name"), NbBundle.getMessage((Class)(class$org$netbeans$spi$java$project$support$ui$PackageRootNode == null ? PackageRootNode.class$("org.netbeans.spi.java.project.support.ui.PackageRootNode") : class$org$netbeans$spi$java$project$support$ui$PackageRootNode), (String)"HINT_name")){

                public Object getValue() {
                    return PackageRootNode.this.getDisplayName();
                }
            });
            ((Sheet.Set)properties[i]).put((Node.Property)new PropertySupport.ReadOnly("ROOT_PATH", class$java$lang$String == null ? PackageRootNode.class$("java.lang.String") : class$java$lang$String, NbBundle.getMessage((Class)(class$org$netbeans$spi$java$project$support$ui$PackageRootNode == null ? PackageRootNode.class$("org.netbeans.spi.java.project.support.ui.PackageRootNode") : class$org$netbeans$spi$java$project$support$ui$PackageRootNode), (String)"PROP_rootpath"), NbBundle.getMessage((Class)(class$org$netbeans$spi$java$project$support$ui$PackageRootNode == null ? PackageRootNode.class$("org.netbeans.spi.java.project.support.ui.PackageRootNode") : class$org$netbeans$spi$java$project$support$ui$PackageRootNode), (String)"HINT_rootpath")){

                public Object getValue() {
                    return FileUtil.getFileDisplayName((FileObject)PackageRootNode.this.file);
                }
            });
        }
        return properties;
    }

    public void createPasteTypes(Transferable t, List list) {
        if (t.isDataFlavorSupported(ExTransferable.multiFlavor)) {
            try {
                MultiTransferObject mto = (MultiTransferObject)t.getTransferData(ExTransferable.multiFlavor);
                ArrayList<PackageViewChildren.PackageNode> l = new ArrayList<PackageViewChildren.PackageNode>();
                boolean isPackageFlavor = false;
                boolean hasTheSameRoot = false;
                int op = -1;
                for (int i = 0; i < mto.getCount(); ++i) {
                    Transferable pt = mto.getTransferableAt(i);
                    DataFlavor[] flavors = mto.getTransferDataFlavors(i);
                    for (int j = 0; j < flavors.length; ++j) {
                        if (!"x-java-org-netbeans-modules-java-project-packagenodednd".equals(flavors[j].getSubType()) || !"application".equals(flavors[j].getPrimaryType())) continue;
                        if (op == -1) {
                            op = Integer.valueOf(flavors[j].getParameter("mask"));
                        }
                        PackageViewChildren.PackageNode pkgNode = (PackageViewChildren.PackageNode)((Object)pt.getTransferData(flavors[j]));
                        if (!((PackageViewChildren)this.getChildren()).getRoot().equals(pkgNode.getRoot())) {
                            l.add(pkgNode);
                        } else {
                            hasTheSameRoot = true;
                        }
                        isPackageFlavor = true;
                    }
                }
                if (isPackageFlavor && !hasTheSameRoot) {
                    list.add(new PackageViewChildren.PackagePasteType(this.group.getRootFolder(), l.toArray(new PackageViewChildren.PackageNode[l.size()]), op));
                } else if (!isPackageFlavor) {
                    list.addAll(Arrays.asList(this.getDataFolderNodeDelegate().getPasteTypes(t)));
                }
            }
            catch (UnsupportedFlavorException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        } else {
            DataFlavor[] flavors = t.getTransferDataFlavors();
            FileObject root = this.group.getRootFolder();
            boolean isPackageFlavor = false;
            if (root != null && root.canWrite()) {
                for (int i = 0; i < flavors.length; ++i) {
                    if (!"x-java-org-netbeans-modules-java-project-packagenodednd".equals(flavors[i].getSubType()) || !"application".equals(flavors[i].getPrimaryType())) continue;
                    isPackageFlavor = true;
                    try {
                        int op = Integer.valueOf(flavors[i].getParameter("mask"));
                        PackageViewChildren.PackageNode pkgNode = (PackageViewChildren.PackageNode)((Object)t.getTransferData(flavors[i]));
                        if (((PackageViewChildren)this.getChildren()).getRoot().equals(pkgNode.getRoot())) continue;
                        list.add(new PackageViewChildren.PackagePasteType(root, new PackageViewChildren.PackageNode[]{pkgNode}, op));
                        continue;
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify((Throwable)ioe);
                        continue;
                    }
                    catch (UnsupportedFlavorException ufe) {
                        ErrorManager.getDefault().notify((Throwable)ufe);
                    }
                }
            }
            if (!isPackageFlavor) {
                list.addAll(Arrays.asList(this.getDataFolderNodeDelegate().getPasteTypes(t)));
            }
        }
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        PasteType pasteType = super.getDropType(t, action, index);
        if (pasteType instanceof PackageViewChildren.PackagePasteType) {
            ((PackageViewChildren.PackagePasteType)pasteType).setOperation(action);
        }
        return pasteType;
    }

    private Node getDataFolderNodeDelegate() {
        return ((DataFolder)this.getLookup().lookup(DataFolder.class)).getNodeDelegate();
    }

    private Image computeIcon(boolean opened, int type) {
        Image image;
        Icon icon = this.group.getIcon(opened);
        if (icon == null) {
            image = opened ? this.getDataFolderNodeDelegate().getOpenedIcon(type) : this.getDataFolderNodeDelegate().getIcon(type);
            image = Utilities.mergeImages((Image)image, (Image)PACKAGE_BADGE, (int)7, (int)7);
        } else {
            image = icon instanceof ImageIcon ? ((ImageIcon)icon).getImage() : PackageRootNode.icon2image(icon);
        }
        return image;
    }

    static Image icon2image(Icon icon) {
        int height = icon.getIconHeight();
        int width = icon.getIconWidth();
        BufferedImage bImage = new BufferedImage(width, height, 2);
        icon.paintIcon(CONVERTOR_COMPONENT, bImage.getGraphics(), 0, 0);
        return bImage;
    }

    private static Lookup createLookup(SourceGroup group) {
        FileObject rootFolder = group.getRootFolder();
        DataFolder dataFolder = DataFolder.findFolder((FileObject)rootFolder);
        return Lookups.fixed((Object[])new Object[]{dataFolder, new PathFinder(group)});
    }

    static SearchInfo alwaysSearchableSearchInfo(SearchInfo i) {
        return new AlwaysSearchableSearchInfo(i);
    }

    static {
        CONVERTOR_COMPONENT = new Panel();
    }

    private static final class AlwaysSearchableSearchInfo
    implements SearchInfo {
        private final SearchInfo delegate;

        public AlwaysSearchableSearchInfo(SearchInfo delegate) {
            this.delegate = delegate;
        }

        public boolean canSearch() {
            return true;
        }

        public Iterator objectsToSearch() {
            return this.delegate.objectsToSearch();
        }
    }

    public static class PathFinder {
        private SourceGroup group;

        public PathFinder(SourceGroup group) {
            this.group = group;
        }

        public Node findPath(Node root, Object object) {
            FileObject fo;
            if (object instanceof FileObject) {
                fo = (FileObject)object;
            } else if (object instanceof DataObject) {
                fo = ((DataObject)object).getPrimaryFile();
            } else {
                return null;
            }
            FileObject groupRoot = this.group.getRootFolder();
            if (FileUtil.isParentOf((FileObject)groupRoot, (FileObject)fo)) {
                String relPath = FileUtil.getRelativePath((FileObject)groupRoot, (FileObject)fo);
                int lastSlashIndex = relPath.lastIndexOf(47);
                String[] path = null;
                if (fo.isFolder()) {
                    String packageName = relPath.replace('/', '.');
                    path = new String[]{packageName};
                } else if (lastSlashIndex == -1) {
                    path = new String[]{"", fo.getName()};
                } else {
                    String packageName = relPath.substring(0, lastSlashIndex).replace('/', '.');
                    path = new String[]{packageName, fo.getName()};
                }
                try {
                    return NodeOp.findPath((Node)root, (String[])path);
                }
                catch (NodeNotFoundException e) {
                    if (!fo.isFolder()) {
                        if (lastSlashIndex == -1) {
                            path = new String[]{"", fo.getNameExt()};
                        } else {
                            String packageName = relPath.substring(0, lastSlashIndex).replace('/', '.');
                            path = new String[]{packageName, fo.getNameExt()};
                        }
                        try {
                            return NodeOp.findPath((Node)root, (String[])path);
                        }
                        catch (NodeNotFoundException e2) {
                            // empty catch block
                        }
                    }
                    return null;
                }
            }
            if (groupRoot.equals(fo)) {
                try {
                    return NodeOp.findPath((Node)root, (String[])new String[]{""});
                }
                catch (NodeNotFoundException e) {
                    return root;
                }
            }
            return null;
        }

        public String toString() {
            return "PathFinder[" + this.group + "]";
        }
    }
}

